<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerLeadsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCustomerLeadsRequest
 * @subpackage Structs
 */
class GetCustomerLeadsRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerLeadID;
    /**
     * The GreaterThanCustomerLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GreaterThanCustomerLeadID;
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BatchSize;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetCustomerLeadsRequest
     * @uses GetCustomerLeadsRequest::setCustomerID()
     * @uses GetCustomerLeadsRequest::setCustomerLeadID()
     * @uses GetCustomerLeadsRequest::setGreaterThanCustomerLeadID()
     * @uses GetCustomerLeadsRequest::setBatchSize()
     * @uses GetCustomerLeadsRequest::setCustomerKey()
     * @param int $customerID
     * @param int $customerLeadID
     * @param int $greaterThanCustomerLeadID
     * @param int $batchSize
     * @param string $customerKey
     */
    public function __construct($customerID = null, $customerLeadID = null, $greaterThanCustomerLeadID = null, $batchSize = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerLeadID($customerLeadID)
            ->setGreaterThanCustomerLeadID($greaterThanCustomerLeadID)
            ->setBatchSize($batchSize)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetCustomerLeadsRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerLeadID value
     * @return int
     */
    public function getCustomerLeadID()
    {
        return $this->CustomerLeadID;
    }
    /**
     * Set CustomerLeadID value
     * @param int $customerLeadID
     * @return \StructType\GetCustomerLeadsRequest
     */
    public function setCustomerLeadID($customerLeadID = null)
    {
        // validation for constraint: int
        if (!is_null($customerLeadID) && !is_numeric($customerLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerLeadID)), __LINE__);
        }
        $this->CustomerLeadID = $customerLeadID;
        return $this;
    }
    /**
     * Get GreaterThanCustomerLeadID value
     * @return int
     */
    public function getGreaterThanCustomerLeadID()
    {
        return $this->GreaterThanCustomerLeadID;
    }
    /**
     * Set GreaterThanCustomerLeadID value
     * @param int $greaterThanCustomerLeadID
     * @return \StructType\GetCustomerLeadsRequest
     */
    public function setGreaterThanCustomerLeadID($greaterThanCustomerLeadID = null)
    {
        // validation for constraint: int
        if (!is_null($greaterThanCustomerLeadID) && !is_numeric($greaterThanCustomerLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($greaterThanCustomerLeadID)), __LINE__);
        }
        $this->GreaterThanCustomerLeadID = $greaterThanCustomerLeadID;
        return $this;
    }
    /**
     * Get BatchSize value
     * @return int
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \StructType\GetCustomerLeadsRequest
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetCustomerLeadsRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerLeadsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
