<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCountryRegionsResponse StructType
 * @subpackage Structs
 */
class GetCountryRegionsResponse extends ApiResponse
{
    /**
     * The Countries
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCountryResponse
     */
    public $Countries;
    /**
     * The SelectedCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SelectedCountry;
    /**
     * The Regions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegionResponse
     */
    public $Regions;
    /**
     * Constructor method for GetCountryRegionsResponse
     * @uses GetCountryRegionsResponse::setCountries()
     * @uses GetCountryRegionsResponse::setSelectedCountry()
     * @uses GetCountryRegionsResponse::setRegions()
     * @param \ArrayType\ArrayOfCountryResponse $countries
     * @param string $selectedCountry
     * @param \ArrayType\ArrayOfRegionResponse $regions
     */
    public function __construct(\ArrayType\ArrayOfCountryResponse $countries = null, $selectedCountry = null, \ArrayType\ArrayOfRegionResponse $regions = null)
    {
        $this
            ->setCountries($countries)
            ->setSelectedCountry($selectedCountry)
            ->setRegions($regions);
    }
    /**
     * Get Countries value
     * @return \ArrayType\ArrayOfCountryResponse|null
     */
    public function getCountries()
    {
        return $this->Countries;
    }
    /**
     * Set Countries value
     * @param \ArrayType\ArrayOfCountryResponse $countries
     * @return \StructType\GetCountryRegionsResponse
     */
    public function setCountries(\ArrayType\ArrayOfCountryResponse $countries = null)
    {
        $this->Countries = $countries;
        return $this;
    }
    /**
     * Get SelectedCountry value
     * @return string|null
     */
    public function getSelectedCountry()
    {
        return $this->SelectedCountry;
    }
    /**
     * Set SelectedCountry value
     * @param string $selectedCountry
     * @return \StructType\GetCountryRegionsResponse
     */
    public function setSelectedCountry($selectedCountry = null)
    {
        // validation for constraint: string
        if (!is_null($selectedCountry) && !is_string($selectedCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selectedCountry)), __LINE__);
        }
        $this->SelectedCountry = $selectedCountry;
        return $this;
    }
    /**
     * Get Regions value
     * @return \ArrayType\ArrayOfRegionResponse|null
     */
    public function getRegions()
    {
        return $this->Regions;
    }
    /**
     * Set Regions value
     * @param \ArrayType\ArrayOfRegionResponse $regions
     * @return \StructType\GetCountryRegionsResponse
     */
    public function setRegions(\ArrayType\ArrayOfRegionResponse $regions = null)
    {
        $this->Regions = $regions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCountryRegionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
