<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompanyNewsItemRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCompanyNewsItemRequest
 * @subpackage Structs
 */
class GetCompanyNewsItemRequest extends ApiRequest
{
    /**
     * The NewsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NewsID;
    /**
     * Constructor method for GetCompanyNewsItemRequest
     * @uses GetCompanyNewsItemRequest::setNewsID()
     * @param int $newsID
     */
    public function __construct($newsID = null)
    {
        $this
            ->setNewsID($newsID);
    }
    /**
     * Get NewsID value
     * @return int
     */
    public function getNewsID()
    {
        return $this->NewsID;
    }
    /**
     * Set NewsID value
     * @param int $newsID
     * @return \StructType\GetCompanyNewsItemRequest
     */
    public function setNewsID($newsID = null)
    {
        // validation for constraint: int
        if (!is_null($newsID) && !is_numeric($newsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newsID)), __LINE__);
        }
        $this->NewsID = $newsID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCompanyNewsItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
