<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForwardedAttachment StructType
 * @subpackage Structs
 */
class ForwardedAttachment extends AbstractStructBase
{
    /**
     * The MailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailID;
    /**
     * The AttachmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachmentID;
    /**
     * Constructor method for ForwardedAttachment
     * @uses ForwardedAttachment::setMailID()
     * @uses ForwardedAttachment::setAttachmentID()
     * @param int $mailID
     * @param int $attachmentID
     */
    public function __construct($mailID = null, $attachmentID = null)
    {
        $this
            ->setMailID($mailID)
            ->setAttachmentID($attachmentID);
    }
    /**
     * Get MailID value
     * @return int
     */
    public function getMailID()
    {
        return $this->MailID;
    }
    /**
     * Set MailID value
     * @param int $mailID
     * @return \StructType\ForwardedAttachment
     */
    public function setMailID($mailID = null)
    {
        // validation for constraint: int
        if (!is_null($mailID) && !is_numeric($mailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mailID)), __LINE__);
        }
        $this->MailID = $mailID;
        return $this;
    }
    /**
     * Get AttachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->AttachmentID;
    }
    /**
     * Set AttachmentID value
     * @param int $attachmentID
     * @return \StructType\ForwardedAttachment
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !is_numeric($attachmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attachmentID)), __LINE__);
        }
        $this->AttachmentID = $attachmentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForwardedAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
