<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpectedPaymentResponse StructType
 * @subpackage Structs
 */
class ExpectedPaymentResponse extends AbstractStructBase
{
    /**
     * The ExpectedPaymentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpectedPaymentID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderID;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The AuthorizationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for ExpectedPaymentResponse
     * @uses ExpectedPaymentResponse::setExpectedPaymentID()
     * @uses ExpectedPaymentResponse::setCustomerID()
     * @uses ExpectedPaymentResponse::setPaymentType()
     * @uses ExpectedPaymentResponse::setPaymentDate()
     * @uses ExpectedPaymentResponse::setAmount()
     * @uses ExpectedPaymentResponse::setOrderID()
     * @uses ExpectedPaymentResponse::setCurrencyCode()
     * @uses ExpectedPaymentResponse::setBillingName()
     * @uses ExpectedPaymentResponse::setAuthorizationCode()
     * @uses ExpectedPaymentResponse::setOrderKey()
     * @uses ExpectedPaymentResponse::setCustomerKey()
     * @param int $expectedPaymentID
     * @param int $customerID
     * @param string $paymentType
     * @param string $paymentDate
     * @param float $amount
     * @param int $orderID
     * @param string $currencyCode
     * @param string $billingName
     * @param string $authorizationCode
     * @param string $orderKey
     * @param string $customerKey
     */
    public function __construct($expectedPaymentID = null, $customerID = null, $paymentType = null, $paymentDate = null, $amount = null, $orderID = null, $currencyCode = null, $billingName = null, $authorizationCode = null, $orderKey = null, $customerKey = null)
    {
        $this
            ->setExpectedPaymentID($expectedPaymentID)
            ->setCustomerID($customerID)
            ->setPaymentType($paymentType)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount)
            ->setOrderID($orderID)
            ->setCurrencyCode($currencyCode)
            ->setBillingName($billingName)
            ->setAuthorizationCode($authorizationCode)
            ->setOrderKey($orderKey)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get ExpectedPaymentID value
     * @return int
     */
    public function getExpectedPaymentID()
    {
        return $this->ExpectedPaymentID;
    }
    /**
     * Set ExpectedPaymentID value
     * @param int $expectedPaymentID
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setExpectedPaymentID($expectedPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($expectedPaymentID) && !is_numeric($expectedPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expectedPaymentID)), __LINE__);
        }
        $this->ExpectedPaymentID = $expectedPaymentID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \EnumType\PaymentType::valueIsValid()
     * @uses \EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentType, implode(', ', \EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\ExpectedPaymentResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExpectedPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
