<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartmentInfo StructType
 * @subpackage Structs
 */
class DepartmentInfo extends AbstractStructBase
{
    /**
     * The DepartmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepartmentType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for DepartmentInfo
     * @uses DepartmentInfo::setDepartmentType()
     * @uses DepartmentInfo::setDescription()
     * @param int $departmentType
     * @param string $description
     */
    public function __construct($departmentType = null, $description = null)
    {
        $this
            ->setDepartmentType($departmentType)
            ->setDescription($description);
    }
    /**
     * Get DepartmentType value
     * @return int
     */
    public function getDepartmentType()
    {
        return $this->DepartmentType;
    }
    /**
     * Set DepartmentType value
     * @param int $departmentType
     * @return \StructType\DepartmentInfo
     */
    public function setDepartmentType($departmentType = null)
    {
        // validation for constraint: int
        if (!is_null($departmentType) && !is_numeric($departmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($departmentType)), __LINE__);
        }
        $this->DepartmentType = $departmentType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DepartmentInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepartmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
