<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteWebCategoryResponse StructType
 * @subpackage Structs
 */
class DeleteWebCategoryResponse extends ApiResponse
{
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryID;
    /**
     * The WebID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WebID;
    /**
     * Constructor method for DeleteWebCategoryResponse
     * @uses DeleteWebCategoryResponse::setCategoryID()
     * @uses DeleteWebCategoryResponse::setWebID()
     * @param int $categoryID
     * @param int $webID
     */
    public function __construct($categoryID = null, $webID = null)
    {
        $this
            ->setCategoryID($categoryID)
            ->setWebID($webID);
    }
    /**
     * Get CategoryID value
     * @return int
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\DeleteWebCategoryResponse
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get WebID value
     * @return int
     */
    public function getWebID()
    {
        return $this->WebID;
    }
    /**
     * Set WebID value
     * @param int $webID
     * @return \StructType\DeleteWebCategoryResponse
     */
    public function setWebID($webID = null)
    {
        // validation for constraint: int
        if (!is_null($webID) && !is_numeric($webID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webID)), __LINE__);
        }
        $this->WebID = $webID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteWebCategoryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
