<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerWallItemResponse StructType
 * @subpackage Structs
 */
class CustomerWallItemResponse extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The WallItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WallItemID;
    /**
     * The EntryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntryDate;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Field1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field1;
    /**
     * The Field2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field2;
    /**
     * The Field3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field3;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CustomerWallItemResponse
     * @uses CustomerWallItemResponse::setCustomerID()
     * @uses CustomerWallItemResponse::setWallItemID()
     * @uses CustomerWallItemResponse::setEntryDate()
     * @uses CustomerWallItemResponse::setText()
     * @uses CustomerWallItemResponse::setField1()
     * @uses CustomerWallItemResponse::setField2()
     * @uses CustomerWallItemResponse::setField3()
     * @uses CustomerWallItemResponse::setCustomerKey()
     * @param int $customerID
     * @param int $wallItemID
     * @param string $entryDate
     * @param string $text
     * @param string $field1
     * @param string $field2
     * @param string $field3
     * @param string $customerKey
     */
    public function __construct($customerID = null, $wallItemID = null, $entryDate = null, $text = null, $field1 = null, $field2 = null, $field3 = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setWallItemID($wallItemID)
            ->setEntryDate($entryDate)
            ->setText($text)
            ->setField1($field1)
            ->setField2($field2)
            ->setField3($field3)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CustomerWallItemResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get WallItemID value
     * @return int
     */
    public function getWallItemID()
    {
        return $this->WallItemID;
    }
    /**
     * Set WallItemID value
     * @param int $wallItemID
     * @return \StructType\CustomerWallItemResponse
     */
    public function setWallItemID($wallItemID = null)
    {
        // validation for constraint: int
        if (!is_null($wallItemID) && !is_numeric($wallItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($wallItemID)), __LINE__);
        }
        $this->WallItemID = $wallItemID;
        return $this;
    }
    /**
     * Get EntryDate value
     * @return string
     */
    public function getEntryDate()
    {
        return $this->EntryDate;
    }
    /**
     * Set EntryDate value
     * @param string $entryDate
     * @return \StructType\CustomerWallItemResponse
     */
    public function setEntryDate($entryDate = null)
    {
        // validation for constraint: string
        if (!is_null($entryDate) && !is_string($entryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entryDate)), __LINE__);
        }
        $this->EntryDate = $entryDate;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\CustomerWallItemResponse
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Field1 value
     * @return string|null
     */
    public function getField1()
    {
        return $this->Field1;
    }
    /**
     * Set Field1 value
     * @param string $field1
     * @return \StructType\CustomerWallItemResponse
     */
    public function setField1($field1 = null)
    {
        // validation for constraint: string
        if (!is_null($field1) && !is_string($field1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field1)), __LINE__);
        }
        $this->Field1 = $field1;
        return $this;
    }
    /**
     * Get Field2 value
     * @return string|null
     */
    public function getField2()
    {
        return $this->Field2;
    }
    /**
     * Set Field2 value
     * @param string $field2
     * @return \StructType\CustomerWallItemResponse
     */
    public function setField2($field2 = null)
    {
        // validation for constraint: string
        if (!is_null($field2) && !is_string($field2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field2)), __LINE__);
        }
        $this->Field2 = $field2;
        return $this;
    }
    /**
     * Get Field3 value
     * @return string|null
     */
    public function getField3()
    {
        return $this->Field3;
    }
    /**
     * Set Field3 value
     * @param string $field3
     * @return \StructType\CustomerWallItemResponse
     */
    public function setField3($field3 = null)
    {
        // validation for constraint: string
        if (!is_null($field3) && !is_string($field3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field3)), __LINE__);
        }
        $this->Field3 = $field3;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CustomerWallItemResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerWallItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
