<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerResponse StructType
 * @subpackage Structs
 */
class CustomerResponse extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerType;
    /**
     * The CustomerStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerStatus;
    /**
     * The EnrollerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnrollerID;
    /**
     * The SponsorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SponsorID;
    /**
     * The RankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RankID;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The Date1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date1;
    /**
     * The Date2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date2;
    /**
     * The Date3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date3;
    /**
     * The Date4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date4;
    /**
     * The Date5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date5;
    /**
     * The DefaultWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DefaultWarehouseID;
    /**
     * The PayableType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PayableType;
    /**
     * The CheckThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CheckThreshold;
    /**
     * The PriceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceType;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gender;
    /**
     * The IsSalesTaxExempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSalesTaxExempt;
    /**
     * The IsSubscribedToBroadcasts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSubscribedToBroadcasts;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedDate;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModifiedDate;
    /**
     * The BinaryPlacementPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BinaryPlacementPreference;
    /**
     * The UseBinaryHoldingTank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseBinaryHoldingTank;
    /**
     * The MainAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MainAddressVerified;
    /**
     * The MailAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MailAddressVerified;
    /**
     * The OtherAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OtherAddressVerified;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Phone2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone2;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The MainAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress1;
    /**
     * The MainAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress2;
    /**
     * The MainCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCity;
    /**
     * The MainState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainState;
    /**
     * The MainZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainZip;
    /**
     * The MainCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCountry;
    /**
     * The MainCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCounty;
    /**
     * The MailAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress1;
    /**
     * The MailAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress2;
    /**
     * The MailCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCity;
    /**
     * The MailState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailState;
    /**
     * The MailZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailZip;
    /**
     * The MailCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCountry;
    /**
     * The MailCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCounty;
    /**
     * The OtherAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress1;
    /**
     * The OtherAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress2;
    /**
     * The OtherCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCity;
    /**
     * The OtherState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherState;
    /**
     * The OtherZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherZip;
    /**
     * The OtherCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCountry;
    /**
     * The OtherCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCounty;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Field1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field1;
    /**
     * The Field2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field2;
    /**
     * The Field3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field3;
    /**
     * The Field4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field4;
    /**
     * The Field5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field5;
    /**
     * The Field6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field6;
    /**
     * The Field7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field7;
    /**
     * The Field8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field8;
    /**
     * The Field9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field9;
    /**
     * The Field10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field10;
    /**
     * The Field11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field11;
    /**
     * The Field12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field12;
    /**
     * The Field13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field13;
    /**
     * The Field14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field14;
    /**
     * The Field15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field15;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PayableToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayableToName;
    /**
     * The SalesTaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesTaxID;
    /**
     * The VatRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatRegistration;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSuffix;
    /**
     * The MainAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress3;
    /**
     * The MailAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress3;
    /**
     * The OtherAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress3;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The EnrollerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnrollerKey;
    /**
     * The SponsorKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SponsorKey;
    /**
     * Constructor method for CustomerResponse
     * @uses CustomerResponse::setCustomerID()
     * @uses CustomerResponse::setCustomerType()
     * @uses CustomerResponse::setCustomerStatus()
     * @uses CustomerResponse::setEnrollerID()
     * @uses CustomerResponse::setSponsorID()
     * @uses CustomerResponse::setRankID()
     * @uses CustomerResponse::setBirthDate()
     * @uses CustomerResponse::setDate1()
     * @uses CustomerResponse::setDate2()
     * @uses CustomerResponse::setDate3()
     * @uses CustomerResponse::setDate4()
     * @uses CustomerResponse::setDate5()
     * @uses CustomerResponse::setDefaultWarehouseID()
     * @uses CustomerResponse::setPayableType()
     * @uses CustomerResponse::setCheckThreshold()
     * @uses CustomerResponse::setPriceType()
     * @uses CustomerResponse::setLanguageID()
     * @uses CustomerResponse::setGender()
     * @uses CustomerResponse::setIsSalesTaxExempt()
     * @uses CustomerResponse::setIsSubscribedToBroadcasts()
     * @uses CustomerResponse::setCreatedDate()
     * @uses CustomerResponse::setModifiedDate()
     * @uses CustomerResponse::setBinaryPlacementPreference()
     * @uses CustomerResponse::setUseBinaryHoldingTank()
     * @uses CustomerResponse::setMainAddressVerified()
     * @uses CustomerResponse::setMailAddressVerified()
     * @uses CustomerResponse::setOtherAddressVerified()
     * @uses CustomerResponse::setFirstName()
     * @uses CustomerResponse::setLastName()
     * @uses CustomerResponse::setCompany()
     * @uses CustomerResponse::setEmail()
     * @uses CustomerResponse::setPhone()
     * @uses CustomerResponse::setPhone2()
     * @uses CustomerResponse::setMobilePhone()
     * @uses CustomerResponse::setFax()
     * @uses CustomerResponse::setMainAddress1()
     * @uses CustomerResponse::setMainAddress2()
     * @uses CustomerResponse::setMainCity()
     * @uses CustomerResponse::setMainState()
     * @uses CustomerResponse::setMainZip()
     * @uses CustomerResponse::setMainCountry()
     * @uses CustomerResponse::setMainCounty()
     * @uses CustomerResponse::setMailAddress1()
     * @uses CustomerResponse::setMailAddress2()
     * @uses CustomerResponse::setMailCity()
     * @uses CustomerResponse::setMailState()
     * @uses CustomerResponse::setMailZip()
     * @uses CustomerResponse::setMailCountry()
     * @uses CustomerResponse::setMailCounty()
     * @uses CustomerResponse::setOtherAddress1()
     * @uses CustomerResponse::setOtherAddress2()
     * @uses CustomerResponse::setOtherCity()
     * @uses CustomerResponse::setOtherState()
     * @uses CustomerResponse::setOtherZip()
     * @uses CustomerResponse::setOtherCountry()
     * @uses CustomerResponse::setOtherCounty()
     * @uses CustomerResponse::setLoginName()
     * @uses CustomerResponse::setField1()
     * @uses CustomerResponse::setField2()
     * @uses CustomerResponse::setField3()
     * @uses CustomerResponse::setField4()
     * @uses CustomerResponse::setField5()
     * @uses CustomerResponse::setField6()
     * @uses CustomerResponse::setField7()
     * @uses CustomerResponse::setField8()
     * @uses CustomerResponse::setField9()
     * @uses CustomerResponse::setField10()
     * @uses CustomerResponse::setField11()
     * @uses CustomerResponse::setField12()
     * @uses CustomerResponse::setField13()
     * @uses CustomerResponse::setField14()
     * @uses CustomerResponse::setField15()
     * @uses CustomerResponse::setCurrencyCode()
     * @uses CustomerResponse::setPayableToName()
     * @uses CustomerResponse::setSalesTaxID()
     * @uses CustomerResponse::setVatRegistration()
     * @uses CustomerResponse::setMiddleName()
     * @uses CustomerResponse::setNameSuffix()
     * @uses CustomerResponse::setMainAddress3()
     * @uses CustomerResponse::setMailAddress3()
     * @uses CustomerResponse::setOtherAddress3()
     * @uses CustomerResponse::setCustomerKey()
     * @uses CustomerResponse::setEnrollerKey()
     * @uses CustomerResponse::setSponsorKey()
     * @param int $customerID
     * @param int $customerType
     * @param int $customerStatus
     * @param int $enrollerID
     * @param int $sponsorID
     * @param int $rankID
     * @param string $birthDate
     * @param string $date1
     * @param string $date2
     * @param string $date3
     * @param string $date4
     * @param string $date5
     * @param int $defaultWarehouseID
     * @param string $payableType
     * @param float $checkThreshold
     * @param int $priceType
     * @param int $languageID
     * @param string $gender
     * @param bool $isSalesTaxExempt
     * @param bool $isSubscribedToBroadcasts
     * @param string $createdDate
     * @param string $modifiedDate
     * @param int $binaryPlacementPreference
     * @param bool $useBinaryHoldingTank
     * @param bool $mainAddressVerified
     * @param bool $mailAddressVerified
     * @param bool $otherAddressVerified
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $email
     * @param string $phone
     * @param string $phone2
     * @param string $mobilePhone
     * @param string $fax
     * @param string $mainAddress1
     * @param string $mainAddress2
     * @param string $mainCity
     * @param string $mainState
     * @param string $mainZip
     * @param string $mainCountry
     * @param string $mainCounty
     * @param string $mailAddress1
     * @param string $mailAddress2
     * @param string $mailCity
     * @param string $mailState
     * @param string $mailZip
     * @param string $mailCountry
     * @param string $mailCounty
     * @param string $otherAddress1
     * @param string $otherAddress2
     * @param string $otherCity
     * @param string $otherState
     * @param string $otherZip
     * @param string $otherCountry
     * @param string $otherCounty
     * @param string $loginName
     * @param string $field1
     * @param string $field2
     * @param string $field3
     * @param string $field4
     * @param string $field5
     * @param string $field6
     * @param string $field7
     * @param string $field8
     * @param string $field9
     * @param string $field10
     * @param string $field11
     * @param string $field12
     * @param string $field13
     * @param string $field14
     * @param string $field15
     * @param string $currencyCode
     * @param string $payableToName
     * @param string $salesTaxID
     * @param string $vatRegistration
     * @param string $middleName
     * @param string $nameSuffix
     * @param string $mainAddress3
     * @param string $mailAddress3
     * @param string $otherAddress3
     * @param string $customerKey
     * @param string $enrollerKey
     * @param string $sponsorKey
     */
    public function __construct($customerID = null, $customerType = null, $customerStatus = null, $enrollerID = null, $sponsorID = null, $rankID = null, $birthDate = null, $date1 = null, $date2 = null, $date3 = null, $date4 = null, $date5 = null, $defaultWarehouseID = null, $payableType = null, $checkThreshold = null, $priceType = null, $languageID = null, $gender = null, $isSalesTaxExempt = null, $isSubscribedToBroadcasts = null, $createdDate = null, $modifiedDate = null, $binaryPlacementPreference = null, $useBinaryHoldingTank = null, $mainAddressVerified = null, $mailAddressVerified = null, $otherAddressVerified = null, $firstName = null, $lastName = null, $company = null, $email = null, $phone = null, $phone2 = null, $mobilePhone = null, $fax = null, $mainAddress1 = null, $mainAddress2 = null, $mainCity = null, $mainState = null, $mainZip = null, $mainCountry = null, $mainCounty = null, $mailAddress1 = null, $mailAddress2 = null, $mailCity = null, $mailState = null, $mailZip = null, $mailCountry = null, $mailCounty = null, $otherAddress1 = null, $otherAddress2 = null, $otherCity = null, $otherState = null, $otherZip = null, $otherCountry = null, $otherCounty = null, $loginName = null, $field1 = null, $field2 = null, $field3 = null, $field4 = null, $field5 = null, $field6 = null, $field7 = null, $field8 = null, $field9 = null, $field10 = null, $field11 = null, $field12 = null, $field13 = null, $field14 = null, $field15 = null, $currencyCode = null, $payableToName = null, $salesTaxID = null, $vatRegistration = null, $middleName = null, $nameSuffix = null, $mainAddress3 = null, $mailAddress3 = null, $otherAddress3 = null, $customerKey = null, $enrollerKey = null, $sponsorKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerType($customerType)
            ->setCustomerStatus($customerStatus)
            ->setEnrollerID($enrollerID)
            ->setSponsorID($sponsorID)
            ->setRankID($rankID)
            ->setBirthDate($birthDate)
            ->setDate1($date1)
            ->setDate2($date2)
            ->setDate3($date3)
            ->setDate4($date4)
            ->setDate5($date5)
            ->setDefaultWarehouseID($defaultWarehouseID)
            ->setPayableType($payableType)
            ->setCheckThreshold($checkThreshold)
            ->setPriceType($priceType)
            ->setLanguageID($languageID)
            ->setGender($gender)
            ->setIsSalesTaxExempt($isSalesTaxExempt)
            ->setIsSubscribedToBroadcasts($isSubscribedToBroadcasts)
            ->setCreatedDate($createdDate)
            ->setModifiedDate($modifiedDate)
            ->setBinaryPlacementPreference($binaryPlacementPreference)
            ->setUseBinaryHoldingTank($useBinaryHoldingTank)
            ->setMainAddressVerified($mainAddressVerified)
            ->setMailAddressVerified($mailAddressVerified)
            ->setOtherAddressVerified($otherAddressVerified)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setEmail($email)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setMobilePhone($mobilePhone)
            ->setFax($fax)
            ->setMainAddress1($mainAddress1)
            ->setMainAddress2($mainAddress2)
            ->setMainCity($mainCity)
            ->setMainState($mainState)
            ->setMainZip($mainZip)
            ->setMainCountry($mainCountry)
            ->setMainCounty($mainCounty)
            ->setMailAddress1($mailAddress1)
            ->setMailAddress2($mailAddress2)
            ->setMailCity($mailCity)
            ->setMailState($mailState)
            ->setMailZip($mailZip)
            ->setMailCountry($mailCountry)
            ->setMailCounty($mailCounty)
            ->setOtherAddress1($otherAddress1)
            ->setOtherAddress2($otherAddress2)
            ->setOtherCity($otherCity)
            ->setOtherState($otherState)
            ->setOtherZip($otherZip)
            ->setOtherCountry($otherCountry)
            ->setOtherCounty($otherCounty)
            ->setLoginName($loginName)
            ->setField1($field1)
            ->setField2($field2)
            ->setField3($field3)
            ->setField4($field4)
            ->setField5($field5)
            ->setField6($field6)
            ->setField7($field7)
            ->setField8($field8)
            ->setField9($field9)
            ->setField10($field10)
            ->setField11($field11)
            ->setField12($field12)
            ->setField13($field13)
            ->setField14($field14)
            ->setField15($field15)
            ->setCurrencyCode($currencyCode)
            ->setPayableToName($payableToName)
            ->setSalesTaxID($salesTaxID)
            ->setVatRegistration($vatRegistration)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setMainAddress3($mainAddress3)
            ->setMailAddress3($mailAddress3)
            ->setOtherAddress3($otherAddress3)
            ->setCustomerKey($customerKey)
            ->setEnrollerKey($enrollerKey)
            ->setSponsorKey($sponsorKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CustomerResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return int
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param int $customerType
     * @return \StructType\CustomerResponse
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: int
        if (!is_null($customerType) && !is_numeric($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerStatus value
     * @return int
     */
    public function getCustomerStatus()
    {
        return $this->CustomerStatus;
    }
    /**
     * Set CustomerStatus value
     * @param int $customerStatus
     * @return \StructType\CustomerResponse
     */
    public function setCustomerStatus($customerStatus = null)
    {
        // validation for constraint: int
        if (!is_null($customerStatus) && !is_numeric($customerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerStatus)), __LINE__);
        }
        $this->CustomerStatus = $customerStatus;
        return $this;
    }
    /**
     * Get EnrollerID value
     * @return int
     */
    public function getEnrollerID()
    {
        return $this->EnrollerID;
    }
    /**
     * Set EnrollerID value
     * @param int $enrollerID
     * @return \StructType\CustomerResponse
     */
    public function setEnrollerID($enrollerID = null)
    {
        // validation for constraint: int
        if (!is_null($enrollerID) && !is_numeric($enrollerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($enrollerID)), __LINE__);
        }
        $this->EnrollerID = $enrollerID;
        return $this;
    }
    /**
     * Get SponsorID value
     * @return int
     */
    public function getSponsorID()
    {
        return $this->SponsorID;
    }
    /**
     * Set SponsorID value
     * @param int $sponsorID
     * @return \StructType\CustomerResponse
     */
    public function setSponsorID($sponsorID = null)
    {
        // validation for constraint: int
        if (!is_null($sponsorID) && !is_numeric($sponsorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sponsorID)), __LINE__);
        }
        $this->SponsorID = $sponsorID;
        return $this;
    }
    /**
     * Get RankID value
     * @return int
     */
    public function getRankID()
    {
        return $this->RankID;
    }
    /**
     * Set RankID value
     * @param int $rankID
     * @return \StructType\CustomerResponse
     */
    public function setRankID($rankID = null)
    {
        // validation for constraint: int
        if (!is_null($rankID) && !is_numeric($rankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rankID)), __LINE__);
        }
        $this->RankID = $rankID;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CustomerResponse
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Date1 value
     * @return string
     */
    public function getDate1()
    {
        return $this->Date1;
    }
    /**
     * Set Date1 value
     * @param string $date1
     * @return \StructType\CustomerResponse
     */
    public function setDate1($date1 = null)
    {
        // validation for constraint: string
        if (!is_null($date1) && !is_string($date1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date1)), __LINE__);
        }
        $this->Date1 = $date1;
        return $this;
    }
    /**
     * Get Date2 value
     * @return string
     */
    public function getDate2()
    {
        return $this->Date2;
    }
    /**
     * Set Date2 value
     * @param string $date2
     * @return \StructType\CustomerResponse
     */
    public function setDate2($date2 = null)
    {
        // validation for constraint: string
        if (!is_null($date2) && !is_string($date2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date2)), __LINE__);
        }
        $this->Date2 = $date2;
        return $this;
    }
    /**
     * Get Date3 value
     * @return string
     */
    public function getDate3()
    {
        return $this->Date3;
    }
    /**
     * Set Date3 value
     * @param string $date3
     * @return \StructType\CustomerResponse
     */
    public function setDate3($date3 = null)
    {
        // validation for constraint: string
        if (!is_null($date3) && !is_string($date3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date3)), __LINE__);
        }
        $this->Date3 = $date3;
        return $this;
    }
    /**
     * Get Date4 value
     * @return string
     */
    public function getDate4()
    {
        return $this->Date4;
    }
    /**
     * Set Date4 value
     * @param string $date4
     * @return \StructType\CustomerResponse
     */
    public function setDate4($date4 = null)
    {
        // validation for constraint: string
        if (!is_null($date4) && !is_string($date4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date4)), __LINE__);
        }
        $this->Date4 = $date4;
        return $this;
    }
    /**
     * Get Date5 value
     * @return string
     */
    public function getDate5()
    {
        return $this->Date5;
    }
    /**
     * Set Date5 value
     * @param string $date5
     * @return \StructType\CustomerResponse
     */
    public function setDate5($date5 = null)
    {
        // validation for constraint: string
        if (!is_null($date5) && !is_string($date5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date5)), __LINE__);
        }
        $this->Date5 = $date5;
        return $this;
    }
    /**
     * Get DefaultWarehouseID value
     * @return int
     */
    public function getDefaultWarehouseID()
    {
        return $this->DefaultWarehouseID;
    }
    /**
     * Set DefaultWarehouseID value
     * @param int $defaultWarehouseID
     * @return \StructType\CustomerResponse
     */
    public function setDefaultWarehouseID($defaultWarehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($defaultWarehouseID) && !is_numeric($defaultWarehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultWarehouseID)), __LINE__);
        }
        $this->DefaultWarehouseID = $defaultWarehouseID;
        return $this;
    }
    /**
     * Get PayableType value
     * @return string
     */
    public function getPayableType()
    {
        return $this->PayableType;
    }
    /**
     * Set PayableType value
     * @uses \EnumType\PayableType::valueIsValid()
     * @uses \EnumType\PayableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payableType
     * @return \StructType\CustomerResponse
     */
    public function setPayableType($payableType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PayableType::valueIsValid($payableType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $payableType, implode(', ', \EnumType\PayableType::getValidValues())), __LINE__);
        }
        $this->PayableType = $payableType;
        return $this;
    }
    /**
     * Get CheckThreshold value
     * @return float
     */
    public function getCheckThreshold()
    {
        return $this->CheckThreshold;
    }
    /**
     * Set CheckThreshold value
     * @param float $checkThreshold
     * @return \StructType\CustomerResponse
     */
    public function setCheckThreshold($checkThreshold = null)
    {
        $this->CheckThreshold = $checkThreshold;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\CustomerResponse
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !is_numeric($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\CustomerResponse
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Gender::valueIsValid()
     * @uses \EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\CustomerResponse
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get IsSalesTaxExempt value
     * @return bool
     */
    public function getIsSalesTaxExempt()
    {
        return $this->IsSalesTaxExempt;
    }
    /**
     * Set IsSalesTaxExempt value
     * @param bool $isSalesTaxExempt
     * @return \StructType\CustomerResponse
     */
    public function setIsSalesTaxExempt($isSalesTaxExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesTaxExempt) && !is_bool($isSalesTaxExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSalesTaxExempt)), __LINE__);
        }
        $this->IsSalesTaxExempt = $isSalesTaxExempt;
        return $this;
    }
    /**
     * Get IsSubscribedToBroadcasts value
     * @return bool
     */
    public function getIsSubscribedToBroadcasts()
    {
        return $this->IsSubscribedToBroadcasts;
    }
    /**
     * Set IsSubscribedToBroadcasts value
     * @param bool $isSubscribedToBroadcasts
     * @return \StructType\CustomerResponse
     */
    public function setIsSubscribedToBroadcasts($isSubscribedToBroadcasts = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscribedToBroadcasts) && !is_bool($isSubscribedToBroadcasts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSubscribedToBroadcasts)), __LINE__);
        }
        $this->IsSubscribedToBroadcasts = $isSubscribedToBroadcasts;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\CustomerResponse
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\CustomerResponse
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get BinaryPlacementPreference value
     * @return int
     */
    public function getBinaryPlacementPreference()
    {
        return $this->BinaryPlacementPreference;
    }
    /**
     * Set BinaryPlacementPreference value
     * @param int $binaryPlacementPreference
     * @return \StructType\CustomerResponse
     */
    public function setBinaryPlacementPreference($binaryPlacementPreference = null)
    {
        // validation for constraint: int
        if (!is_null($binaryPlacementPreference) && !is_numeric($binaryPlacementPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($binaryPlacementPreference)), __LINE__);
        }
        $this->BinaryPlacementPreference = $binaryPlacementPreference;
        return $this;
    }
    /**
     * Get UseBinaryHoldingTank value
     * @return bool
     */
    public function getUseBinaryHoldingTank()
    {
        return $this->UseBinaryHoldingTank;
    }
    /**
     * Set UseBinaryHoldingTank value
     * @param bool $useBinaryHoldingTank
     * @return \StructType\CustomerResponse
     */
    public function setUseBinaryHoldingTank($useBinaryHoldingTank = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBinaryHoldingTank) && !is_bool($useBinaryHoldingTank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useBinaryHoldingTank)), __LINE__);
        }
        $this->UseBinaryHoldingTank = $useBinaryHoldingTank;
        return $this;
    }
    /**
     * Get MainAddressVerified value
     * @return bool
     */
    public function getMainAddressVerified()
    {
        return $this->MainAddressVerified;
    }
    /**
     * Set MainAddressVerified value
     * @param bool $mainAddressVerified
     * @return \StructType\CustomerResponse
     */
    public function setMainAddressVerified($mainAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($mainAddressVerified) && !is_bool($mainAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mainAddressVerified)), __LINE__);
        }
        $this->MainAddressVerified = $mainAddressVerified;
        return $this;
    }
    /**
     * Get MailAddressVerified value
     * @return bool
     */
    public function getMailAddressVerified()
    {
        return $this->MailAddressVerified;
    }
    /**
     * Set MailAddressVerified value
     * @param bool $mailAddressVerified
     * @return \StructType\CustomerResponse
     */
    public function setMailAddressVerified($mailAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailAddressVerified) && !is_bool($mailAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailAddressVerified)), __LINE__);
        }
        $this->MailAddressVerified = $mailAddressVerified;
        return $this;
    }
    /**
     * Get OtherAddressVerified value
     * @return bool
     */
    public function getOtherAddressVerified()
    {
        return $this->OtherAddressVerified;
    }
    /**
     * Set OtherAddressVerified value
     * @param bool $otherAddressVerified
     * @return \StructType\CustomerResponse
     */
    public function setOtherAddressVerified($otherAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($otherAddressVerified) && !is_bool($otherAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($otherAddressVerified)), __LINE__);
        }
        $this->OtherAddressVerified = $otherAddressVerified;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CustomerResponse
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CustomerResponse
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\CustomerResponse
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CustomerResponse
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\CustomerResponse
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->Phone2;
    }
    /**
     * Set Phone2 value
     * @param string $phone2
     * @return \StructType\CustomerResponse
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->Phone2 = $phone2;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\CustomerResponse
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\CustomerResponse
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get MainAddress1 value
     * @return string|null
     */
    public function getMainAddress1()
    {
        return $this->MainAddress1;
    }
    /**
     * Set MainAddress1 value
     * @param string $mainAddress1
     * @return \StructType\CustomerResponse
     */
    public function setMainAddress1($mainAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress1) && !is_string($mainAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress1)), __LINE__);
        }
        $this->MainAddress1 = $mainAddress1;
        return $this;
    }
    /**
     * Get MainAddress2 value
     * @return string|null
     */
    public function getMainAddress2()
    {
        return $this->MainAddress2;
    }
    /**
     * Set MainAddress2 value
     * @param string $mainAddress2
     * @return \StructType\CustomerResponse
     */
    public function setMainAddress2($mainAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress2) && !is_string($mainAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress2)), __LINE__);
        }
        $this->MainAddress2 = $mainAddress2;
        return $this;
    }
    /**
     * Get MainCity value
     * @return string|null
     */
    public function getMainCity()
    {
        return $this->MainCity;
    }
    /**
     * Set MainCity value
     * @param string $mainCity
     * @return \StructType\CustomerResponse
     */
    public function setMainCity($mainCity = null)
    {
        // validation for constraint: string
        if (!is_null($mainCity) && !is_string($mainCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCity)), __LINE__);
        }
        $this->MainCity = $mainCity;
        return $this;
    }
    /**
     * Get MainState value
     * @return string|null
     */
    public function getMainState()
    {
        return $this->MainState;
    }
    /**
     * Set MainState value
     * @param string $mainState
     * @return \StructType\CustomerResponse
     */
    public function setMainState($mainState = null)
    {
        // validation for constraint: string
        if (!is_null($mainState) && !is_string($mainState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainState)), __LINE__);
        }
        $this->MainState = $mainState;
        return $this;
    }
    /**
     * Get MainZip value
     * @return string|null
     */
    public function getMainZip()
    {
        return $this->MainZip;
    }
    /**
     * Set MainZip value
     * @param string $mainZip
     * @return \StructType\CustomerResponse
     */
    public function setMainZip($mainZip = null)
    {
        // validation for constraint: string
        if (!is_null($mainZip) && !is_string($mainZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainZip)), __LINE__);
        }
        $this->MainZip = $mainZip;
        return $this;
    }
    /**
     * Get MainCountry value
     * @return string|null
     */
    public function getMainCountry()
    {
        return $this->MainCountry;
    }
    /**
     * Set MainCountry value
     * @param string $mainCountry
     * @return \StructType\CustomerResponse
     */
    public function setMainCountry($mainCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mainCountry) && !is_string($mainCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCountry)), __LINE__);
        }
        $this->MainCountry = $mainCountry;
        return $this;
    }
    /**
     * Get MainCounty value
     * @return string|null
     */
    public function getMainCounty()
    {
        return $this->MainCounty;
    }
    /**
     * Set MainCounty value
     * @param string $mainCounty
     * @return \StructType\CustomerResponse
     */
    public function setMainCounty($mainCounty = null)
    {
        // validation for constraint: string
        if (!is_null($mainCounty) && !is_string($mainCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCounty)), __LINE__);
        }
        $this->MainCounty = $mainCounty;
        return $this;
    }
    /**
     * Get MailAddress1 value
     * @return string|null
     */
    public function getMailAddress1()
    {
        return $this->MailAddress1;
    }
    /**
     * Set MailAddress1 value
     * @param string $mailAddress1
     * @return \StructType\CustomerResponse
     */
    public function setMailAddress1($mailAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress1) && !is_string($mailAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress1)), __LINE__);
        }
        $this->MailAddress1 = $mailAddress1;
        return $this;
    }
    /**
     * Get MailAddress2 value
     * @return string|null
     */
    public function getMailAddress2()
    {
        return $this->MailAddress2;
    }
    /**
     * Set MailAddress2 value
     * @param string $mailAddress2
     * @return \StructType\CustomerResponse
     */
    public function setMailAddress2($mailAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress2) && !is_string($mailAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress2)), __LINE__);
        }
        $this->MailAddress2 = $mailAddress2;
        return $this;
    }
    /**
     * Get MailCity value
     * @return string|null
     */
    public function getMailCity()
    {
        return $this->MailCity;
    }
    /**
     * Set MailCity value
     * @param string $mailCity
     * @return \StructType\CustomerResponse
     */
    public function setMailCity($mailCity = null)
    {
        // validation for constraint: string
        if (!is_null($mailCity) && !is_string($mailCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCity)), __LINE__);
        }
        $this->MailCity = $mailCity;
        return $this;
    }
    /**
     * Get MailState value
     * @return string|null
     */
    public function getMailState()
    {
        return $this->MailState;
    }
    /**
     * Set MailState value
     * @param string $mailState
     * @return \StructType\CustomerResponse
     */
    public function setMailState($mailState = null)
    {
        // validation for constraint: string
        if (!is_null($mailState) && !is_string($mailState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailState)), __LINE__);
        }
        $this->MailState = $mailState;
        return $this;
    }
    /**
     * Get MailZip value
     * @return string|null
     */
    public function getMailZip()
    {
        return $this->MailZip;
    }
    /**
     * Set MailZip value
     * @param string $mailZip
     * @return \StructType\CustomerResponse
     */
    public function setMailZip($mailZip = null)
    {
        // validation for constraint: string
        if (!is_null($mailZip) && !is_string($mailZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailZip)), __LINE__);
        }
        $this->MailZip = $mailZip;
        return $this;
    }
    /**
     * Get MailCountry value
     * @return string|null
     */
    public function getMailCountry()
    {
        return $this->MailCountry;
    }
    /**
     * Set MailCountry value
     * @param string $mailCountry
     * @return \StructType\CustomerResponse
     */
    public function setMailCountry($mailCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mailCountry) && !is_string($mailCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCountry)), __LINE__);
        }
        $this->MailCountry = $mailCountry;
        return $this;
    }
    /**
     * Get MailCounty value
     * @return string|null
     */
    public function getMailCounty()
    {
        return $this->MailCounty;
    }
    /**
     * Set MailCounty value
     * @param string $mailCounty
     * @return \StructType\CustomerResponse
     */
    public function setMailCounty($mailCounty = null)
    {
        // validation for constraint: string
        if (!is_null($mailCounty) && !is_string($mailCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCounty)), __LINE__);
        }
        $this->MailCounty = $mailCounty;
        return $this;
    }
    /**
     * Get OtherAddress1 value
     * @return string|null
     */
    public function getOtherAddress1()
    {
        return $this->OtherAddress1;
    }
    /**
     * Set OtherAddress1 value
     * @param string $otherAddress1
     * @return \StructType\CustomerResponse
     */
    public function setOtherAddress1($otherAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress1) && !is_string($otherAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress1)), __LINE__);
        }
        $this->OtherAddress1 = $otherAddress1;
        return $this;
    }
    /**
     * Get OtherAddress2 value
     * @return string|null
     */
    public function getOtherAddress2()
    {
        return $this->OtherAddress2;
    }
    /**
     * Set OtherAddress2 value
     * @param string $otherAddress2
     * @return \StructType\CustomerResponse
     */
    public function setOtherAddress2($otherAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress2) && !is_string($otherAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress2)), __LINE__);
        }
        $this->OtherAddress2 = $otherAddress2;
        return $this;
    }
    /**
     * Get OtherCity value
     * @return string|null
     */
    public function getOtherCity()
    {
        return $this->OtherCity;
    }
    /**
     * Set OtherCity value
     * @param string $otherCity
     * @return \StructType\CustomerResponse
     */
    public function setOtherCity($otherCity = null)
    {
        // validation for constraint: string
        if (!is_null($otherCity) && !is_string($otherCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCity)), __LINE__);
        }
        $this->OtherCity = $otherCity;
        return $this;
    }
    /**
     * Get OtherState value
     * @return string|null
     */
    public function getOtherState()
    {
        return $this->OtherState;
    }
    /**
     * Set OtherState value
     * @param string $otherState
     * @return \StructType\CustomerResponse
     */
    public function setOtherState($otherState = null)
    {
        // validation for constraint: string
        if (!is_null($otherState) && !is_string($otherState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherState)), __LINE__);
        }
        $this->OtherState = $otherState;
        return $this;
    }
    /**
     * Get OtherZip value
     * @return string|null
     */
    public function getOtherZip()
    {
        return $this->OtherZip;
    }
    /**
     * Set OtherZip value
     * @param string $otherZip
     * @return \StructType\CustomerResponse
     */
    public function setOtherZip($otherZip = null)
    {
        // validation for constraint: string
        if (!is_null($otherZip) && !is_string($otherZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherZip)), __LINE__);
        }
        $this->OtherZip = $otherZip;
        return $this;
    }
    /**
     * Get OtherCountry value
     * @return string|null
     */
    public function getOtherCountry()
    {
        return $this->OtherCountry;
    }
    /**
     * Set OtherCountry value
     * @param string $otherCountry
     * @return \StructType\CustomerResponse
     */
    public function setOtherCountry($otherCountry = null)
    {
        // validation for constraint: string
        if (!is_null($otherCountry) && !is_string($otherCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCountry)), __LINE__);
        }
        $this->OtherCountry = $otherCountry;
        return $this;
    }
    /**
     * Get OtherCounty value
     * @return string|null
     */
    public function getOtherCounty()
    {
        return $this->OtherCounty;
    }
    /**
     * Set OtherCounty value
     * @param string $otherCounty
     * @return \StructType\CustomerResponse
     */
    public function setOtherCounty($otherCounty = null)
    {
        // validation for constraint: string
        if (!is_null($otherCounty) && !is_string($otherCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCounty)), __LINE__);
        }
        $this->OtherCounty = $otherCounty;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\CustomerResponse
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Field1 value
     * @return string|null
     */
    public function getField1()
    {
        return $this->Field1;
    }
    /**
     * Set Field1 value
     * @param string $field1
     * @return \StructType\CustomerResponse
     */
    public function setField1($field1 = null)
    {
        // validation for constraint: string
        if (!is_null($field1) && !is_string($field1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field1)), __LINE__);
        }
        $this->Field1 = $field1;
        return $this;
    }
    /**
     * Get Field2 value
     * @return string|null
     */
    public function getField2()
    {
        return $this->Field2;
    }
    /**
     * Set Field2 value
     * @param string $field2
     * @return \StructType\CustomerResponse
     */
    public function setField2($field2 = null)
    {
        // validation for constraint: string
        if (!is_null($field2) && !is_string($field2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field2)), __LINE__);
        }
        $this->Field2 = $field2;
        return $this;
    }
    /**
     * Get Field3 value
     * @return string|null
     */
    public function getField3()
    {
        return $this->Field3;
    }
    /**
     * Set Field3 value
     * @param string $field3
     * @return \StructType\CustomerResponse
     */
    public function setField3($field3 = null)
    {
        // validation for constraint: string
        if (!is_null($field3) && !is_string($field3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field3)), __LINE__);
        }
        $this->Field3 = $field3;
        return $this;
    }
    /**
     * Get Field4 value
     * @return string|null
     */
    public function getField4()
    {
        return $this->Field4;
    }
    /**
     * Set Field4 value
     * @param string $field4
     * @return \StructType\CustomerResponse
     */
    public function setField4($field4 = null)
    {
        // validation for constraint: string
        if (!is_null($field4) && !is_string($field4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field4)), __LINE__);
        }
        $this->Field4 = $field4;
        return $this;
    }
    /**
     * Get Field5 value
     * @return string|null
     */
    public function getField5()
    {
        return $this->Field5;
    }
    /**
     * Set Field5 value
     * @param string $field5
     * @return \StructType\CustomerResponse
     */
    public function setField5($field5 = null)
    {
        // validation for constraint: string
        if (!is_null($field5) && !is_string($field5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field5)), __LINE__);
        }
        $this->Field5 = $field5;
        return $this;
    }
    /**
     * Get Field6 value
     * @return string|null
     */
    public function getField6()
    {
        return $this->Field6;
    }
    /**
     * Set Field6 value
     * @param string $field6
     * @return \StructType\CustomerResponse
     */
    public function setField6($field6 = null)
    {
        // validation for constraint: string
        if (!is_null($field6) && !is_string($field6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field6)), __LINE__);
        }
        $this->Field6 = $field6;
        return $this;
    }
    /**
     * Get Field7 value
     * @return string|null
     */
    public function getField7()
    {
        return $this->Field7;
    }
    /**
     * Set Field7 value
     * @param string $field7
     * @return \StructType\CustomerResponse
     */
    public function setField7($field7 = null)
    {
        // validation for constraint: string
        if (!is_null($field7) && !is_string($field7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field7)), __LINE__);
        }
        $this->Field7 = $field7;
        return $this;
    }
    /**
     * Get Field8 value
     * @return string|null
     */
    public function getField8()
    {
        return $this->Field8;
    }
    /**
     * Set Field8 value
     * @param string $field8
     * @return \StructType\CustomerResponse
     */
    public function setField8($field8 = null)
    {
        // validation for constraint: string
        if (!is_null($field8) && !is_string($field8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field8)), __LINE__);
        }
        $this->Field8 = $field8;
        return $this;
    }
    /**
     * Get Field9 value
     * @return string|null
     */
    public function getField9()
    {
        return $this->Field9;
    }
    /**
     * Set Field9 value
     * @param string $field9
     * @return \StructType\CustomerResponse
     */
    public function setField9($field9 = null)
    {
        // validation for constraint: string
        if (!is_null($field9) && !is_string($field9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field9)), __LINE__);
        }
        $this->Field9 = $field9;
        return $this;
    }
    /**
     * Get Field10 value
     * @return string|null
     */
    public function getField10()
    {
        return $this->Field10;
    }
    /**
     * Set Field10 value
     * @param string $field10
     * @return \StructType\CustomerResponse
     */
    public function setField10($field10 = null)
    {
        // validation for constraint: string
        if (!is_null($field10) && !is_string($field10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field10)), __LINE__);
        }
        $this->Field10 = $field10;
        return $this;
    }
    /**
     * Get Field11 value
     * @return string|null
     */
    public function getField11()
    {
        return $this->Field11;
    }
    /**
     * Set Field11 value
     * @param string $field11
     * @return \StructType\CustomerResponse
     */
    public function setField11($field11 = null)
    {
        // validation for constraint: string
        if (!is_null($field11) && !is_string($field11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field11)), __LINE__);
        }
        $this->Field11 = $field11;
        return $this;
    }
    /**
     * Get Field12 value
     * @return string|null
     */
    public function getField12()
    {
        return $this->Field12;
    }
    /**
     * Set Field12 value
     * @param string $field12
     * @return \StructType\CustomerResponse
     */
    public function setField12($field12 = null)
    {
        // validation for constraint: string
        if (!is_null($field12) && !is_string($field12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field12)), __LINE__);
        }
        $this->Field12 = $field12;
        return $this;
    }
    /**
     * Get Field13 value
     * @return string|null
     */
    public function getField13()
    {
        return $this->Field13;
    }
    /**
     * Set Field13 value
     * @param string $field13
     * @return \StructType\CustomerResponse
     */
    public function setField13($field13 = null)
    {
        // validation for constraint: string
        if (!is_null($field13) && !is_string($field13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field13)), __LINE__);
        }
        $this->Field13 = $field13;
        return $this;
    }
    /**
     * Get Field14 value
     * @return string|null
     */
    public function getField14()
    {
        return $this->Field14;
    }
    /**
     * Set Field14 value
     * @param string $field14
     * @return \StructType\CustomerResponse
     */
    public function setField14($field14 = null)
    {
        // validation for constraint: string
        if (!is_null($field14) && !is_string($field14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field14)), __LINE__);
        }
        $this->Field14 = $field14;
        return $this;
    }
    /**
     * Get Field15 value
     * @return string|null
     */
    public function getField15()
    {
        return $this->Field15;
    }
    /**
     * Set Field15 value
     * @param string $field15
     * @return \StructType\CustomerResponse
     */
    public function setField15($field15 = null)
    {
        // validation for constraint: string
        if (!is_null($field15) && !is_string($field15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field15)), __LINE__);
        }
        $this->Field15 = $field15;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CustomerResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PayableToName value
     * @return string|null
     */
    public function getPayableToName()
    {
        return $this->PayableToName;
    }
    /**
     * Set PayableToName value
     * @param string $payableToName
     * @return \StructType\CustomerResponse
     */
    public function setPayableToName($payableToName = null)
    {
        // validation for constraint: string
        if (!is_null($payableToName) && !is_string($payableToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payableToName)), __LINE__);
        }
        $this->PayableToName = $payableToName;
        return $this;
    }
    /**
     * Get SalesTaxID value
     * @return string|null
     */
    public function getSalesTaxID()
    {
        return $this->SalesTaxID;
    }
    /**
     * Set SalesTaxID value
     * @param string $salesTaxID
     * @return \StructType\CustomerResponse
     */
    public function setSalesTaxID($salesTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($salesTaxID) && !is_string($salesTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesTaxID)), __LINE__);
        }
        $this->SalesTaxID = $salesTaxID;
        return $this;
    }
    /**
     * Get VatRegistration value
     * @return string|null
     */
    public function getVatRegistration()
    {
        return $this->VatRegistration;
    }
    /**
     * Set VatRegistration value
     * @param string $vatRegistration
     * @return \StructType\CustomerResponse
     */
    public function setVatRegistration($vatRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistration) && !is_string($vatRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatRegistration)), __LINE__);
        }
        $this->VatRegistration = $vatRegistration;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CustomerResponse
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param string $nameSuffix
     * @return \StructType\CustomerResponse
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSuffix)), __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get MainAddress3 value
     * @return string|null
     */
    public function getMainAddress3()
    {
        return $this->MainAddress3;
    }
    /**
     * Set MainAddress3 value
     * @param string $mainAddress3
     * @return \StructType\CustomerResponse
     */
    public function setMainAddress3($mainAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress3) && !is_string($mainAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress3)), __LINE__);
        }
        $this->MainAddress3 = $mainAddress3;
        return $this;
    }
    /**
     * Get MailAddress3 value
     * @return string|null
     */
    public function getMailAddress3()
    {
        return $this->MailAddress3;
    }
    /**
     * Set MailAddress3 value
     * @param string $mailAddress3
     * @return \StructType\CustomerResponse
     */
    public function setMailAddress3($mailAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress3) && !is_string($mailAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress3)), __LINE__);
        }
        $this->MailAddress3 = $mailAddress3;
        return $this;
    }
    /**
     * Get OtherAddress3 value
     * @return string|null
     */
    public function getOtherAddress3()
    {
        return $this->OtherAddress3;
    }
    /**
     * Set OtherAddress3 value
     * @param string $otherAddress3
     * @return \StructType\CustomerResponse
     */
    public function setOtherAddress3($otherAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress3) && !is_string($otherAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress3)), __LINE__);
        }
        $this->OtherAddress3 = $otherAddress3;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CustomerResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get EnrollerKey value
     * @return string|null
     */
    public function getEnrollerKey()
    {
        return $this->EnrollerKey;
    }
    /**
     * Set EnrollerKey value
     * @param string $enrollerKey
     * @return \StructType\CustomerResponse
     */
    public function setEnrollerKey($enrollerKey = null)
    {
        // validation for constraint: string
        if (!is_null($enrollerKey) && !is_string($enrollerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollerKey)), __LINE__);
        }
        $this->EnrollerKey = $enrollerKey;
        return $this;
    }
    /**
     * Get SponsorKey value
     * @return string|null
     */
    public function getSponsorKey()
    {
        return $this->SponsorKey;
    }
    /**
     * Set SponsorKey value
     * @param string $sponsorKey
     * @return \StructType\CustomerResponse
     */
    public function setSponsorKey($sponsorKey = null)
    {
        // validation for constraint: string
        if (!is_null($sponsorKey) && !is_string($sponsorKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sponsorKey)), __LINE__);
        }
        $this->SponsorKey = $sponsorKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
