<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerEventResponse StructType
 * @subpackage Structs
 */
class CustomerEventResponse extends AbstractStructBase
{
    /**
     * The EventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EventID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EventDate;
    /**
     * The EventDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDescription;
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerEventField
     */
    public $Fields;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CustomerEventResponse
     * @uses CustomerEventResponse::setEventID()
     * @uses CustomerEventResponse::setCustomerID()
     * @uses CustomerEventResponse::setEventDate()
     * @uses CustomerEventResponse::setEventDescription()
     * @uses CustomerEventResponse::setFields()
     * @uses CustomerEventResponse::setCustomerKey()
     * @param int $eventID
     * @param int $customerID
     * @param string $eventDate
     * @param string $eventDescription
     * @param \ArrayType\ArrayOfCustomerEventField $fields
     * @param string $customerKey
     */
    public function __construct($eventID = null, $customerID = null, $eventDate = null, $eventDescription = null, \ArrayType\ArrayOfCustomerEventField $fields = null, $customerKey = null)
    {
        $this
            ->setEventID($eventID)
            ->setCustomerID($customerID)
            ->setEventDate($eventDate)
            ->setEventDescription($eventDescription)
            ->setFields($fields)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get EventID value
     * @return int
     */
    public function getEventID()
    {
        return $this->EventID;
    }
    /**
     * Set EventID value
     * @param int $eventID
     * @return \StructType\CustomerEventResponse
     */
    public function setEventID($eventID = null)
    {
        // validation for constraint: int
        if (!is_null($eventID) && !is_numeric($eventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eventID)), __LINE__);
        }
        $this->EventID = $eventID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CustomerEventResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \StructType\CustomerEventResponse
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get EventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->EventDescription;
    }
    /**
     * Set EventDescription value
     * @param string $eventDescription
     * @return \StructType\CustomerEventResponse
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDescription)), __LINE__);
        }
        $this->EventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get Fields value
     * @return \ArrayType\ArrayOfCustomerEventField|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param \ArrayType\ArrayOfCustomerEventField $fields
     * @return \StructType\CustomerEventResponse
     */
    public function setFields(\ArrayType\ArrayOfCustomerEventField $fields = null)
    {
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CustomerEventResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerEventResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
