<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePointTransactionRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreatePointTransactionRequest
 * @subpackage Structs
 */
class CreatePointTransactionRequest extends ApiRequest
{
    /**
     * The PointAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PointAccountID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionType;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreatePointTransactionRequest
     * @uses CreatePointTransactionRequest::setPointAccountID()
     * @uses CreatePointTransactionRequest::setCustomerID()
     * @uses CreatePointTransactionRequest::setAmount()
     * @uses CreatePointTransactionRequest::setTransactionType()
     * @uses CreatePointTransactionRequest::setReference()
     * @uses CreatePointTransactionRequest::setCustomerKey()
     * @param int $pointAccountID
     * @param int $customerID
     * @param float $amount
     * @param string $transactionType
     * @param string $reference
     * @param string $customerKey
     */
    public function __construct($pointAccountID = null, $customerID = null, $amount = null, $transactionType = null, $reference = null, $customerKey = null)
    {
        $this
            ->setPointAccountID($pointAccountID)
            ->setCustomerID($customerID)
            ->setAmount($amount)
            ->setTransactionType($transactionType)
            ->setReference($reference)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get PointAccountID value
     * @return int
     */
    public function getPointAccountID()
    {
        return $this->PointAccountID;
    }
    /**
     * Set PointAccountID value
     * @param int $pointAccountID
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setPointAccountID($pointAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($pointAccountID) && !is_numeric($pointAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointAccountID)), __LINE__);
        }
        $this->PointAccountID = $pointAccountID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\PointTransactionType::valueIsValid()
     * @uses \EnumType\PointTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PointTransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \EnumType\PointTransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreatePointTransactionRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePointTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
