<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePayoutResponse StructType
 * @subpackage Structs
 */
class CreatePayoutResponse extends ApiResponse
{
    /**
     * The PayoutID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayoutID;
    /**
     * The TotalDollarAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDollarAmount;
    /**
     * Constructor method for CreatePayoutResponse
     * @uses CreatePayoutResponse::setPayoutID()
     * @uses CreatePayoutResponse::setTotalDollarAmount()
     * @param int $payoutID
     * @param float $totalDollarAmount
     */
    public function __construct($payoutID = null, $totalDollarAmount = null)
    {
        $this
            ->setPayoutID($payoutID)
            ->setTotalDollarAmount($totalDollarAmount);
    }
    /**
     * Get PayoutID value
     * @return int
     */
    public function getPayoutID()
    {
        return $this->PayoutID;
    }
    /**
     * Set PayoutID value
     * @param int $payoutID
     * @return \StructType\CreatePayoutResponse
     */
    public function setPayoutID($payoutID = null)
    {
        // validation for constraint: int
        if (!is_null($payoutID) && !is_numeric($payoutID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payoutID)), __LINE__);
        }
        $this->PayoutID = $payoutID;
        return $this;
    }
    /**
     * Get TotalDollarAmount value
     * @return float
     */
    public function getTotalDollarAmount()
    {
        return $this->TotalDollarAmount;
    }
    /**
     * Set TotalDollarAmount value
     * @param float $totalDollarAmount
     * @return \StructType\CreatePayoutResponse
     */
    public function setTotalDollarAmount($totalDollarAmount = null)
    {
        $this->TotalDollarAmount = $totalDollarAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePayoutResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
