<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentWalletRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreatePaymentWalletRequest
 * @subpackage Structs
 */
class CreatePaymentWalletRequest extends BaseCreatePaymentRequest
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The WalletType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletType;
    /**
     * The WalletAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletAccount;
    /**
     * The AuthorizationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for CreatePaymentWalletRequest
     * @uses CreatePaymentWalletRequest::setOrderID()
     * @uses CreatePaymentWalletRequest::setPaymentDate()
     * @uses CreatePaymentWalletRequest::setAmount()
     * @uses CreatePaymentWalletRequest::setWalletType()
     * @uses CreatePaymentWalletRequest::setWalletAccount()
     * @uses CreatePaymentWalletRequest::setAuthorizationCode()
     * @uses CreatePaymentWalletRequest::setMemo()
     * @uses CreatePaymentWalletRequest::setBillingName()
     * @uses CreatePaymentWalletRequest::setOrderKey()
     * @param int $orderID
     * @param string $paymentDate
     * @param float $amount
     * @param int $walletType
     * @param string $walletAccount
     * @param string $authorizationCode
     * @param string $memo
     * @param string $billingName
     * @param string $orderKey
     */
    public function __construct($orderID = null, $paymentDate = null, $amount = null, $walletType = null, $walletAccount = null, $authorizationCode = null, $memo = null, $billingName = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount)
            ->setWalletType($walletType)
            ->setWalletAccount($walletAccount)
            ->setAuthorizationCode($authorizationCode)
            ->setMemo($memo)
            ->setBillingName($billingName)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get WalletType value
     * @return int
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param int $walletType
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: int
        if (!is_null($walletType) && !is_numeric($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($walletType)), __LINE__);
        }
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get WalletAccount value
     * @return string|null
     */
    public function getWalletAccount()
    {
        return $this->WalletAccount;
    }
    /**
     * Set WalletAccount value
     * @param string $walletAccount
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setWalletAccount($walletAccount = null)
    {
        // validation for constraint: string
        if (!is_null($walletAccount) && !is_string($walletAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletAccount)), __LINE__);
        }
        $this->WalletAccount = $walletAccount;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\CreatePaymentWalletRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePaymentWalletRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
