<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderImportRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateOrderImportRequest
 * @subpackage Structs
 */
class CreateOrderImportRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ShipMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShipMethodID;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The ShippingStateTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingStateTax;
    /**
     * The ShippingFedTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingFedTax;
    /**
     * The ShippingCountyLocalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingCountyLocalTax;
    /**
     * The ShippingCountyTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingCountyTax;
    /**
     * The ShippingCityLocalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingCityLocalTax;
    /**
     * The ShippingCityTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingCityTax;
    /**
     * The Shipping
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Shipping;
    /**
     * The PriceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceType;
    /**
     * The OrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderStatus;
    /**
     * The OrderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderDate;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderType;
    /**
     * The UseManualOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseManualOrderID;
    /**
     * The ManualOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ManualOrderID;
    /**
     * The ReturnOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReturnOrderID;
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyID;
    /**
     * The OverwriteExistingOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OverwriteExistingOrder;
    /**
     * The ExistingOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExistingOrderID;
    /**
     * The IsCommissionable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCommissionable;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The County
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Other11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other11;
    /**
     * The Other12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other12;
    /**
     * The Other13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other13;
    /**
     * The Other14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other14;
    /**
     * The Other15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other15;
    /**
     * The Other16
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other16;
    /**
     * The Other17
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other17;
    /**
     * The Other18
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other18;
    /**
     * The Other19
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other19;
    /**
     * The Other20
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other20;
    /**
     * The OrderDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderImportDetail
     */
    public $OrderDetails;
    /**
     * The ManualOrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManualOrderKey;
    /**
     * The ReturnOrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnOrderKey;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ExistingOrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExistingOrderKey;
    /**
     * Constructor method for CreateOrderImportRequest
     * @uses CreateOrderImportRequest::setCustomerID()
     * @uses CreateOrderImportRequest::setShipMethodID()
     * @uses CreateOrderImportRequest::setWarehouseID()
     * @uses CreateOrderImportRequest::setShippingStateTax()
     * @uses CreateOrderImportRequest::setShippingFedTax()
     * @uses CreateOrderImportRequest::setShippingCountyLocalTax()
     * @uses CreateOrderImportRequest::setShippingCountyTax()
     * @uses CreateOrderImportRequest::setShippingCityLocalTax()
     * @uses CreateOrderImportRequest::setShippingCityTax()
     * @uses CreateOrderImportRequest::setShipping()
     * @uses CreateOrderImportRequest::setPriceType()
     * @uses CreateOrderImportRequest::setOrderStatus()
     * @uses CreateOrderImportRequest::setOrderDate()
     * @uses CreateOrderImportRequest::setOrderType()
     * @uses CreateOrderImportRequest::setUseManualOrderID()
     * @uses CreateOrderImportRequest::setManualOrderID()
     * @uses CreateOrderImportRequest::setReturnOrderID()
     * @uses CreateOrderImportRequest::setPartyID()
     * @uses CreateOrderImportRequest::setOverwriteExistingOrder()
     * @uses CreateOrderImportRequest::setExistingOrderID()
     * @uses CreateOrderImportRequest::setIsCommissionable()
     * @uses CreateOrderImportRequest::setFirstName()
     * @uses CreateOrderImportRequest::setLastName()
     * @uses CreateOrderImportRequest::setCompany()
     * @uses CreateOrderImportRequest::setPhone()
     * @uses CreateOrderImportRequest::setEmail()
     * @uses CreateOrderImportRequest::setAddress1()
     * @uses CreateOrderImportRequest::setAddress2()
     * @uses CreateOrderImportRequest::setCity()
     * @uses CreateOrderImportRequest::setState()
     * @uses CreateOrderImportRequest::setZip()
     * @uses CreateOrderImportRequest::setCountry()
     * @uses CreateOrderImportRequest::setCounty()
     * @uses CreateOrderImportRequest::setNotes()
     * @uses CreateOrderImportRequest::setCurrencyCode()
     * @uses CreateOrderImportRequest::setOther11()
     * @uses CreateOrderImportRequest::setOther12()
     * @uses CreateOrderImportRequest::setOther13()
     * @uses CreateOrderImportRequest::setOther14()
     * @uses CreateOrderImportRequest::setOther15()
     * @uses CreateOrderImportRequest::setOther16()
     * @uses CreateOrderImportRequest::setOther17()
     * @uses CreateOrderImportRequest::setOther18()
     * @uses CreateOrderImportRequest::setOther19()
     * @uses CreateOrderImportRequest::setOther20()
     * @uses CreateOrderImportRequest::setOrderDetails()
     * @uses CreateOrderImportRequest::setManualOrderKey()
     * @uses CreateOrderImportRequest::setReturnOrderKey()
     * @uses CreateOrderImportRequest::setCustomerKey()
     * @uses CreateOrderImportRequest::setExistingOrderKey()
     * @param int $customerID
     * @param int $shipMethodID
     * @param int $warehouseID
     * @param float $shippingStateTax
     * @param float $shippingFedTax
     * @param float $shippingCountyLocalTax
     * @param float $shippingCountyTax
     * @param float $shippingCityLocalTax
     * @param float $shippingCityTax
     * @param float $shipping
     * @param int $priceType
     * @param string $orderStatus
     * @param string $orderDate
     * @param string $orderType
     * @param bool $useManualOrderID
     * @param int $manualOrderID
     * @param int $returnOrderID
     * @param int $partyID
     * @param bool $overwriteExistingOrder
     * @param int $existingOrderID
     * @param bool $isCommissionable
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $phone
     * @param string $email
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $county
     * @param string $notes
     * @param string $currencyCode
     * @param string $other11
     * @param string $other12
     * @param string $other13
     * @param string $other14
     * @param string $other15
     * @param string $other16
     * @param string $other17
     * @param string $other18
     * @param string $other19
     * @param string $other20
     * @param \ArrayType\ArrayOfOrderImportDetail $orderDetails
     * @param string $manualOrderKey
     * @param string $returnOrderKey
     * @param string $customerKey
     * @param string $existingOrderKey
     */
    public function __construct($customerID = null, $shipMethodID = null, $warehouseID = null, $shippingStateTax = null, $shippingFedTax = null, $shippingCountyLocalTax = null, $shippingCountyTax = null, $shippingCityLocalTax = null, $shippingCityTax = null, $shipping = null, $priceType = null, $orderStatus = null, $orderDate = null, $orderType = null, $useManualOrderID = null, $manualOrderID = null, $returnOrderID = null, $partyID = null, $overwriteExistingOrder = null, $existingOrderID = null, $isCommissionable = null, $firstName = null, $lastName = null, $company = null, $phone = null, $email = null, $address1 = null, $address2 = null, $city = null, $state = null, $zip = null, $country = null, $county = null, $notes = null, $currencyCode = null, $other11 = null, $other12 = null, $other13 = null, $other14 = null, $other15 = null, $other16 = null, $other17 = null, $other18 = null, $other19 = null, $other20 = null, \ArrayType\ArrayOfOrderImportDetail $orderDetails = null, $manualOrderKey = null, $returnOrderKey = null, $customerKey = null, $existingOrderKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setShipMethodID($shipMethodID)
            ->setWarehouseID($warehouseID)
            ->setShippingStateTax($shippingStateTax)
            ->setShippingFedTax($shippingFedTax)
            ->setShippingCountyLocalTax($shippingCountyLocalTax)
            ->setShippingCountyTax($shippingCountyTax)
            ->setShippingCityLocalTax($shippingCityLocalTax)
            ->setShippingCityTax($shippingCityTax)
            ->setShipping($shipping)
            ->setPriceType($priceType)
            ->setOrderStatus($orderStatus)
            ->setOrderDate($orderDate)
            ->setOrderType($orderType)
            ->setUseManualOrderID($useManualOrderID)
            ->setManualOrderID($manualOrderID)
            ->setReturnOrderID($returnOrderID)
            ->setPartyID($partyID)
            ->setOverwriteExistingOrder($overwriteExistingOrder)
            ->setExistingOrderID($existingOrderID)
            ->setIsCommissionable($isCommissionable)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setPhone($phone)
            ->setEmail($email)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setCounty($county)
            ->setNotes($notes)
            ->setCurrencyCode($currencyCode)
            ->setOther11($other11)
            ->setOther12($other12)
            ->setOther13($other13)
            ->setOther14($other14)
            ->setOther15($other15)
            ->setOther16($other16)
            ->setOther17($other17)
            ->setOther18($other18)
            ->setOther19($other19)
            ->setOther20($other20)
            ->setOrderDetails($orderDetails)
            ->setManualOrderKey($manualOrderKey)
            ->setReturnOrderKey($returnOrderKey)
            ->setCustomerKey($customerKey)
            ->setExistingOrderKey($existingOrderKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ShipMethodID value
     * @return int
     */
    public function getShipMethodID()
    {
        return $this->ShipMethodID;
    }
    /**
     * Set ShipMethodID value
     * @param int $shipMethodID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShipMethodID($shipMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($shipMethodID) && !is_numeric($shipMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipMethodID)), __LINE__);
        }
        $this->ShipMethodID = $shipMethodID;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ShippingStateTax value
     * @return float
     */
    public function getShippingStateTax()
    {
        return $this->ShippingStateTax;
    }
    /**
     * Set ShippingStateTax value
     * @param float $shippingStateTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingStateTax($shippingStateTax = null)
    {
        $this->ShippingStateTax = $shippingStateTax;
        return $this;
    }
    /**
     * Get ShippingFedTax value
     * @return float
     */
    public function getShippingFedTax()
    {
        return $this->ShippingFedTax;
    }
    /**
     * Set ShippingFedTax value
     * @param float $shippingFedTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingFedTax($shippingFedTax = null)
    {
        $this->ShippingFedTax = $shippingFedTax;
        return $this;
    }
    /**
     * Get ShippingCountyLocalTax value
     * @return float
     */
    public function getShippingCountyLocalTax()
    {
        return $this->ShippingCountyLocalTax;
    }
    /**
     * Set ShippingCountyLocalTax value
     * @param float $shippingCountyLocalTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingCountyLocalTax($shippingCountyLocalTax = null)
    {
        $this->ShippingCountyLocalTax = $shippingCountyLocalTax;
        return $this;
    }
    /**
     * Get ShippingCountyTax value
     * @return float
     */
    public function getShippingCountyTax()
    {
        return $this->ShippingCountyTax;
    }
    /**
     * Set ShippingCountyTax value
     * @param float $shippingCountyTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingCountyTax($shippingCountyTax = null)
    {
        $this->ShippingCountyTax = $shippingCountyTax;
        return $this;
    }
    /**
     * Get ShippingCityLocalTax value
     * @return float
     */
    public function getShippingCityLocalTax()
    {
        return $this->ShippingCityLocalTax;
    }
    /**
     * Set ShippingCityLocalTax value
     * @param float $shippingCityLocalTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingCityLocalTax($shippingCityLocalTax = null)
    {
        $this->ShippingCityLocalTax = $shippingCityLocalTax;
        return $this;
    }
    /**
     * Get ShippingCityTax value
     * @return float
     */
    public function getShippingCityTax()
    {
        return $this->ShippingCityTax;
    }
    /**
     * Set ShippingCityTax value
     * @param float $shippingCityTax
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShippingCityTax($shippingCityTax = null)
    {
        $this->ShippingCityTax = $shippingCityTax;
        return $this;
    }
    /**
     * Get Shipping value
     * @return float
     */
    public function getShipping()
    {
        return $this->Shipping;
    }
    /**
     * Set Shipping value
     * @param float $shipping
     * @return \StructType\CreateOrderImportRequest
     */
    public function setShipping($shipping = null)
    {
        $this->Shipping = $shipping;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\CreateOrderImportRequest
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !is_numeric($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatusType::valueIsValid()
     * @uses \EnumType\OrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatusType::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderStatus, implode(', ', \EnumType\OrderStatusType::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @uses \EnumType\OrderType::valueIsValid()
     * @uses \EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderType, implode(', ', \EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get UseManualOrderID value
     * @return bool
     */
    public function getUseManualOrderID()
    {
        return $this->UseManualOrderID;
    }
    /**
     * Set UseManualOrderID value
     * @param bool $useManualOrderID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setUseManualOrderID($useManualOrderID = null)
    {
        // validation for constraint: boolean
        if (!is_null($useManualOrderID) && !is_bool($useManualOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useManualOrderID)), __LINE__);
        }
        $this->UseManualOrderID = $useManualOrderID;
        return $this;
    }
    /**
     * Get ManualOrderID value
     * @return int
     */
    public function getManualOrderID()
    {
        return $this->ManualOrderID;
    }
    /**
     * Set ManualOrderID value
     * @param int $manualOrderID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setManualOrderID($manualOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($manualOrderID) && !is_numeric($manualOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manualOrderID)), __LINE__);
        }
        $this->ManualOrderID = $manualOrderID;
        return $this;
    }
    /**
     * Get ReturnOrderID value
     * @return int
     */
    public function getReturnOrderID()
    {
        return $this->ReturnOrderID;
    }
    /**
     * Set ReturnOrderID value
     * @param int $returnOrderID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setReturnOrderID($returnOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($returnOrderID) && !is_numeric($returnOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($returnOrderID)), __LINE__);
        }
        $this->ReturnOrderID = $returnOrderID;
        return $this;
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get OverwriteExistingOrder value
     * @return bool
     */
    public function getOverwriteExistingOrder()
    {
        return $this->OverwriteExistingOrder;
    }
    /**
     * Set OverwriteExistingOrder value
     * @param bool $overwriteExistingOrder
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOverwriteExistingOrder($overwriteExistingOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($overwriteExistingOrder) && !is_bool($overwriteExistingOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overwriteExistingOrder)), __LINE__);
        }
        $this->OverwriteExistingOrder = $overwriteExistingOrder;
        return $this;
    }
    /**
     * Get ExistingOrderID value
     * @return int
     */
    public function getExistingOrderID()
    {
        return $this->ExistingOrderID;
    }
    /**
     * Set ExistingOrderID value
     * @param int $existingOrderID
     * @return \StructType\CreateOrderImportRequest
     */
    public function setExistingOrderID($existingOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($existingOrderID) && !is_numeric($existingOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingOrderID)), __LINE__);
        }
        $this->ExistingOrderID = $existingOrderID;
        return $this;
    }
    /**
     * Get IsCommissionable value
     * @return bool
     */
    public function getIsCommissionable()
    {
        return $this->IsCommissionable;
    }
    /**
     * Set IsCommissionable value
     * @param bool $isCommissionable
     * @return \StructType\CreateOrderImportRequest
     */
    public function setIsCommissionable($isCommissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommissionable) && !is_bool($isCommissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCommissionable)), __LINE__);
        }
        $this->IsCommissionable = $isCommissionable;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CreateOrderImportRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CreateOrderImportRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\CreateOrderImportRequest
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CreateOrderImportRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\CreateOrderImportRequest
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\CreateOrderImportRequest
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\CreateOrderImportRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\CreateOrderImportRequest
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\CreateOrderImportRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Other11 value
     * @return string|null
     */
    public function getOther11()
    {
        return $this->Other11;
    }
    /**
     * Set Other11 value
     * @param string $other11
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther11($other11 = null)
    {
        // validation for constraint: string
        if (!is_null($other11) && !is_string($other11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other11)), __LINE__);
        }
        $this->Other11 = $other11;
        return $this;
    }
    /**
     * Get Other12 value
     * @return string|null
     */
    public function getOther12()
    {
        return $this->Other12;
    }
    /**
     * Set Other12 value
     * @param string $other12
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther12($other12 = null)
    {
        // validation for constraint: string
        if (!is_null($other12) && !is_string($other12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other12)), __LINE__);
        }
        $this->Other12 = $other12;
        return $this;
    }
    /**
     * Get Other13 value
     * @return string|null
     */
    public function getOther13()
    {
        return $this->Other13;
    }
    /**
     * Set Other13 value
     * @param string $other13
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther13($other13 = null)
    {
        // validation for constraint: string
        if (!is_null($other13) && !is_string($other13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other13)), __LINE__);
        }
        $this->Other13 = $other13;
        return $this;
    }
    /**
     * Get Other14 value
     * @return string|null
     */
    public function getOther14()
    {
        return $this->Other14;
    }
    /**
     * Set Other14 value
     * @param string $other14
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther14($other14 = null)
    {
        // validation for constraint: string
        if (!is_null($other14) && !is_string($other14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other14)), __LINE__);
        }
        $this->Other14 = $other14;
        return $this;
    }
    /**
     * Get Other15 value
     * @return string|null
     */
    public function getOther15()
    {
        return $this->Other15;
    }
    /**
     * Set Other15 value
     * @param string $other15
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther15($other15 = null)
    {
        // validation for constraint: string
        if (!is_null($other15) && !is_string($other15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other15)), __LINE__);
        }
        $this->Other15 = $other15;
        return $this;
    }
    /**
     * Get Other16 value
     * @return string|null
     */
    public function getOther16()
    {
        return $this->Other16;
    }
    /**
     * Set Other16 value
     * @param string $other16
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther16($other16 = null)
    {
        // validation for constraint: string
        if (!is_null($other16) && !is_string($other16)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other16)), __LINE__);
        }
        $this->Other16 = $other16;
        return $this;
    }
    /**
     * Get Other17 value
     * @return string|null
     */
    public function getOther17()
    {
        return $this->Other17;
    }
    /**
     * Set Other17 value
     * @param string $other17
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther17($other17 = null)
    {
        // validation for constraint: string
        if (!is_null($other17) && !is_string($other17)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other17)), __LINE__);
        }
        $this->Other17 = $other17;
        return $this;
    }
    /**
     * Get Other18 value
     * @return string|null
     */
    public function getOther18()
    {
        return $this->Other18;
    }
    /**
     * Set Other18 value
     * @param string $other18
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther18($other18 = null)
    {
        // validation for constraint: string
        if (!is_null($other18) && !is_string($other18)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other18)), __LINE__);
        }
        $this->Other18 = $other18;
        return $this;
    }
    /**
     * Get Other19 value
     * @return string|null
     */
    public function getOther19()
    {
        return $this->Other19;
    }
    /**
     * Set Other19 value
     * @param string $other19
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther19($other19 = null)
    {
        // validation for constraint: string
        if (!is_null($other19) && !is_string($other19)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other19)), __LINE__);
        }
        $this->Other19 = $other19;
        return $this;
    }
    /**
     * Get Other20 value
     * @return string|null
     */
    public function getOther20()
    {
        return $this->Other20;
    }
    /**
     * Set Other20 value
     * @param string $other20
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOther20($other20 = null)
    {
        // validation for constraint: string
        if (!is_null($other20) && !is_string($other20)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other20)), __LINE__);
        }
        $this->Other20 = $other20;
        return $this;
    }
    /**
     * Get OrderDetails value
     * @return \ArrayType\ArrayOfOrderImportDetail|null
     */
    public function getOrderDetails()
    {
        return $this->OrderDetails;
    }
    /**
     * Set OrderDetails value
     * @param \ArrayType\ArrayOfOrderImportDetail $orderDetails
     * @return \StructType\CreateOrderImportRequest
     */
    public function setOrderDetails(\ArrayType\ArrayOfOrderImportDetail $orderDetails = null)
    {
        $this->OrderDetails = $orderDetails;
        return $this;
    }
    /**
     * Get ManualOrderKey value
     * @return string|null
     */
    public function getManualOrderKey()
    {
        return $this->ManualOrderKey;
    }
    /**
     * Set ManualOrderKey value
     * @param string $manualOrderKey
     * @return \StructType\CreateOrderImportRequest
     */
    public function setManualOrderKey($manualOrderKey = null)
    {
        // validation for constraint: string
        if (!is_null($manualOrderKey) && !is_string($manualOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manualOrderKey)), __LINE__);
        }
        $this->ManualOrderKey = $manualOrderKey;
        return $this;
    }
    /**
     * Get ReturnOrderKey value
     * @return string|null
     */
    public function getReturnOrderKey()
    {
        return $this->ReturnOrderKey;
    }
    /**
     * Set ReturnOrderKey value
     * @param string $returnOrderKey
     * @return \StructType\CreateOrderImportRequest
     */
    public function setReturnOrderKey($returnOrderKey = null)
    {
        // validation for constraint: string
        if (!is_null($returnOrderKey) && !is_string($returnOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnOrderKey)), __LINE__);
        }
        $this->ReturnOrderKey = $returnOrderKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateOrderImportRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ExistingOrderKey value
     * @return string|null
     */
    public function getExistingOrderKey()
    {
        return $this->ExistingOrderKey;
    }
    /**
     * Set ExistingOrderKey value
     * @param string $existingOrderKey
     * @return \StructType\CreateOrderImportRequest
     */
    public function setExistingOrderKey($existingOrderKey = null)
    {
        // validation for constraint: string
        if (!is_null($existingOrderKey) && !is_string($existingOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existingOrderKey)), __LINE__);
        }
        $this->ExistingOrderKey = $existingOrderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrderImportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
