<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderDetailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateOrderDetailRequest
 * @subpackage Structs
 */
class CreateOrderDetailRequest extends ApiRequest
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The OrderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderLine;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The PriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceEach;
    /**
     * The PriceExt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceExt;
    /**
     * The BVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BVEach;
    /**
     * The BusinessVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BusinessVolume;
    /**
     * The CVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CVEach;
    /**
     * The CommissionableVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CommissionableVolume;
    /**
     * The ShippingPriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShippingPriceEach;
    /**
     * The ChargeShippingOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ChargeShippingOn;
    /**
     * The IsTaxedInRegion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTaxedInRegion;
    /**
     * The IsTaxedInRegionFed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTaxedInRegionFed;
    /**
     * The IsTaxedInRegionState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTaxedInRegionState;
    /**
     * The TaxablePriceEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxablePriceEach;
    /**
     * The Taxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Taxable;
    /**
     * The CombinedTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CombinedTax;
    /**
     * The FedTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FedTax;
    /**
     * The StateTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $StateTax;
    /**
     * The CityTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CityTax;
    /**
     * The CityLocalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CityLocalTax;
    /**
     * The CountyTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CountyTax;
    /**
     * The CountyLocalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CountyLocalTax;
    /**
     * The ManualTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ManualTax;
    /**
     * The IsBackOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsBackOrder;
    /**
     * The WeightEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $WeightEach;
    /**
     * The Other1Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other1Each;
    /**
     * The Other1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other1;
    /**
     * The Other2Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other2Each;
    /**
     * The Other2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other2;
    /**
     * The Other3Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other3Each;
    /**
     * The Other3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other3;
    /**
     * The Other4Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other4Each;
    /**
     * The Other4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other4;
    /**
     * The Other5Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other5Each;
    /**
     * The Other5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other5;
    /**
     * The Other6Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other6Each;
    /**
     * The Other6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other6;
    /**
     * The Other7Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other7Each;
    /**
     * The Other7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other7;
    /**
     * The Other8Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other8Each;
    /**
     * The Other8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other8;
    /**
     * The Other9Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other9Each;
    /**
     * The Other9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other9;
    /**
     * The Other10Each
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other10Each;
    /**
     * The Other10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Other10;
    /**
     * The DiscountExt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountExt;
    /**
     * The OriginalTaxableEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OriginalTaxableEach;
    /**
     * The OriginalBVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OriginalBVEach;
    /**
     * The OriginalCVEach
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OriginalCVEach;
    /**
     * The StateTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $StateTaxable;
    /**
     * The IsStateTaxOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsStateTaxOverride;
    /**
     * The DynamicKitItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DynamicKitItemID;
    /**
     * The HandlingFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HandlingFee;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference1;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for CreateOrderDetailRequest
     * @uses CreateOrderDetailRequest::setOrderID()
     * @uses CreateOrderDetailRequest::setOrderLine()
     * @uses CreateOrderDetailRequest::setQty()
     * @uses CreateOrderDetailRequest::setPriceEach()
     * @uses CreateOrderDetailRequest::setPriceExt()
     * @uses CreateOrderDetailRequest::setBVEach()
     * @uses CreateOrderDetailRequest::setBusinessVolume()
     * @uses CreateOrderDetailRequest::setCVEach()
     * @uses CreateOrderDetailRequest::setCommissionableVolume()
     * @uses CreateOrderDetailRequest::setShippingPriceEach()
     * @uses CreateOrderDetailRequest::setChargeShippingOn()
     * @uses CreateOrderDetailRequest::setIsTaxedInRegion()
     * @uses CreateOrderDetailRequest::setIsTaxedInRegionFed()
     * @uses CreateOrderDetailRequest::setIsTaxedInRegionState()
     * @uses CreateOrderDetailRequest::setTaxablePriceEach()
     * @uses CreateOrderDetailRequest::setTaxable()
     * @uses CreateOrderDetailRequest::setCombinedTax()
     * @uses CreateOrderDetailRequest::setFedTax()
     * @uses CreateOrderDetailRequest::setStateTax()
     * @uses CreateOrderDetailRequest::setCityTax()
     * @uses CreateOrderDetailRequest::setCityLocalTax()
     * @uses CreateOrderDetailRequest::setCountyTax()
     * @uses CreateOrderDetailRequest::setCountyLocalTax()
     * @uses CreateOrderDetailRequest::setManualTax()
     * @uses CreateOrderDetailRequest::setIsBackOrder()
     * @uses CreateOrderDetailRequest::setWeightEach()
     * @uses CreateOrderDetailRequest::setOther1Each()
     * @uses CreateOrderDetailRequest::setOther1()
     * @uses CreateOrderDetailRequest::setOther2Each()
     * @uses CreateOrderDetailRequest::setOther2()
     * @uses CreateOrderDetailRequest::setOther3Each()
     * @uses CreateOrderDetailRequest::setOther3()
     * @uses CreateOrderDetailRequest::setOther4Each()
     * @uses CreateOrderDetailRequest::setOther4()
     * @uses CreateOrderDetailRequest::setOther5Each()
     * @uses CreateOrderDetailRequest::setOther5()
     * @uses CreateOrderDetailRequest::setOther6Each()
     * @uses CreateOrderDetailRequest::setOther6()
     * @uses CreateOrderDetailRequest::setOther7Each()
     * @uses CreateOrderDetailRequest::setOther7()
     * @uses CreateOrderDetailRequest::setOther8Each()
     * @uses CreateOrderDetailRequest::setOther8()
     * @uses CreateOrderDetailRequest::setOther9Each()
     * @uses CreateOrderDetailRequest::setOther9()
     * @uses CreateOrderDetailRequest::setOther10Each()
     * @uses CreateOrderDetailRequest::setOther10()
     * @uses CreateOrderDetailRequest::setDiscountExt()
     * @uses CreateOrderDetailRequest::setOriginalTaxableEach()
     * @uses CreateOrderDetailRequest::setOriginalBVEach()
     * @uses CreateOrderDetailRequest::setOriginalCVEach()
     * @uses CreateOrderDetailRequest::setStateTaxable()
     * @uses CreateOrderDetailRequest::setIsStateTaxOverride()
     * @uses CreateOrderDetailRequest::setDynamicKitItemID()
     * @uses CreateOrderDetailRequest::setHandlingFee()
     * @uses CreateOrderDetailRequest::setItemCode()
     * @uses CreateOrderDetailRequest::setDescription()
     * @uses CreateOrderDetailRequest::setReference1()
     * @uses CreateOrderDetailRequest::setOrderKey()
     * @param int $orderID
     * @param int $orderLine
     * @param float $qty
     * @param float $priceEach
     * @param float $priceExt
     * @param float $bVEach
     * @param float $businessVolume
     * @param float $cVEach
     * @param float $commissionableVolume
     * @param float $shippingPriceEach
     * @param float $chargeShippingOn
     * @param bool $isTaxedInRegion
     * @param bool $isTaxedInRegionFed
     * @param bool $isTaxedInRegionState
     * @param float $taxablePriceEach
     * @param float $taxable
     * @param float $combinedTax
     * @param float $fedTax
     * @param float $stateTax
     * @param float $cityTax
     * @param float $cityLocalTax
     * @param float $countyTax
     * @param float $countyLocalTax
     * @param float $manualTax
     * @param bool $isBackOrder
     * @param float $weightEach
     * @param float $other1Each
     * @param float $other1
     * @param float $other2Each
     * @param float $other2
     * @param float $other3Each
     * @param float $other3
     * @param float $other4Each
     * @param float $other4
     * @param float $other5Each
     * @param float $other5
     * @param float $other6Each
     * @param float $other6
     * @param float $other7Each
     * @param float $other7
     * @param float $other8Each
     * @param float $other8
     * @param float $other9Each
     * @param float $other9
     * @param float $other10Each
     * @param float $other10
     * @param float $discountExt
     * @param float $originalTaxableEach
     * @param float $originalBVEach
     * @param float $originalCVEach
     * @param float $stateTaxable
     * @param bool $isStateTaxOverride
     * @param int $dynamicKitItemID
     * @param float $handlingFee
     * @param string $itemCode
     * @param string $description
     * @param string $reference1
     * @param string $orderKey
     */
    public function __construct($orderID = null, $orderLine = null, $qty = null, $priceEach = null, $priceExt = null, $bVEach = null, $businessVolume = null, $cVEach = null, $commissionableVolume = null, $shippingPriceEach = null, $chargeShippingOn = null, $isTaxedInRegion = null, $isTaxedInRegionFed = null, $isTaxedInRegionState = null, $taxablePriceEach = null, $taxable = null, $combinedTax = null, $fedTax = null, $stateTax = null, $cityTax = null, $cityLocalTax = null, $countyTax = null, $countyLocalTax = null, $manualTax = null, $isBackOrder = null, $weightEach = null, $other1Each = null, $other1 = null, $other2Each = null, $other2 = null, $other3Each = null, $other3 = null, $other4Each = null, $other4 = null, $other5Each = null, $other5 = null, $other6Each = null, $other6 = null, $other7Each = null, $other7 = null, $other8Each = null, $other8 = null, $other9Each = null, $other9 = null, $other10Each = null, $other10 = null, $discountExt = null, $originalTaxableEach = null, $originalBVEach = null, $originalCVEach = null, $stateTaxable = null, $isStateTaxOverride = null, $dynamicKitItemID = null, $handlingFee = null, $itemCode = null, $description = null, $reference1 = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOrderLine($orderLine)
            ->setQty($qty)
            ->setPriceEach($priceEach)
            ->setPriceExt($priceExt)
            ->setBVEach($bVEach)
            ->setBusinessVolume($businessVolume)
            ->setCVEach($cVEach)
            ->setCommissionableVolume($commissionableVolume)
            ->setShippingPriceEach($shippingPriceEach)
            ->setChargeShippingOn($chargeShippingOn)
            ->setIsTaxedInRegion($isTaxedInRegion)
            ->setIsTaxedInRegionFed($isTaxedInRegionFed)
            ->setIsTaxedInRegionState($isTaxedInRegionState)
            ->setTaxablePriceEach($taxablePriceEach)
            ->setTaxable($taxable)
            ->setCombinedTax($combinedTax)
            ->setFedTax($fedTax)
            ->setStateTax($stateTax)
            ->setCityTax($cityTax)
            ->setCityLocalTax($cityLocalTax)
            ->setCountyTax($countyTax)
            ->setCountyLocalTax($countyLocalTax)
            ->setManualTax($manualTax)
            ->setIsBackOrder($isBackOrder)
            ->setWeightEach($weightEach)
            ->setOther1Each($other1Each)
            ->setOther1($other1)
            ->setOther2Each($other2Each)
            ->setOther2($other2)
            ->setOther3Each($other3Each)
            ->setOther3($other3)
            ->setOther4Each($other4Each)
            ->setOther4($other4)
            ->setOther5Each($other5Each)
            ->setOther5($other5)
            ->setOther6Each($other6Each)
            ->setOther6($other6)
            ->setOther7Each($other7Each)
            ->setOther7($other7)
            ->setOther8Each($other8Each)
            ->setOther8($other8)
            ->setOther9Each($other9Each)
            ->setOther9($other9)
            ->setOther10Each($other10Each)
            ->setOther10($other10)
            ->setDiscountExt($discountExt)
            ->setOriginalTaxableEach($originalTaxableEach)
            ->setOriginalBVEach($originalBVEach)
            ->setOriginalCVEach($originalCVEach)
            ->setStateTaxable($stateTaxable)
            ->setIsStateTaxOverride($isStateTaxOverride)
            ->setDynamicKitItemID($dynamicKitItemID)
            ->setHandlingFee($handlingFee)
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setReference1($reference1)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OrderLine value
     * @return int
     */
    public function getOrderLine()
    {
        return $this->OrderLine;
    }
    /**
     * Set OrderLine value
     * @param int $orderLine
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !is_numeric($orderLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderLine)), __LINE__);
        }
        $this->OrderLine = $orderLine;
        return $this;
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setQty($qty = null)
    {
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get PriceEach value
     * @return float
     */
    public function getPriceEach()
    {
        return $this->PriceEach;
    }
    /**
     * Set PriceEach value
     * @param float $priceEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setPriceEach($priceEach = null)
    {
        $this->PriceEach = $priceEach;
        return $this;
    }
    /**
     * Get PriceExt value
     * @return float
     */
    public function getPriceExt()
    {
        return $this->PriceExt;
    }
    /**
     * Set PriceExt value
     * @param float $priceExt
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setPriceExt($priceExt = null)
    {
        $this->PriceExt = $priceExt;
        return $this;
    }
    /**
     * Get BVEach value
     * @return float
     */
    public function getBVEach()
    {
        return $this->BVEach;
    }
    /**
     * Set BVEach value
     * @param float $bVEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setBVEach($bVEach = null)
    {
        $this->BVEach = $bVEach;
        return $this;
    }
    /**
     * Get BusinessVolume value
     * @return float
     */
    public function getBusinessVolume()
    {
        return $this->BusinessVolume;
    }
    /**
     * Set BusinessVolume value
     * @param float $businessVolume
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setBusinessVolume($businessVolume = null)
    {
        $this->BusinessVolume = $businessVolume;
        return $this;
    }
    /**
     * Get CVEach value
     * @return float
     */
    public function getCVEach()
    {
        return $this->CVEach;
    }
    /**
     * Set CVEach value
     * @param float $cVEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCVEach($cVEach = null)
    {
        $this->CVEach = $cVEach;
        return $this;
    }
    /**
     * Get CommissionableVolume value
     * @return float
     */
    public function getCommissionableVolume()
    {
        return $this->CommissionableVolume;
    }
    /**
     * Set CommissionableVolume value
     * @param float $commissionableVolume
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCommissionableVolume($commissionableVolume = null)
    {
        $this->CommissionableVolume = $commissionableVolume;
        return $this;
    }
    /**
     * Get ShippingPriceEach value
     * @return float
     */
    public function getShippingPriceEach()
    {
        return $this->ShippingPriceEach;
    }
    /**
     * Set ShippingPriceEach value
     * @param float $shippingPriceEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setShippingPriceEach($shippingPriceEach = null)
    {
        $this->ShippingPriceEach = $shippingPriceEach;
        return $this;
    }
    /**
     * Get ChargeShippingOn value
     * @return float
     */
    public function getChargeShippingOn()
    {
        return $this->ChargeShippingOn;
    }
    /**
     * Set ChargeShippingOn value
     * @param float $chargeShippingOn
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setChargeShippingOn($chargeShippingOn = null)
    {
        $this->ChargeShippingOn = $chargeShippingOn;
        return $this;
    }
    /**
     * Get IsTaxedInRegion value
     * @return bool
     */
    public function getIsTaxedInRegion()
    {
        return $this->IsTaxedInRegion;
    }
    /**
     * Set IsTaxedInRegion value
     * @param bool $isTaxedInRegion
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setIsTaxedInRegion($isTaxedInRegion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxedInRegion) && !is_bool($isTaxedInRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxedInRegion)), __LINE__);
        }
        $this->IsTaxedInRegion = $isTaxedInRegion;
        return $this;
    }
    /**
     * Get IsTaxedInRegionFed value
     * @return bool
     */
    public function getIsTaxedInRegionFed()
    {
        return $this->IsTaxedInRegionFed;
    }
    /**
     * Set IsTaxedInRegionFed value
     * @param bool $isTaxedInRegionFed
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setIsTaxedInRegionFed($isTaxedInRegionFed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxedInRegionFed) && !is_bool($isTaxedInRegionFed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxedInRegionFed)), __LINE__);
        }
        $this->IsTaxedInRegionFed = $isTaxedInRegionFed;
        return $this;
    }
    /**
     * Get IsTaxedInRegionState value
     * @return bool
     */
    public function getIsTaxedInRegionState()
    {
        return $this->IsTaxedInRegionState;
    }
    /**
     * Set IsTaxedInRegionState value
     * @param bool $isTaxedInRegionState
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setIsTaxedInRegionState($isTaxedInRegionState = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxedInRegionState) && !is_bool($isTaxedInRegionState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxedInRegionState)), __LINE__);
        }
        $this->IsTaxedInRegionState = $isTaxedInRegionState;
        return $this;
    }
    /**
     * Get TaxablePriceEach value
     * @return float
     */
    public function getTaxablePriceEach()
    {
        return $this->TaxablePriceEach;
    }
    /**
     * Set TaxablePriceEach value
     * @param float $taxablePriceEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setTaxablePriceEach($taxablePriceEach = null)
    {
        $this->TaxablePriceEach = $taxablePriceEach;
        return $this;
    }
    /**
     * Get Taxable value
     * @return float
     */
    public function getTaxable()
    {
        return $this->Taxable;
    }
    /**
     * Set Taxable value
     * @param float $taxable
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setTaxable($taxable = null)
    {
        $this->Taxable = $taxable;
        return $this;
    }
    /**
     * Get CombinedTax value
     * @return float
     */
    public function getCombinedTax()
    {
        return $this->CombinedTax;
    }
    /**
     * Set CombinedTax value
     * @param float $combinedTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCombinedTax($combinedTax = null)
    {
        $this->CombinedTax = $combinedTax;
        return $this;
    }
    /**
     * Get FedTax value
     * @return float
     */
    public function getFedTax()
    {
        return $this->FedTax;
    }
    /**
     * Set FedTax value
     * @param float $fedTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setFedTax($fedTax = null)
    {
        $this->FedTax = $fedTax;
        return $this;
    }
    /**
     * Get StateTax value
     * @return float
     */
    public function getStateTax()
    {
        return $this->StateTax;
    }
    /**
     * Set StateTax value
     * @param float $stateTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setStateTax($stateTax = null)
    {
        $this->StateTax = $stateTax;
        return $this;
    }
    /**
     * Get CityTax value
     * @return float
     */
    public function getCityTax()
    {
        return $this->CityTax;
    }
    /**
     * Set CityTax value
     * @param float $cityTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCityTax($cityTax = null)
    {
        $this->CityTax = $cityTax;
        return $this;
    }
    /**
     * Get CityLocalTax value
     * @return float
     */
    public function getCityLocalTax()
    {
        return $this->CityLocalTax;
    }
    /**
     * Set CityLocalTax value
     * @param float $cityLocalTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCityLocalTax($cityLocalTax = null)
    {
        $this->CityLocalTax = $cityLocalTax;
        return $this;
    }
    /**
     * Get CountyTax value
     * @return float
     */
    public function getCountyTax()
    {
        return $this->CountyTax;
    }
    /**
     * Set CountyTax value
     * @param float $countyTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCountyTax($countyTax = null)
    {
        $this->CountyTax = $countyTax;
        return $this;
    }
    /**
     * Get CountyLocalTax value
     * @return float
     */
    public function getCountyLocalTax()
    {
        return $this->CountyLocalTax;
    }
    /**
     * Set CountyLocalTax value
     * @param float $countyLocalTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setCountyLocalTax($countyLocalTax = null)
    {
        $this->CountyLocalTax = $countyLocalTax;
        return $this;
    }
    /**
     * Get ManualTax value
     * @return float
     */
    public function getManualTax()
    {
        return $this->ManualTax;
    }
    /**
     * Set ManualTax value
     * @param float $manualTax
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setManualTax($manualTax = null)
    {
        $this->ManualTax = $manualTax;
        return $this;
    }
    /**
     * Get IsBackOrder value
     * @return bool
     */
    public function getIsBackOrder()
    {
        return $this->IsBackOrder;
    }
    /**
     * Set IsBackOrder value
     * @param bool $isBackOrder
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setIsBackOrder($isBackOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackOrder) && !is_bool($isBackOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBackOrder)), __LINE__);
        }
        $this->IsBackOrder = $isBackOrder;
        return $this;
    }
    /**
     * Get WeightEach value
     * @return float
     */
    public function getWeightEach()
    {
        return $this->WeightEach;
    }
    /**
     * Set WeightEach value
     * @param float $weightEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setWeightEach($weightEach = null)
    {
        $this->WeightEach = $weightEach;
        return $this;
    }
    /**
     * Get Other1Each value
     * @return float
     */
    public function getOther1Each()
    {
        return $this->Other1Each;
    }
    /**
     * Set Other1Each value
     * @param float $other1Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther1Each($other1Each = null)
    {
        $this->Other1Each = $other1Each;
        return $this;
    }
    /**
     * Get Other1 value
     * @return float
     */
    public function getOther1()
    {
        return $this->Other1;
    }
    /**
     * Set Other1 value
     * @param float $other1
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther1($other1 = null)
    {
        $this->Other1 = $other1;
        return $this;
    }
    /**
     * Get Other2Each value
     * @return float
     */
    public function getOther2Each()
    {
        return $this->Other2Each;
    }
    /**
     * Set Other2Each value
     * @param float $other2Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther2Each($other2Each = null)
    {
        $this->Other2Each = $other2Each;
        return $this;
    }
    /**
     * Get Other2 value
     * @return float
     */
    public function getOther2()
    {
        return $this->Other2;
    }
    /**
     * Set Other2 value
     * @param float $other2
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther2($other2 = null)
    {
        $this->Other2 = $other2;
        return $this;
    }
    /**
     * Get Other3Each value
     * @return float
     */
    public function getOther3Each()
    {
        return $this->Other3Each;
    }
    /**
     * Set Other3Each value
     * @param float $other3Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther3Each($other3Each = null)
    {
        $this->Other3Each = $other3Each;
        return $this;
    }
    /**
     * Get Other3 value
     * @return float
     */
    public function getOther3()
    {
        return $this->Other3;
    }
    /**
     * Set Other3 value
     * @param float $other3
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther3($other3 = null)
    {
        $this->Other3 = $other3;
        return $this;
    }
    /**
     * Get Other4Each value
     * @return float
     */
    public function getOther4Each()
    {
        return $this->Other4Each;
    }
    /**
     * Set Other4Each value
     * @param float $other4Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther4Each($other4Each = null)
    {
        $this->Other4Each = $other4Each;
        return $this;
    }
    /**
     * Get Other4 value
     * @return float
     */
    public function getOther4()
    {
        return $this->Other4;
    }
    /**
     * Set Other4 value
     * @param float $other4
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther4($other4 = null)
    {
        $this->Other4 = $other4;
        return $this;
    }
    /**
     * Get Other5Each value
     * @return float
     */
    public function getOther5Each()
    {
        return $this->Other5Each;
    }
    /**
     * Set Other5Each value
     * @param float $other5Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther5Each($other5Each = null)
    {
        $this->Other5Each = $other5Each;
        return $this;
    }
    /**
     * Get Other5 value
     * @return float
     */
    public function getOther5()
    {
        return $this->Other5;
    }
    /**
     * Set Other5 value
     * @param float $other5
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther5($other5 = null)
    {
        $this->Other5 = $other5;
        return $this;
    }
    /**
     * Get Other6Each value
     * @return float
     */
    public function getOther6Each()
    {
        return $this->Other6Each;
    }
    /**
     * Set Other6Each value
     * @param float $other6Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther6Each($other6Each = null)
    {
        $this->Other6Each = $other6Each;
        return $this;
    }
    /**
     * Get Other6 value
     * @return float
     */
    public function getOther6()
    {
        return $this->Other6;
    }
    /**
     * Set Other6 value
     * @param float $other6
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther6($other6 = null)
    {
        $this->Other6 = $other6;
        return $this;
    }
    /**
     * Get Other7Each value
     * @return float
     */
    public function getOther7Each()
    {
        return $this->Other7Each;
    }
    /**
     * Set Other7Each value
     * @param float $other7Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther7Each($other7Each = null)
    {
        $this->Other7Each = $other7Each;
        return $this;
    }
    /**
     * Get Other7 value
     * @return float
     */
    public function getOther7()
    {
        return $this->Other7;
    }
    /**
     * Set Other7 value
     * @param float $other7
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther7($other7 = null)
    {
        $this->Other7 = $other7;
        return $this;
    }
    /**
     * Get Other8Each value
     * @return float
     */
    public function getOther8Each()
    {
        return $this->Other8Each;
    }
    /**
     * Set Other8Each value
     * @param float $other8Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther8Each($other8Each = null)
    {
        $this->Other8Each = $other8Each;
        return $this;
    }
    /**
     * Get Other8 value
     * @return float
     */
    public function getOther8()
    {
        return $this->Other8;
    }
    /**
     * Set Other8 value
     * @param float $other8
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther8($other8 = null)
    {
        $this->Other8 = $other8;
        return $this;
    }
    /**
     * Get Other9Each value
     * @return float
     */
    public function getOther9Each()
    {
        return $this->Other9Each;
    }
    /**
     * Set Other9Each value
     * @param float $other9Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther9Each($other9Each = null)
    {
        $this->Other9Each = $other9Each;
        return $this;
    }
    /**
     * Get Other9 value
     * @return float
     */
    public function getOther9()
    {
        return $this->Other9;
    }
    /**
     * Set Other9 value
     * @param float $other9
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther9($other9 = null)
    {
        $this->Other9 = $other9;
        return $this;
    }
    /**
     * Get Other10Each value
     * @return float
     */
    public function getOther10Each()
    {
        return $this->Other10Each;
    }
    /**
     * Set Other10Each value
     * @param float $other10Each
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther10Each($other10Each = null)
    {
        $this->Other10Each = $other10Each;
        return $this;
    }
    /**
     * Get Other10 value
     * @return float
     */
    public function getOther10()
    {
        return $this->Other10;
    }
    /**
     * Set Other10 value
     * @param float $other10
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOther10($other10 = null)
    {
        $this->Other10 = $other10;
        return $this;
    }
    /**
     * Get DiscountExt value
     * @return float
     */
    public function getDiscountExt()
    {
        return $this->DiscountExt;
    }
    /**
     * Set DiscountExt value
     * @param float $discountExt
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setDiscountExt($discountExt = null)
    {
        $this->DiscountExt = $discountExt;
        return $this;
    }
    /**
     * Get OriginalTaxableEach value
     * @return float
     */
    public function getOriginalTaxableEach()
    {
        return $this->OriginalTaxableEach;
    }
    /**
     * Set OriginalTaxableEach value
     * @param float $originalTaxableEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOriginalTaxableEach($originalTaxableEach = null)
    {
        $this->OriginalTaxableEach = $originalTaxableEach;
        return $this;
    }
    /**
     * Get OriginalBVEach value
     * @return float
     */
    public function getOriginalBVEach()
    {
        return $this->OriginalBVEach;
    }
    /**
     * Set OriginalBVEach value
     * @param float $originalBVEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOriginalBVEach($originalBVEach = null)
    {
        $this->OriginalBVEach = $originalBVEach;
        return $this;
    }
    /**
     * Get OriginalCVEach value
     * @return float
     */
    public function getOriginalCVEach()
    {
        return $this->OriginalCVEach;
    }
    /**
     * Set OriginalCVEach value
     * @param float $originalCVEach
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOriginalCVEach($originalCVEach = null)
    {
        $this->OriginalCVEach = $originalCVEach;
        return $this;
    }
    /**
     * Get StateTaxable value
     * @return float
     */
    public function getStateTaxable()
    {
        return $this->StateTaxable;
    }
    /**
     * Set StateTaxable value
     * @param float $stateTaxable
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setStateTaxable($stateTaxable = null)
    {
        $this->StateTaxable = $stateTaxable;
        return $this;
    }
    /**
     * Get IsStateTaxOverride value
     * @return bool
     */
    public function getIsStateTaxOverride()
    {
        return $this->IsStateTaxOverride;
    }
    /**
     * Set IsStateTaxOverride value
     * @param bool $isStateTaxOverride
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setIsStateTaxOverride($isStateTaxOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStateTaxOverride) && !is_bool($isStateTaxOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isStateTaxOverride)), __LINE__);
        }
        $this->IsStateTaxOverride = $isStateTaxOverride;
        return $this;
    }
    /**
     * Get DynamicKitItemID value
     * @return int
     */
    public function getDynamicKitItemID()
    {
        return $this->DynamicKitItemID;
    }
    /**
     * Set DynamicKitItemID value
     * @param int $dynamicKitItemID
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setDynamicKitItemID($dynamicKitItemID = null)
    {
        // validation for constraint: int
        if (!is_null($dynamicKitItemID) && !is_numeric($dynamicKitItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dynamicKitItemID)), __LINE__);
        }
        $this->DynamicKitItemID = $dynamicKitItemID;
        return $this;
    }
    /**
     * Get HandlingFee value
     * @return float
     */
    public function getHandlingFee()
    {
        return $this->HandlingFee;
    }
    /**
     * Set HandlingFee value
     * @param float $handlingFee
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setHandlingFee($handlingFee = null)
    {
        $this->HandlingFee = $handlingFee;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\CreateOrderDetailRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrderDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
