<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateGuestResponse StructType
 * @subpackage Structs
 */
class CreateGuestResponse extends ApiResponse
{
    /**
     * The GuestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GuestID;
    /**
     * Constructor method for CreateGuestResponse
     * @uses CreateGuestResponse::setGuestID()
     * @param int $guestID
     */
    public function __construct($guestID = null)
    {
        $this
            ->setGuestID($guestID);
    }
    /**
     * Get GuestID value
     * @return int
     */
    public function getGuestID()
    {
        return $this->GuestID;
    }
    /**
     * Set GuestID value
     * @param int $guestID
     * @return \StructType\CreateGuestResponse
     */
    public function setGuestID($guestID = null)
    {
        // validation for constraint: int
        if (!is_null($guestID) && !is_numeric($guestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($guestID)), __LINE__);
        }
        $this->GuestID = $guestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateGuestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
