<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateEmailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateEmailRequest
 * @subpackage Structs
 */
class CreateEmailRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The MailFolderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MailFolderType;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Priority;
    /**
     * The MailStatusType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MailStatusType;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The MailFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailFrom;
    /**
     * The MailTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailTo;
    /**
     * The ReplyTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyTo;
    /**
     * The MailCC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCC;
    /**
     * The MailBCC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailBCC;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The SmtpServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SmtpServer;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmailAttachment
     */
    public $Attachments;
    /**
     * The ForwardedAttachments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfForwardedAttachment
     */
    public $ForwardedAttachments;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateEmailRequest
     * @uses CreateEmailRequest::setCustomerID()
     * @uses CreateEmailRequest::setMailFolderType()
     * @uses CreateEmailRequest::setPriority()
     * @uses CreateEmailRequest::setMailStatusType()
     * @uses CreateEmailRequest::setSubject()
     * @uses CreateEmailRequest::setMailFrom()
     * @uses CreateEmailRequest::setMailTo()
     * @uses CreateEmailRequest::setReplyTo()
     * @uses CreateEmailRequest::setMailCC()
     * @uses CreateEmailRequest::setMailBCC()
     * @uses CreateEmailRequest::setContent()
     * @uses CreateEmailRequest::setSmtpServer()
     * @uses CreateEmailRequest::setAttachments()
     * @uses CreateEmailRequest::setForwardedAttachments()
     * @uses CreateEmailRequest::setCustomerKey()
     * @param int $customerID
     * @param string $mailFolderType
     * @param string $priority
     * @param string $mailStatusType
     * @param string $subject
     * @param string $mailFrom
     * @param string $mailTo
     * @param string $replyTo
     * @param string $mailCC
     * @param string $mailBCC
     * @param string $content
     * @param string $smtpServer
     * @param \ArrayType\ArrayOfEmailAttachment $attachments
     * @param \ArrayType\ArrayOfForwardedAttachment $forwardedAttachments
     * @param string $customerKey
     */
    public function __construct($customerID = null, $mailFolderType = null, $priority = null, $mailStatusType = null, $subject = null, $mailFrom = null, $mailTo = null, $replyTo = null, $mailCC = null, $mailBCC = null, $content = null, $smtpServer = null, \ArrayType\ArrayOfEmailAttachment $attachments = null, \ArrayType\ArrayOfForwardedAttachment $forwardedAttachments = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailFolderType($mailFolderType)
            ->setPriority($priority)
            ->setMailStatusType($mailStatusType)
            ->setSubject($subject)
            ->setMailFrom($mailFrom)
            ->setMailTo($mailTo)
            ->setReplyTo($replyTo)
            ->setMailCC($mailCC)
            ->setMailBCC($mailBCC)
            ->setContent($content)
            ->setSmtpServer($smtpServer)
            ->setAttachments($attachments)
            ->setForwardedAttachments($forwardedAttachments)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateEmailRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailFolderType value
     * @return string
     */
    public function getMailFolderType()
    {
        return $this->MailFolderType;
    }
    /**
     * Set MailFolderType value
     * @uses \EnumType\MailForderType::valueIsValid()
     * @uses \EnumType\MailForderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mailFolderType
     * @return \StructType\CreateEmailRequest
     */
    public function setMailFolderType($mailFolderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MailForderType::valueIsValid($mailFolderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mailFolderType, implode(', ', \EnumType\MailForderType::getValidValues())), __LINE__);
        }
        $this->MailFolderType = $mailFolderType;
        return $this;
    }
    /**
     * Get Priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @uses \EnumType\MailPriority::valueIsValid()
     * @uses \EnumType\MailPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\CreateEmailRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MailPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\MailPriority::getValidValues())), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get MailStatusType value
     * @return string
     */
    public function getMailStatusType()
    {
        return $this->MailStatusType;
    }
    /**
     * Set MailStatusType value
     * @uses \EnumType\MailStatusType::valueIsValid()
     * @uses \EnumType\MailStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mailStatusType
     * @return \StructType\CreateEmailRequest
     */
    public function setMailStatusType($mailStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MailStatusType::valueIsValid($mailStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mailStatusType, implode(', ', \EnumType\MailStatusType::getValidValues())), __LINE__);
        }
        $this->MailStatusType = $mailStatusType;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\CreateEmailRequest
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get MailFrom value
     * @return string|null
     */
    public function getMailFrom()
    {
        return $this->MailFrom;
    }
    /**
     * Set MailFrom value
     * @param string $mailFrom
     * @return \StructType\CreateEmailRequest
     */
    public function setMailFrom($mailFrom = null)
    {
        // validation for constraint: string
        if (!is_null($mailFrom) && !is_string($mailFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailFrom)), __LINE__);
        }
        $this->MailFrom = $mailFrom;
        return $this;
    }
    /**
     * Get MailTo value
     * @return string|null
     */
    public function getMailTo()
    {
        return $this->MailTo;
    }
    /**
     * Set MailTo value
     * @param string $mailTo
     * @return \StructType\CreateEmailRequest
     */
    public function setMailTo($mailTo = null)
    {
        // validation for constraint: string
        if (!is_null($mailTo) && !is_string($mailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailTo)), __LINE__);
        }
        $this->MailTo = $mailTo;
        return $this;
    }
    /**
     * Get ReplyTo value
     * @return string|null
     */
    public function getReplyTo()
    {
        return $this->ReplyTo;
    }
    /**
     * Set ReplyTo value
     * @param string $replyTo
     * @return \StructType\CreateEmailRequest
     */
    public function setReplyTo($replyTo = null)
    {
        // validation for constraint: string
        if (!is_null($replyTo) && !is_string($replyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyTo)), __LINE__);
        }
        $this->ReplyTo = $replyTo;
        return $this;
    }
    /**
     * Get MailCC value
     * @return string|null
     */
    public function getMailCC()
    {
        return $this->MailCC;
    }
    /**
     * Set MailCC value
     * @param string $mailCC
     * @return \StructType\CreateEmailRequest
     */
    public function setMailCC($mailCC = null)
    {
        // validation for constraint: string
        if (!is_null($mailCC) && !is_string($mailCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCC)), __LINE__);
        }
        $this->MailCC = $mailCC;
        return $this;
    }
    /**
     * Get MailBCC value
     * @return string|null
     */
    public function getMailBCC()
    {
        return $this->MailBCC;
    }
    /**
     * Set MailBCC value
     * @param string $mailBCC
     * @return \StructType\CreateEmailRequest
     */
    public function setMailBCC($mailBCC = null)
    {
        // validation for constraint: string
        if (!is_null($mailBCC) && !is_string($mailBCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailBCC)), __LINE__);
        }
        $this->MailBCC = $mailBCC;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\CreateEmailRequest
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get SmtpServer value
     * @return string|null
     */
    public function getSmtpServer()
    {
        return $this->SmtpServer;
    }
    /**
     * Set SmtpServer value
     * @param string $smtpServer
     * @return \StructType\CreateEmailRequest
     */
    public function setSmtpServer($smtpServer = null)
    {
        // validation for constraint: string
        if (!is_null($smtpServer) && !is_string($smtpServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smtpServer)), __LINE__);
        }
        $this->SmtpServer = $smtpServer;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \ArrayType\ArrayOfEmailAttachment|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param \ArrayType\ArrayOfEmailAttachment $attachments
     * @return \StructType\CreateEmailRequest
     */
    public function setAttachments(\ArrayType\ArrayOfEmailAttachment $attachments = null)
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Get ForwardedAttachments value
     * @return \ArrayType\ArrayOfForwardedAttachment|null
     */
    public function getForwardedAttachments()
    {
        return $this->ForwardedAttachments;
    }
    /**
     * Set ForwardedAttachments value
     * @param \ArrayType\ArrayOfForwardedAttachment $forwardedAttachments
     * @return \StructType\CreateEmailRequest
     */
    public function setForwardedAttachments(\ArrayType\ArrayOfForwardedAttachment $forwardedAttachments = null)
    {
        $this->ForwardedAttachments = $forwardedAttachments;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateEmailRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
