<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateCustomerRequest
 * @subpackage Structs
 */
class CreateCustomerRequest extends ApiRequest
{
    /**
     * The CustomerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerType;
    /**
     * The CustomerStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerStatus;
    /**
     * The CanLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanLogin;
    /**
     * The InsertEnrollerTree
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InsertEnrollerTree;
    /**
     * The EnrollerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnrollerID;
    /**
     * The InsertUnilevelTree
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InsertUnilevelTree;
    /**
     * The SponsorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SponsorID;
    /**
     * The UseManualCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseManualCustomerID;
    /**
     * The ManualCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ManualCustomerID;
    /**
     * The SalesTaxExemptExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SalesTaxExemptExpireDate;
    /**
     * The IsSalesTaxExempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsSalesTaxExempt;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The SubscribeToBroadcasts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SubscribeToBroadcasts;
    /**
     * The EntryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntryDate;
    /**
     * The DefaultWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DefaultWarehouseID;
    /**
     * The PayableType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PayableType;
    /**
     * The CheckThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CheckThreshold;
    /**
     * The TaxIDType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TaxIDType;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The Date1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date1;
    /**
     * The Date2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date2;
    /**
     * The Date3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date3;
    /**
     * The Date4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date4;
    /**
     * The Date5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date5;
    /**
     * The BinaryPlacementPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BinaryPlacementPreference;
    /**
     * The UseBinaryHoldingTank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseBinaryHoldingTank;
    /**
     * The MainAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MainAddressVerified;
    /**
     * The MailAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MailAddressVerified;
    /**
     * The OtherAddressVerified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $OtherAddressVerified;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Phone2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone2;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The MainAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress1;
    /**
     * The MainAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress2;
    /**
     * The MainAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainAddress3;
    /**
     * The MainCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCity;
    /**
     * The MainState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainState;
    /**
     * The MainZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainZip;
    /**
     * The MainCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCountry;
    /**
     * The MainCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainCounty;
    /**
     * The MailAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress1;
    /**
     * The MailAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress2;
    /**
     * The MailAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress3;
    /**
     * The MailCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCity;
    /**
     * The MailState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailState;
    /**
     * The MailZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailZip;
    /**
     * The MailCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCountry;
    /**
     * The MailCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailCounty;
    /**
     * The OtherAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress1;
    /**
     * The OtherAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress2;
    /**
     * The OtherAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherAddress3;
    /**
     * The OtherCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCity;
    /**
     * The OtherState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherState;
    /**
     * The OtherZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherZip;
    /**
     * The OtherCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCountry;
    /**
     * The OtherCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCounty;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The LoginPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginPassword;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxID;
    /**
     * The SalesTaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesTaxID;
    /**
     * The Field1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field1;
    /**
     * The Field2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field2;
    /**
     * The Field3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field3;
    /**
     * The Field4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field4;
    /**
     * The Field5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field5;
    /**
     * The Field6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field6;
    /**
     * The Field7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field7;
    /**
     * The Field8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field8;
    /**
     * The Field9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field9;
    /**
     * The Field10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field10;
    /**
     * The Field11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field11;
    /**
     * The Field12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field12;
    /**
     * The Field13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field13;
    /**
     * The Field14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field14;
    /**
     * The Field15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field15;
    /**
     * The SubscribeFromIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscribeFromIPAddress;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PayableToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayableToName;
    /**
     * The VatRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatRegistration;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSuffix;
    /**
     * The SponsorKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SponsorKey;
    /**
     * The EnrollerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnrollerKey;
    /**
     * The ManualCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManualCustomerKey;
    /**
     * Constructor method for CreateCustomerRequest
     * @uses CreateCustomerRequest::setCustomerType()
     * @uses CreateCustomerRequest::setCustomerStatus()
     * @uses CreateCustomerRequest::setCanLogin()
     * @uses CreateCustomerRequest::setInsertEnrollerTree()
     * @uses CreateCustomerRequest::setEnrollerID()
     * @uses CreateCustomerRequest::setInsertUnilevelTree()
     * @uses CreateCustomerRequest::setSponsorID()
     * @uses CreateCustomerRequest::setUseManualCustomerID()
     * @uses CreateCustomerRequest::setManualCustomerID()
     * @uses CreateCustomerRequest::setSalesTaxExemptExpireDate()
     * @uses CreateCustomerRequest::setIsSalesTaxExempt()
     * @uses CreateCustomerRequest::setBirthDate()
     * @uses CreateCustomerRequest::setSubscribeToBroadcasts()
     * @uses CreateCustomerRequest::setEntryDate()
     * @uses CreateCustomerRequest::setDefaultWarehouseID()
     * @uses CreateCustomerRequest::setPayableType()
     * @uses CreateCustomerRequest::setCheckThreshold()
     * @uses CreateCustomerRequest::setTaxIDType()
     * @uses CreateCustomerRequest::setLanguageID()
     * @uses CreateCustomerRequest::setGender()
     * @uses CreateCustomerRequest::setDate1()
     * @uses CreateCustomerRequest::setDate2()
     * @uses CreateCustomerRequest::setDate3()
     * @uses CreateCustomerRequest::setDate4()
     * @uses CreateCustomerRequest::setDate5()
     * @uses CreateCustomerRequest::setBinaryPlacementPreference()
     * @uses CreateCustomerRequest::setUseBinaryHoldingTank()
     * @uses CreateCustomerRequest::setMainAddressVerified()
     * @uses CreateCustomerRequest::setMailAddressVerified()
     * @uses CreateCustomerRequest::setOtherAddressVerified()
     * @uses CreateCustomerRequest::setFirstName()
     * @uses CreateCustomerRequest::setLastName()
     * @uses CreateCustomerRequest::setCompany()
     * @uses CreateCustomerRequest::setEmail()
     * @uses CreateCustomerRequest::setPhone()
     * @uses CreateCustomerRequest::setPhone2()
     * @uses CreateCustomerRequest::setMobilePhone()
     * @uses CreateCustomerRequest::setFax()
     * @uses CreateCustomerRequest::setNotes()
     * @uses CreateCustomerRequest::setMainAddress1()
     * @uses CreateCustomerRequest::setMainAddress2()
     * @uses CreateCustomerRequest::setMainAddress3()
     * @uses CreateCustomerRequest::setMainCity()
     * @uses CreateCustomerRequest::setMainState()
     * @uses CreateCustomerRequest::setMainZip()
     * @uses CreateCustomerRequest::setMainCountry()
     * @uses CreateCustomerRequest::setMainCounty()
     * @uses CreateCustomerRequest::setMailAddress1()
     * @uses CreateCustomerRequest::setMailAddress2()
     * @uses CreateCustomerRequest::setMailAddress3()
     * @uses CreateCustomerRequest::setMailCity()
     * @uses CreateCustomerRequest::setMailState()
     * @uses CreateCustomerRequest::setMailZip()
     * @uses CreateCustomerRequest::setMailCountry()
     * @uses CreateCustomerRequest::setMailCounty()
     * @uses CreateCustomerRequest::setOtherAddress1()
     * @uses CreateCustomerRequest::setOtherAddress2()
     * @uses CreateCustomerRequest::setOtherAddress3()
     * @uses CreateCustomerRequest::setOtherCity()
     * @uses CreateCustomerRequest::setOtherState()
     * @uses CreateCustomerRequest::setOtherZip()
     * @uses CreateCustomerRequest::setOtherCountry()
     * @uses CreateCustomerRequest::setOtherCounty()
     * @uses CreateCustomerRequest::setLoginName()
     * @uses CreateCustomerRequest::setLoginPassword()
     * @uses CreateCustomerRequest::setTaxID()
     * @uses CreateCustomerRequest::setSalesTaxID()
     * @uses CreateCustomerRequest::setField1()
     * @uses CreateCustomerRequest::setField2()
     * @uses CreateCustomerRequest::setField3()
     * @uses CreateCustomerRequest::setField4()
     * @uses CreateCustomerRequest::setField5()
     * @uses CreateCustomerRequest::setField6()
     * @uses CreateCustomerRequest::setField7()
     * @uses CreateCustomerRequest::setField8()
     * @uses CreateCustomerRequest::setField9()
     * @uses CreateCustomerRequest::setField10()
     * @uses CreateCustomerRequest::setField11()
     * @uses CreateCustomerRequest::setField12()
     * @uses CreateCustomerRequest::setField13()
     * @uses CreateCustomerRequest::setField14()
     * @uses CreateCustomerRequest::setField15()
     * @uses CreateCustomerRequest::setSubscribeFromIPAddress()
     * @uses CreateCustomerRequest::setCurrencyCode()
     * @uses CreateCustomerRequest::setPayableToName()
     * @uses CreateCustomerRequest::setVatRegistration()
     * @uses CreateCustomerRequest::setMiddleName()
     * @uses CreateCustomerRequest::setNameSuffix()
     * @uses CreateCustomerRequest::setSponsorKey()
     * @uses CreateCustomerRequest::setEnrollerKey()
     * @uses CreateCustomerRequest::setManualCustomerKey()
     * @param int $customerType
     * @param int $customerStatus
     * @param bool $canLogin
     * @param bool $insertEnrollerTree
     * @param int $enrollerID
     * @param bool $insertUnilevelTree
     * @param int $sponsorID
     * @param bool $useManualCustomerID
     * @param int $manualCustomerID
     * @param string $salesTaxExemptExpireDate
     * @param bool $isSalesTaxExempt
     * @param string $birthDate
     * @param bool $subscribeToBroadcasts
     * @param string $entryDate
     * @param int $defaultWarehouseID
     * @param string $payableType
     * @param float $checkThreshold
     * @param string $taxIDType
     * @param int $languageID
     * @param string $gender
     * @param string $date1
     * @param string $date2
     * @param string $date3
     * @param string $date4
     * @param string $date5
     * @param int $binaryPlacementPreference
     * @param bool $useBinaryHoldingTank
     * @param bool $mainAddressVerified
     * @param bool $mailAddressVerified
     * @param bool $otherAddressVerified
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $email
     * @param string $phone
     * @param string $phone2
     * @param string $mobilePhone
     * @param string $fax
     * @param string $notes
     * @param string $mainAddress1
     * @param string $mainAddress2
     * @param string $mainAddress3
     * @param string $mainCity
     * @param string $mainState
     * @param string $mainZip
     * @param string $mainCountry
     * @param string $mainCounty
     * @param string $mailAddress1
     * @param string $mailAddress2
     * @param string $mailAddress3
     * @param string $mailCity
     * @param string $mailState
     * @param string $mailZip
     * @param string $mailCountry
     * @param string $mailCounty
     * @param string $otherAddress1
     * @param string $otherAddress2
     * @param string $otherAddress3
     * @param string $otherCity
     * @param string $otherState
     * @param string $otherZip
     * @param string $otherCountry
     * @param string $otherCounty
     * @param string $loginName
     * @param string $loginPassword
     * @param string $taxID
     * @param string $salesTaxID
     * @param string $field1
     * @param string $field2
     * @param string $field3
     * @param string $field4
     * @param string $field5
     * @param string $field6
     * @param string $field7
     * @param string $field8
     * @param string $field9
     * @param string $field10
     * @param string $field11
     * @param string $field12
     * @param string $field13
     * @param string $field14
     * @param string $field15
     * @param string $subscribeFromIPAddress
     * @param string $currencyCode
     * @param string $payableToName
     * @param string $vatRegistration
     * @param string $middleName
     * @param string $nameSuffix
     * @param string $sponsorKey
     * @param string $enrollerKey
     * @param string $manualCustomerKey
     */
    public function __construct($customerType = null, $customerStatus = null, $canLogin = null, $insertEnrollerTree = null, $enrollerID = null, $insertUnilevelTree = null, $sponsorID = null, $useManualCustomerID = null, $manualCustomerID = null, $salesTaxExemptExpireDate = null, $isSalesTaxExempt = null, $birthDate = null, $subscribeToBroadcasts = null, $entryDate = null, $defaultWarehouseID = null, $payableType = null, $checkThreshold = null, $taxIDType = null, $languageID = null, $gender = null, $date1 = null, $date2 = null, $date3 = null, $date4 = null, $date5 = null, $binaryPlacementPreference = null, $useBinaryHoldingTank = null, $mainAddressVerified = null, $mailAddressVerified = null, $otherAddressVerified = null, $firstName = null, $lastName = null, $company = null, $email = null, $phone = null, $phone2 = null, $mobilePhone = null, $fax = null, $notes = null, $mainAddress1 = null, $mainAddress2 = null, $mainAddress3 = null, $mainCity = null, $mainState = null, $mainZip = null, $mainCountry = null, $mainCounty = null, $mailAddress1 = null, $mailAddress2 = null, $mailAddress3 = null, $mailCity = null, $mailState = null, $mailZip = null, $mailCountry = null, $mailCounty = null, $otherAddress1 = null, $otherAddress2 = null, $otherAddress3 = null, $otherCity = null, $otherState = null, $otherZip = null, $otherCountry = null, $otherCounty = null, $loginName = null, $loginPassword = null, $taxID = null, $salesTaxID = null, $field1 = null, $field2 = null, $field3 = null, $field4 = null, $field5 = null, $field6 = null, $field7 = null, $field8 = null, $field9 = null, $field10 = null, $field11 = null, $field12 = null, $field13 = null, $field14 = null, $field15 = null, $subscribeFromIPAddress = null, $currencyCode = null, $payableToName = null, $vatRegistration = null, $middleName = null, $nameSuffix = null, $sponsorKey = null, $enrollerKey = null, $manualCustomerKey = null)
    {
        $this
            ->setCustomerType($customerType)
            ->setCustomerStatus($customerStatus)
            ->setCanLogin($canLogin)
            ->setInsertEnrollerTree($insertEnrollerTree)
            ->setEnrollerID($enrollerID)
            ->setInsertUnilevelTree($insertUnilevelTree)
            ->setSponsorID($sponsorID)
            ->setUseManualCustomerID($useManualCustomerID)
            ->setManualCustomerID($manualCustomerID)
            ->setSalesTaxExemptExpireDate($salesTaxExemptExpireDate)
            ->setIsSalesTaxExempt($isSalesTaxExempt)
            ->setBirthDate($birthDate)
            ->setSubscribeToBroadcasts($subscribeToBroadcasts)
            ->setEntryDate($entryDate)
            ->setDefaultWarehouseID($defaultWarehouseID)
            ->setPayableType($payableType)
            ->setCheckThreshold($checkThreshold)
            ->setTaxIDType($taxIDType)
            ->setLanguageID($languageID)
            ->setGender($gender)
            ->setDate1($date1)
            ->setDate2($date2)
            ->setDate3($date3)
            ->setDate4($date4)
            ->setDate5($date5)
            ->setBinaryPlacementPreference($binaryPlacementPreference)
            ->setUseBinaryHoldingTank($useBinaryHoldingTank)
            ->setMainAddressVerified($mainAddressVerified)
            ->setMailAddressVerified($mailAddressVerified)
            ->setOtherAddressVerified($otherAddressVerified)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setEmail($email)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setMobilePhone($mobilePhone)
            ->setFax($fax)
            ->setNotes($notes)
            ->setMainAddress1($mainAddress1)
            ->setMainAddress2($mainAddress2)
            ->setMainAddress3($mainAddress3)
            ->setMainCity($mainCity)
            ->setMainState($mainState)
            ->setMainZip($mainZip)
            ->setMainCountry($mainCountry)
            ->setMainCounty($mainCounty)
            ->setMailAddress1($mailAddress1)
            ->setMailAddress2($mailAddress2)
            ->setMailAddress3($mailAddress3)
            ->setMailCity($mailCity)
            ->setMailState($mailState)
            ->setMailZip($mailZip)
            ->setMailCountry($mailCountry)
            ->setMailCounty($mailCounty)
            ->setOtherAddress1($otherAddress1)
            ->setOtherAddress2($otherAddress2)
            ->setOtherAddress3($otherAddress3)
            ->setOtherCity($otherCity)
            ->setOtherState($otherState)
            ->setOtherZip($otherZip)
            ->setOtherCountry($otherCountry)
            ->setOtherCounty($otherCounty)
            ->setLoginName($loginName)
            ->setLoginPassword($loginPassword)
            ->setTaxID($taxID)
            ->setSalesTaxID($salesTaxID)
            ->setField1($field1)
            ->setField2($field2)
            ->setField3($field3)
            ->setField4($field4)
            ->setField5($field5)
            ->setField6($field6)
            ->setField7($field7)
            ->setField8($field8)
            ->setField9($field9)
            ->setField10($field10)
            ->setField11($field11)
            ->setField12($field12)
            ->setField13($field13)
            ->setField14($field14)
            ->setField15($field15)
            ->setSubscribeFromIPAddress($subscribeFromIPAddress)
            ->setCurrencyCode($currencyCode)
            ->setPayableToName($payableToName)
            ->setVatRegistration($vatRegistration)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setSponsorKey($sponsorKey)
            ->setEnrollerKey($enrollerKey)
            ->setManualCustomerKey($manualCustomerKey);
    }
    /**
     * Get CustomerType value
     * @return int
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param int $customerType
     * @return \StructType\CreateCustomerRequest
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: int
        if (!is_null($customerType) && !is_numeric($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get CustomerStatus value
     * @return int
     */
    public function getCustomerStatus()
    {
        return $this->CustomerStatus;
    }
    /**
     * Set CustomerStatus value
     * @param int $customerStatus
     * @return \StructType\CreateCustomerRequest
     */
    public function setCustomerStatus($customerStatus = null)
    {
        // validation for constraint: int
        if (!is_null($customerStatus) && !is_numeric($customerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerStatus)), __LINE__);
        }
        $this->CustomerStatus = $customerStatus;
        return $this;
    }
    /**
     * Get CanLogin value
     * @return bool
     */
    public function getCanLogin()
    {
        return $this->CanLogin;
    }
    /**
     * Set CanLogin value
     * @param bool $canLogin
     * @return \StructType\CreateCustomerRequest
     */
    public function setCanLogin($canLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($canLogin) && !is_bool($canLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canLogin)), __LINE__);
        }
        $this->CanLogin = $canLogin;
        return $this;
    }
    /**
     * Get InsertEnrollerTree value
     * @return bool
     */
    public function getInsertEnrollerTree()
    {
        return $this->InsertEnrollerTree;
    }
    /**
     * Set InsertEnrollerTree value
     * @param bool $insertEnrollerTree
     * @return \StructType\CreateCustomerRequest
     */
    public function setInsertEnrollerTree($insertEnrollerTree = null)
    {
        // validation for constraint: boolean
        if (!is_null($insertEnrollerTree) && !is_bool($insertEnrollerTree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($insertEnrollerTree)), __LINE__);
        }
        $this->InsertEnrollerTree = $insertEnrollerTree;
        return $this;
    }
    /**
     * Get EnrollerID value
     * @return int
     */
    public function getEnrollerID()
    {
        return $this->EnrollerID;
    }
    /**
     * Set EnrollerID value
     * @param int $enrollerID
     * @return \StructType\CreateCustomerRequest
     */
    public function setEnrollerID($enrollerID = null)
    {
        // validation for constraint: int
        if (!is_null($enrollerID) && !is_numeric($enrollerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($enrollerID)), __LINE__);
        }
        $this->EnrollerID = $enrollerID;
        return $this;
    }
    /**
     * Get InsertUnilevelTree value
     * @return bool
     */
    public function getInsertUnilevelTree()
    {
        return $this->InsertUnilevelTree;
    }
    /**
     * Set InsertUnilevelTree value
     * @param bool $insertUnilevelTree
     * @return \StructType\CreateCustomerRequest
     */
    public function setInsertUnilevelTree($insertUnilevelTree = null)
    {
        // validation for constraint: boolean
        if (!is_null($insertUnilevelTree) && !is_bool($insertUnilevelTree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($insertUnilevelTree)), __LINE__);
        }
        $this->InsertUnilevelTree = $insertUnilevelTree;
        return $this;
    }
    /**
     * Get SponsorID value
     * @return int
     */
    public function getSponsorID()
    {
        return $this->SponsorID;
    }
    /**
     * Set SponsorID value
     * @param int $sponsorID
     * @return \StructType\CreateCustomerRequest
     */
    public function setSponsorID($sponsorID = null)
    {
        // validation for constraint: int
        if (!is_null($sponsorID) && !is_numeric($sponsorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sponsorID)), __LINE__);
        }
        $this->SponsorID = $sponsorID;
        return $this;
    }
    /**
     * Get UseManualCustomerID value
     * @return bool
     */
    public function getUseManualCustomerID()
    {
        return $this->UseManualCustomerID;
    }
    /**
     * Set UseManualCustomerID value
     * @param bool $useManualCustomerID
     * @return \StructType\CreateCustomerRequest
     */
    public function setUseManualCustomerID($useManualCustomerID = null)
    {
        // validation for constraint: boolean
        if (!is_null($useManualCustomerID) && !is_bool($useManualCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useManualCustomerID)), __LINE__);
        }
        $this->UseManualCustomerID = $useManualCustomerID;
        return $this;
    }
    /**
     * Get ManualCustomerID value
     * @return int
     */
    public function getManualCustomerID()
    {
        return $this->ManualCustomerID;
    }
    /**
     * Set ManualCustomerID value
     * @param int $manualCustomerID
     * @return \StructType\CreateCustomerRequest
     */
    public function setManualCustomerID($manualCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($manualCustomerID) && !is_numeric($manualCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manualCustomerID)), __LINE__);
        }
        $this->ManualCustomerID = $manualCustomerID;
        return $this;
    }
    /**
     * Get SalesTaxExemptExpireDate value
     * @return string
     */
    public function getSalesTaxExemptExpireDate()
    {
        return $this->SalesTaxExemptExpireDate;
    }
    /**
     * Set SalesTaxExemptExpireDate value
     * @param string $salesTaxExemptExpireDate
     * @return \StructType\CreateCustomerRequest
     */
    public function setSalesTaxExemptExpireDate($salesTaxExemptExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesTaxExemptExpireDate) && !is_string($salesTaxExemptExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesTaxExemptExpireDate)), __LINE__);
        }
        $this->SalesTaxExemptExpireDate = $salesTaxExemptExpireDate;
        return $this;
    }
    /**
     * Get IsSalesTaxExempt value
     * @return bool
     */
    public function getIsSalesTaxExempt()
    {
        return $this->IsSalesTaxExempt;
    }
    /**
     * Set IsSalesTaxExempt value
     * @param bool $isSalesTaxExempt
     * @return \StructType\CreateCustomerRequest
     */
    public function setIsSalesTaxExempt($isSalesTaxExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesTaxExempt) && !is_bool($isSalesTaxExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSalesTaxExempt)), __LINE__);
        }
        $this->IsSalesTaxExempt = $isSalesTaxExempt;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CreateCustomerRequest
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get SubscribeToBroadcasts value
     * @return bool
     */
    public function getSubscribeToBroadcasts()
    {
        return $this->SubscribeToBroadcasts;
    }
    /**
     * Set SubscribeToBroadcasts value
     * @param bool $subscribeToBroadcasts
     * @return \StructType\CreateCustomerRequest
     */
    public function setSubscribeToBroadcasts($subscribeToBroadcasts = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscribeToBroadcasts) && !is_bool($subscribeToBroadcasts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subscribeToBroadcasts)), __LINE__);
        }
        $this->SubscribeToBroadcasts = $subscribeToBroadcasts;
        return $this;
    }
    /**
     * Get EntryDate value
     * @return string
     */
    public function getEntryDate()
    {
        return $this->EntryDate;
    }
    /**
     * Set EntryDate value
     * @param string $entryDate
     * @return \StructType\CreateCustomerRequest
     */
    public function setEntryDate($entryDate = null)
    {
        // validation for constraint: string
        if (!is_null($entryDate) && !is_string($entryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entryDate)), __LINE__);
        }
        $this->EntryDate = $entryDate;
        return $this;
    }
    /**
     * Get DefaultWarehouseID value
     * @return int
     */
    public function getDefaultWarehouseID()
    {
        return $this->DefaultWarehouseID;
    }
    /**
     * Set DefaultWarehouseID value
     * @param int $defaultWarehouseID
     * @return \StructType\CreateCustomerRequest
     */
    public function setDefaultWarehouseID($defaultWarehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($defaultWarehouseID) && !is_numeric($defaultWarehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultWarehouseID)), __LINE__);
        }
        $this->DefaultWarehouseID = $defaultWarehouseID;
        return $this;
    }
    /**
     * Get PayableType value
     * @return string
     */
    public function getPayableType()
    {
        return $this->PayableType;
    }
    /**
     * Set PayableType value
     * @uses \EnumType\PayableType::valueIsValid()
     * @uses \EnumType\PayableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payableType
     * @return \StructType\CreateCustomerRequest
     */
    public function setPayableType($payableType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PayableType::valueIsValid($payableType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $payableType, implode(', ', \EnumType\PayableType::getValidValues())), __LINE__);
        }
        $this->PayableType = $payableType;
        return $this;
    }
    /**
     * Get CheckThreshold value
     * @return float
     */
    public function getCheckThreshold()
    {
        return $this->CheckThreshold;
    }
    /**
     * Set CheckThreshold value
     * @param float $checkThreshold
     * @return \StructType\CreateCustomerRequest
     */
    public function setCheckThreshold($checkThreshold = null)
    {
        $this->CheckThreshold = $checkThreshold;
        return $this;
    }
    /**
     * Get TaxIDType value
     * @return string
     */
    public function getTaxIDType()
    {
        return $this->TaxIDType;
    }
    /**
     * Set TaxIDType value
     * @uses \EnumType\TaxIDType::valueIsValid()
     * @uses \EnumType\TaxIDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxIDType
     * @return \StructType\CreateCustomerRequest
     */
    public function setTaxIDType($taxIDType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxIDType::valueIsValid($taxIDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $taxIDType, implode(', ', \EnumType\TaxIDType::getValidValues())), __LINE__);
        }
        $this->TaxIDType = $taxIDType;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\CreateCustomerRequest
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Gender::valueIsValid()
     * @uses \EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\CreateCustomerRequest
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Date1 value
     * @return string
     */
    public function getDate1()
    {
        return $this->Date1;
    }
    /**
     * Set Date1 value
     * @param string $date1
     * @return \StructType\CreateCustomerRequest
     */
    public function setDate1($date1 = null)
    {
        // validation for constraint: string
        if (!is_null($date1) && !is_string($date1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date1)), __LINE__);
        }
        $this->Date1 = $date1;
        return $this;
    }
    /**
     * Get Date2 value
     * @return string
     */
    public function getDate2()
    {
        return $this->Date2;
    }
    /**
     * Set Date2 value
     * @param string $date2
     * @return \StructType\CreateCustomerRequest
     */
    public function setDate2($date2 = null)
    {
        // validation for constraint: string
        if (!is_null($date2) && !is_string($date2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date2)), __LINE__);
        }
        $this->Date2 = $date2;
        return $this;
    }
    /**
     * Get Date3 value
     * @return string
     */
    public function getDate3()
    {
        return $this->Date3;
    }
    /**
     * Set Date3 value
     * @param string $date3
     * @return \StructType\CreateCustomerRequest
     */
    public function setDate3($date3 = null)
    {
        // validation for constraint: string
        if (!is_null($date3) && !is_string($date3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date3)), __LINE__);
        }
        $this->Date3 = $date3;
        return $this;
    }
    /**
     * Get Date4 value
     * @return string
     */
    public function getDate4()
    {
        return $this->Date4;
    }
    /**
     * Set Date4 value
     * @param string $date4
     * @return \StructType\CreateCustomerRequest
     */
    public function setDate4($date4 = null)
    {
        // validation for constraint: string
        if (!is_null($date4) && !is_string($date4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date4)), __LINE__);
        }
        $this->Date4 = $date4;
        return $this;
    }
    /**
     * Get Date5 value
     * @return string
     */
    public function getDate5()
    {
        return $this->Date5;
    }
    /**
     * Set Date5 value
     * @param string $date5
     * @return \StructType\CreateCustomerRequest
     */
    public function setDate5($date5 = null)
    {
        // validation for constraint: string
        if (!is_null($date5) && !is_string($date5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date5)), __LINE__);
        }
        $this->Date5 = $date5;
        return $this;
    }
    /**
     * Get BinaryPlacementPreference value
     * @return int
     */
    public function getBinaryPlacementPreference()
    {
        return $this->BinaryPlacementPreference;
    }
    /**
     * Set BinaryPlacementPreference value
     * @param int $binaryPlacementPreference
     * @return \StructType\CreateCustomerRequest
     */
    public function setBinaryPlacementPreference($binaryPlacementPreference = null)
    {
        // validation for constraint: int
        if (!is_null($binaryPlacementPreference) && !is_numeric($binaryPlacementPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($binaryPlacementPreference)), __LINE__);
        }
        $this->BinaryPlacementPreference = $binaryPlacementPreference;
        return $this;
    }
    /**
     * Get UseBinaryHoldingTank value
     * @return bool
     */
    public function getUseBinaryHoldingTank()
    {
        return $this->UseBinaryHoldingTank;
    }
    /**
     * Set UseBinaryHoldingTank value
     * @param bool $useBinaryHoldingTank
     * @return \StructType\CreateCustomerRequest
     */
    public function setUseBinaryHoldingTank($useBinaryHoldingTank = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBinaryHoldingTank) && !is_bool($useBinaryHoldingTank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useBinaryHoldingTank)), __LINE__);
        }
        $this->UseBinaryHoldingTank = $useBinaryHoldingTank;
        return $this;
    }
    /**
     * Get MainAddressVerified value
     * @return bool
     */
    public function getMainAddressVerified()
    {
        return $this->MainAddressVerified;
    }
    /**
     * Set MainAddressVerified value
     * @param bool $mainAddressVerified
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainAddressVerified($mainAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($mainAddressVerified) && !is_bool($mainAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mainAddressVerified)), __LINE__);
        }
        $this->MainAddressVerified = $mainAddressVerified;
        return $this;
    }
    /**
     * Get MailAddressVerified value
     * @return bool
     */
    public function getMailAddressVerified()
    {
        return $this->MailAddressVerified;
    }
    /**
     * Set MailAddressVerified value
     * @param bool $mailAddressVerified
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailAddressVerified($mailAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailAddressVerified) && !is_bool($mailAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailAddressVerified)), __LINE__);
        }
        $this->MailAddressVerified = $mailAddressVerified;
        return $this;
    }
    /**
     * Get OtherAddressVerified value
     * @return bool
     */
    public function getOtherAddressVerified()
    {
        return $this->OtherAddressVerified;
    }
    /**
     * Set OtherAddressVerified value
     * @param bool $otherAddressVerified
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherAddressVerified($otherAddressVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($otherAddressVerified) && !is_bool($otherAddressVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($otherAddressVerified)), __LINE__);
        }
        $this->OtherAddressVerified = $otherAddressVerified;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CreateCustomerRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CreateCustomerRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\CreateCustomerRequest
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CreateCustomerRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\CreateCustomerRequest
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->Phone2;
    }
    /**
     * Set Phone2 value
     * @param string $phone2
     * @return \StructType\CreateCustomerRequest
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->Phone2 = $phone2;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\CreateCustomerRequest
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\CreateCustomerRequest
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\CreateCustomerRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get MainAddress1 value
     * @return string|null
     */
    public function getMainAddress1()
    {
        return $this->MainAddress1;
    }
    /**
     * Set MainAddress1 value
     * @param string $mainAddress1
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainAddress1($mainAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress1) && !is_string($mainAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress1)), __LINE__);
        }
        $this->MainAddress1 = $mainAddress1;
        return $this;
    }
    /**
     * Get MainAddress2 value
     * @return string|null
     */
    public function getMainAddress2()
    {
        return $this->MainAddress2;
    }
    /**
     * Set MainAddress2 value
     * @param string $mainAddress2
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainAddress2($mainAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress2) && !is_string($mainAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress2)), __LINE__);
        }
        $this->MainAddress2 = $mainAddress2;
        return $this;
    }
    /**
     * Get MainAddress3 value
     * @return string|null
     */
    public function getMainAddress3()
    {
        return $this->MainAddress3;
    }
    /**
     * Set MainAddress3 value
     * @param string $mainAddress3
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainAddress3($mainAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($mainAddress3) && !is_string($mainAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainAddress3)), __LINE__);
        }
        $this->MainAddress3 = $mainAddress3;
        return $this;
    }
    /**
     * Get MainCity value
     * @return string|null
     */
    public function getMainCity()
    {
        return $this->MainCity;
    }
    /**
     * Set MainCity value
     * @param string $mainCity
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainCity($mainCity = null)
    {
        // validation for constraint: string
        if (!is_null($mainCity) && !is_string($mainCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCity)), __LINE__);
        }
        $this->MainCity = $mainCity;
        return $this;
    }
    /**
     * Get MainState value
     * @return string|null
     */
    public function getMainState()
    {
        return $this->MainState;
    }
    /**
     * Set MainState value
     * @param string $mainState
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainState($mainState = null)
    {
        // validation for constraint: string
        if (!is_null($mainState) && !is_string($mainState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainState)), __LINE__);
        }
        $this->MainState = $mainState;
        return $this;
    }
    /**
     * Get MainZip value
     * @return string|null
     */
    public function getMainZip()
    {
        return $this->MainZip;
    }
    /**
     * Set MainZip value
     * @param string $mainZip
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainZip($mainZip = null)
    {
        // validation for constraint: string
        if (!is_null($mainZip) && !is_string($mainZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainZip)), __LINE__);
        }
        $this->MainZip = $mainZip;
        return $this;
    }
    /**
     * Get MainCountry value
     * @return string|null
     */
    public function getMainCountry()
    {
        return $this->MainCountry;
    }
    /**
     * Set MainCountry value
     * @param string $mainCountry
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainCountry($mainCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mainCountry) && !is_string($mainCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCountry)), __LINE__);
        }
        $this->MainCountry = $mainCountry;
        return $this;
    }
    /**
     * Get MainCounty value
     * @return string|null
     */
    public function getMainCounty()
    {
        return $this->MainCounty;
    }
    /**
     * Set MainCounty value
     * @param string $mainCounty
     * @return \StructType\CreateCustomerRequest
     */
    public function setMainCounty($mainCounty = null)
    {
        // validation for constraint: string
        if (!is_null($mainCounty) && !is_string($mainCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainCounty)), __LINE__);
        }
        $this->MainCounty = $mainCounty;
        return $this;
    }
    /**
     * Get MailAddress1 value
     * @return string|null
     */
    public function getMailAddress1()
    {
        return $this->MailAddress1;
    }
    /**
     * Set MailAddress1 value
     * @param string $mailAddress1
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailAddress1($mailAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress1) && !is_string($mailAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress1)), __LINE__);
        }
        $this->MailAddress1 = $mailAddress1;
        return $this;
    }
    /**
     * Get MailAddress2 value
     * @return string|null
     */
    public function getMailAddress2()
    {
        return $this->MailAddress2;
    }
    /**
     * Set MailAddress2 value
     * @param string $mailAddress2
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailAddress2($mailAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress2) && !is_string($mailAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress2)), __LINE__);
        }
        $this->MailAddress2 = $mailAddress2;
        return $this;
    }
    /**
     * Get MailAddress3 value
     * @return string|null
     */
    public function getMailAddress3()
    {
        return $this->MailAddress3;
    }
    /**
     * Set MailAddress3 value
     * @param string $mailAddress3
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailAddress3($mailAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress3) && !is_string($mailAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailAddress3)), __LINE__);
        }
        $this->MailAddress3 = $mailAddress3;
        return $this;
    }
    /**
     * Get MailCity value
     * @return string|null
     */
    public function getMailCity()
    {
        return $this->MailCity;
    }
    /**
     * Set MailCity value
     * @param string $mailCity
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailCity($mailCity = null)
    {
        // validation for constraint: string
        if (!is_null($mailCity) && !is_string($mailCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCity)), __LINE__);
        }
        $this->MailCity = $mailCity;
        return $this;
    }
    /**
     * Get MailState value
     * @return string|null
     */
    public function getMailState()
    {
        return $this->MailState;
    }
    /**
     * Set MailState value
     * @param string $mailState
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailState($mailState = null)
    {
        // validation for constraint: string
        if (!is_null($mailState) && !is_string($mailState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailState)), __LINE__);
        }
        $this->MailState = $mailState;
        return $this;
    }
    /**
     * Get MailZip value
     * @return string|null
     */
    public function getMailZip()
    {
        return $this->MailZip;
    }
    /**
     * Set MailZip value
     * @param string $mailZip
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailZip($mailZip = null)
    {
        // validation for constraint: string
        if (!is_null($mailZip) && !is_string($mailZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailZip)), __LINE__);
        }
        $this->MailZip = $mailZip;
        return $this;
    }
    /**
     * Get MailCountry value
     * @return string|null
     */
    public function getMailCountry()
    {
        return $this->MailCountry;
    }
    /**
     * Set MailCountry value
     * @param string $mailCountry
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailCountry($mailCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mailCountry) && !is_string($mailCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCountry)), __LINE__);
        }
        $this->MailCountry = $mailCountry;
        return $this;
    }
    /**
     * Get MailCounty value
     * @return string|null
     */
    public function getMailCounty()
    {
        return $this->MailCounty;
    }
    /**
     * Set MailCounty value
     * @param string $mailCounty
     * @return \StructType\CreateCustomerRequest
     */
    public function setMailCounty($mailCounty = null)
    {
        // validation for constraint: string
        if (!is_null($mailCounty) && !is_string($mailCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailCounty)), __LINE__);
        }
        $this->MailCounty = $mailCounty;
        return $this;
    }
    /**
     * Get OtherAddress1 value
     * @return string|null
     */
    public function getOtherAddress1()
    {
        return $this->OtherAddress1;
    }
    /**
     * Set OtherAddress1 value
     * @param string $otherAddress1
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherAddress1($otherAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress1) && !is_string($otherAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress1)), __LINE__);
        }
        $this->OtherAddress1 = $otherAddress1;
        return $this;
    }
    /**
     * Get OtherAddress2 value
     * @return string|null
     */
    public function getOtherAddress2()
    {
        return $this->OtherAddress2;
    }
    /**
     * Set OtherAddress2 value
     * @param string $otherAddress2
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherAddress2($otherAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress2) && !is_string($otherAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress2)), __LINE__);
        }
        $this->OtherAddress2 = $otherAddress2;
        return $this;
    }
    /**
     * Get OtherAddress3 value
     * @return string|null
     */
    public function getOtherAddress3()
    {
        return $this->OtherAddress3;
    }
    /**
     * Set OtherAddress3 value
     * @param string $otherAddress3
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherAddress3($otherAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddress3) && !is_string($otherAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAddress3)), __LINE__);
        }
        $this->OtherAddress3 = $otherAddress3;
        return $this;
    }
    /**
     * Get OtherCity value
     * @return string|null
     */
    public function getOtherCity()
    {
        return $this->OtherCity;
    }
    /**
     * Set OtherCity value
     * @param string $otherCity
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherCity($otherCity = null)
    {
        // validation for constraint: string
        if (!is_null($otherCity) && !is_string($otherCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCity)), __LINE__);
        }
        $this->OtherCity = $otherCity;
        return $this;
    }
    /**
     * Get OtherState value
     * @return string|null
     */
    public function getOtherState()
    {
        return $this->OtherState;
    }
    /**
     * Set OtherState value
     * @param string $otherState
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherState($otherState = null)
    {
        // validation for constraint: string
        if (!is_null($otherState) && !is_string($otherState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherState)), __LINE__);
        }
        $this->OtherState = $otherState;
        return $this;
    }
    /**
     * Get OtherZip value
     * @return string|null
     */
    public function getOtherZip()
    {
        return $this->OtherZip;
    }
    /**
     * Set OtherZip value
     * @param string $otherZip
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherZip($otherZip = null)
    {
        // validation for constraint: string
        if (!is_null($otherZip) && !is_string($otherZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherZip)), __LINE__);
        }
        $this->OtherZip = $otherZip;
        return $this;
    }
    /**
     * Get OtherCountry value
     * @return string|null
     */
    public function getOtherCountry()
    {
        return $this->OtherCountry;
    }
    /**
     * Set OtherCountry value
     * @param string $otherCountry
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherCountry($otherCountry = null)
    {
        // validation for constraint: string
        if (!is_null($otherCountry) && !is_string($otherCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCountry)), __LINE__);
        }
        $this->OtherCountry = $otherCountry;
        return $this;
    }
    /**
     * Get OtherCounty value
     * @return string|null
     */
    public function getOtherCounty()
    {
        return $this->OtherCounty;
    }
    /**
     * Set OtherCounty value
     * @param string $otherCounty
     * @return \StructType\CreateCustomerRequest
     */
    public function setOtherCounty($otherCounty = null)
    {
        // validation for constraint: string
        if (!is_null($otherCounty) && !is_string($otherCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherCounty)), __LINE__);
        }
        $this->OtherCounty = $otherCounty;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\CreateCustomerRequest
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get LoginPassword value
     * @return string|null
     */
    public function getLoginPassword()
    {
        return $this->LoginPassword;
    }
    /**
     * Set LoginPassword value
     * @param string $loginPassword
     * @return \StructType\CreateCustomerRequest
     */
    public function setLoginPassword($loginPassword = null)
    {
        // validation for constraint: string
        if (!is_null($loginPassword) && !is_string($loginPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginPassword)), __LINE__);
        }
        $this->LoginPassword = $loginPassword;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\CreateCustomerRequest
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get SalesTaxID value
     * @return string|null
     */
    public function getSalesTaxID()
    {
        return $this->SalesTaxID;
    }
    /**
     * Set SalesTaxID value
     * @param string $salesTaxID
     * @return \StructType\CreateCustomerRequest
     */
    public function setSalesTaxID($salesTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($salesTaxID) && !is_string($salesTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesTaxID)), __LINE__);
        }
        $this->SalesTaxID = $salesTaxID;
        return $this;
    }
    /**
     * Get Field1 value
     * @return string|null
     */
    public function getField1()
    {
        return $this->Field1;
    }
    /**
     * Set Field1 value
     * @param string $field1
     * @return \StructType\CreateCustomerRequest
     */
    public function setField1($field1 = null)
    {
        // validation for constraint: string
        if (!is_null($field1) && !is_string($field1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field1)), __LINE__);
        }
        $this->Field1 = $field1;
        return $this;
    }
    /**
     * Get Field2 value
     * @return string|null
     */
    public function getField2()
    {
        return $this->Field2;
    }
    /**
     * Set Field2 value
     * @param string $field2
     * @return \StructType\CreateCustomerRequest
     */
    public function setField2($field2 = null)
    {
        // validation for constraint: string
        if (!is_null($field2) && !is_string($field2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field2)), __LINE__);
        }
        $this->Field2 = $field2;
        return $this;
    }
    /**
     * Get Field3 value
     * @return string|null
     */
    public function getField3()
    {
        return $this->Field3;
    }
    /**
     * Set Field3 value
     * @param string $field3
     * @return \StructType\CreateCustomerRequest
     */
    public function setField3($field3 = null)
    {
        // validation for constraint: string
        if (!is_null($field3) && !is_string($field3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field3)), __LINE__);
        }
        $this->Field3 = $field3;
        return $this;
    }
    /**
     * Get Field4 value
     * @return string|null
     */
    public function getField4()
    {
        return $this->Field4;
    }
    /**
     * Set Field4 value
     * @param string $field4
     * @return \StructType\CreateCustomerRequest
     */
    public function setField4($field4 = null)
    {
        // validation for constraint: string
        if (!is_null($field4) && !is_string($field4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field4)), __LINE__);
        }
        $this->Field4 = $field4;
        return $this;
    }
    /**
     * Get Field5 value
     * @return string|null
     */
    public function getField5()
    {
        return $this->Field5;
    }
    /**
     * Set Field5 value
     * @param string $field5
     * @return \StructType\CreateCustomerRequest
     */
    public function setField5($field5 = null)
    {
        // validation for constraint: string
        if (!is_null($field5) && !is_string($field5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field5)), __LINE__);
        }
        $this->Field5 = $field5;
        return $this;
    }
    /**
     * Get Field6 value
     * @return string|null
     */
    public function getField6()
    {
        return $this->Field6;
    }
    /**
     * Set Field6 value
     * @param string $field6
     * @return \StructType\CreateCustomerRequest
     */
    public function setField6($field6 = null)
    {
        // validation for constraint: string
        if (!is_null($field6) && !is_string($field6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field6)), __LINE__);
        }
        $this->Field6 = $field6;
        return $this;
    }
    /**
     * Get Field7 value
     * @return string|null
     */
    public function getField7()
    {
        return $this->Field7;
    }
    /**
     * Set Field7 value
     * @param string $field7
     * @return \StructType\CreateCustomerRequest
     */
    public function setField7($field7 = null)
    {
        // validation for constraint: string
        if (!is_null($field7) && !is_string($field7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field7)), __LINE__);
        }
        $this->Field7 = $field7;
        return $this;
    }
    /**
     * Get Field8 value
     * @return string|null
     */
    public function getField8()
    {
        return $this->Field8;
    }
    /**
     * Set Field8 value
     * @param string $field8
     * @return \StructType\CreateCustomerRequest
     */
    public function setField8($field8 = null)
    {
        // validation for constraint: string
        if (!is_null($field8) && !is_string($field8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field8)), __LINE__);
        }
        $this->Field8 = $field8;
        return $this;
    }
    /**
     * Get Field9 value
     * @return string|null
     */
    public function getField9()
    {
        return $this->Field9;
    }
    /**
     * Set Field9 value
     * @param string $field9
     * @return \StructType\CreateCustomerRequest
     */
    public function setField9($field9 = null)
    {
        // validation for constraint: string
        if (!is_null($field9) && !is_string($field9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field9)), __LINE__);
        }
        $this->Field9 = $field9;
        return $this;
    }
    /**
     * Get Field10 value
     * @return string|null
     */
    public function getField10()
    {
        return $this->Field10;
    }
    /**
     * Set Field10 value
     * @param string $field10
     * @return \StructType\CreateCustomerRequest
     */
    public function setField10($field10 = null)
    {
        // validation for constraint: string
        if (!is_null($field10) && !is_string($field10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field10)), __LINE__);
        }
        $this->Field10 = $field10;
        return $this;
    }
    /**
     * Get Field11 value
     * @return string|null
     */
    public function getField11()
    {
        return $this->Field11;
    }
    /**
     * Set Field11 value
     * @param string $field11
     * @return \StructType\CreateCustomerRequest
     */
    public function setField11($field11 = null)
    {
        // validation for constraint: string
        if (!is_null($field11) && !is_string($field11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field11)), __LINE__);
        }
        $this->Field11 = $field11;
        return $this;
    }
    /**
     * Get Field12 value
     * @return string|null
     */
    public function getField12()
    {
        return $this->Field12;
    }
    /**
     * Set Field12 value
     * @param string $field12
     * @return \StructType\CreateCustomerRequest
     */
    public function setField12($field12 = null)
    {
        // validation for constraint: string
        if (!is_null($field12) && !is_string($field12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field12)), __LINE__);
        }
        $this->Field12 = $field12;
        return $this;
    }
    /**
     * Get Field13 value
     * @return string|null
     */
    public function getField13()
    {
        return $this->Field13;
    }
    /**
     * Set Field13 value
     * @param string $field13
     * @return \StructType\CreateCustomerRequest
     */
    public function setField13($field13 = null)
    {
        // validation for constraint: string
        if (!is_null($field13) && !is_string($field13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field13)), __LINE__);
        }
        $this->Field13 = $field13;
        return $this;
    }
    /**
     * Get Field14 value
     * @return string|null
     */
    public function getField14()
    {
        return $this->Field14;
    }
    /**
     * Set Field14 value
     * @param string $field14
     * @return \StructType\CreateCustomerRequest
     */
    public function setField14($field14 = null)
    {
        // validation for constraint: string
        if (!is_null($field14) && !is_string($field14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field14)), __LINE__);
        }
        $this->Field14 = $field14;
        return $this;
    }
    /**
     * Get Field15 value
     * @return string|null
     */
    public function getField15()
    {
        return $this->Field15;
    }
    /**
     * Set Field15 value
     * @param string $field15
     * @return \StructType\CreateCustomerRequest
     */
    public function setField15($field15 = null)
    {
        // validation for constraint: string
        if (!is_null($field15) && !is_string($field15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field15)), __LINE__);
        }
        $this->Field15 = $field15;
        return $this;
    }
    /**
     * Get SubscribeFromIPAddress value
     * @return string|null
     */
    public function getSubscribeFromIPAddress()
    {
        return $this->SubscribeFromIPAddress;
    }
    /**
     * Set SubscribeFromIPAddress value
     * @param string $subscribeFromIPAddress
     * @return \StructType\CreateCustomerRequest
     */
    public function setSubscribeFromIPAddress($subscribeFromIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subscribeFromIPAddress) && !is_string($subscribeFromIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscribeFromIPAddress)), __LINE__);
        }
        $this->SubscribeFromIPAddress = $subscribeFromIPAddress;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreateCustomerRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PayableToName value
     * @return string|null
     */
    public function getPayableToName()
    {
        return $this->PayableToName;
    }
    /**
     * Set PayableToName value
     * @param string $payableToName
     * @return \StructType\CreateCustomerRequest
     */
    public function setPayableToName($payableToName = null)
    {
        // validation for constraint: string
        if (!is_null($payableToName) && !is_string($payableToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payableToName)), __LINE__);
        }
        $this->PayableToName = $payableToName;
        return $this;
    }
    /**
     * Get VatRegistration value
     * @return string|null
     */
    public function getVatRegistration()
    {
        return $this->VatRegistration;
    }
    /**
     * Set VatRegistration value
     * @param string $vatRegistration
     * @return \StructType\CreateCustomerRequest
     */
    public function setVatRegistration($vatRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistration) && !is_string($vatRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatRegistration)), __LINE__);
        }
        $this->VatRegistration = $vatRegistration;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CreateCustomerRequest
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param string $nameSuffix
     * @return \StructType\CreateCustomerRequest
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSuffix)), __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get SponsorKey value
     * @return string|null
     */
    public function getSponsorKey()
    {
        return $this->SponsorKey;
    }
    /**
     * Set SponsorKey value
     * @param string $sponsorKey
     * @return \StructType\CreateCustomerRequest
     */
    public function setSponsorKey($sponsorKey = null)
    {
        // validation for constraint: string
        if (!is_null($sponsorKey) && !is_string($sponsorKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sponsorKey)), __LINE__);
        }
        $this->SponsorKey = $sponsorKey;
        return $this;
    }
    /**
     * Get EnrollerKey value
     * @return string|null
     */
    public function getEnrollerKey()
    {
        return $this->EnrollerKey;
    }
    /**
     * Set EnrollerKey value
     * @param string $enrollerKey
     * @return \StructType\CreateCustomerRequest
     */
    public function setEnrollerKey($enrollerKey = null)
    {
        // validation for constraint: string
        if (!is_null($enrollerKey) && !is_string($enrollerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollerKey)), __LINE__);
        }
        $this->EnrollerKey = $enrollerKey;
        return $this;
    }
    /**
     * Get ManualCustomerKey value
     * @return string|null
     */
    public function getManualCustomerKey()
    {
        return $this->ManualCustomerKey;
    }
    /**
     * Set ManualCustomerKey value
     * @param string $manualCustomerKey
     * @return \StructType\CreateCustomerRequest
     */
    public function setManualCustomerKey($manualCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($manualCustomerKey) && !is_string($manualCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manualCustomerKey)), __LINE__);
        }
        $this->ManualCustomerKey = $manualCustomerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
