<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerFileRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateCustomerFileRequest
 * @subpackage Structs
 */
class CreateCustomerFileRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The OverwriteExistingFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OverwriteExistingFile;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The FileData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileData;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateCustomerFileRequest
     * @uses CreateCustomerFileRequest::setCustomerID()
     * @uses CreateCustomerFileRequest::setOverwriteExistingFile()
     * @uses CreateCustomerFileRequest::setFileName()
     * @uses CreateCustomerFileRequest::setFileData()
     * @uses CreateCustomerFileRequest::setCustomerKey()
     * @param int $customerID
     * @param bool $overwriteExistingFile
     * @param string $fileName
     * @param string $fileData
     * @param string $customerKey
     */
    public function __construct($customerID = null, $overwriteExistingFile = null, $fileName = null, $fileData = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setOverwriteExistingFile($overwriteExistingFile)
            ->setFileName($fileName)
            ->setFileData($fileData)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateCustomerFileRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OverwriteExistingFile value
     * @return bool
     */
    public function getOverwriteExistingFile()
    {
        return $this->OverwriteExistingFile;
    }
    /**
     * Set OverwriteExistingFile value
     * @param bool $overwriteExistingFile
     * @return \StructType\CreateCustomerFileRequest
     */
    public function setOverwriteExistingFile($overwriteExistingFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($overwriteExistingFile) && !is_bool($overwriteExistingFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overwriteExistingFile)), __LINE__);
        }
        $this->OverwriteExistingFile = $overwriteExistingFile;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\CreateCustomerFileRequest
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->FileData;
    }
    /**
     * Set FileData value
     * @param string $fileData
     * @return \StructType\CreateCustomerFileRequest
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileData)), __LINE__);
        }
        $this->FileData = $fileData;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateCustomerFileRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
