<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBillRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreateBillRequest
 * @subpackage Structs
 */
class CreateBillRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The IsOtherIncome
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOtherIncome;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The BillStatusTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BillStatusTypeID;
    /**
     * The PayableTypeIDOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PayableTypeIDOverride;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateBillRequest
     * @uses CreateBillRequest::setCustomerID()
     * @uses CreateBillRequest::setIsOtherIncome()
     * @uses CreateBillRequest::setDueDate()
     * @uses CreateBillRequest::setAmount()
     * @uses CreateBillRequest::setBillStatusTypeID()
     * @uses CreateBillRequest::setPayableTypeIDOverride()
     * @uses CreateBillRequest::setCurrencyCode()
     * @uses CreateBillRequest::setReference()
     * @uses CreateBillRequest::setNotes()
     * @uses CreateBillRequest::setCustomerKey()
     * @param int $customerID
     * @param bool $isOtherIncome
     * @param string $dueDate
     * @param float $amount
     * @param int $billStatusTypeID
     * @param int $payableTypeIDOverride
     * @param string $currencyCode
     * @param string $reference
     * @param string $notes
     * @param string $customerKey
     */
    public function __construct($customerID = null, $isOtherIncome = null, $dueDate = null, $amount = null, $billStatusTypeID = null, $payableTypeIDOverride = null, $currencyCode = null, $reference = null, $notes = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setIsOtherIncome($isOtherIncome)
            ->setDueDate($dueDate)
            ->setAmount($amount)
            ->setBillStatusTypeID($billStatusTypeID)
            ->setPayableTypeIDOverride($payableTypeIDOverride)
            ->setCurrencyCode($currencyCode)
            ->setReference($reference)
            ->setNotes($notes)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateBillRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get IsOtherIncome value
     * @return bool
     */
    public function getIsOtherIncome()
    {
        return $this->IsOtherIncome;
    }
    /**
     * Set IsOtherIncome value
     * @param bool $isOtherIncome
     * @return \StructType\CreateBillRequest
     */
    public function setIsOtherIncome($isOtherIncome = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOtherIncome) && !is_bool($isOtherIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOtherIncome)), __LINE__);
        }
        $this->IsOtherIncome = $isOtherIncome;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \StructType\CreateBillRequest
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreateBillRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BillStatusTypeID value
     * @return int
     */
    public function getBillStatusTypeID()
    {
        return $this->BillStatusTypeID;
    }
    /**
     * Set BillStatusTypeID value
     * @param int $billStatusTypeID
     * @return \StructType\CreateBillRequest
     */
    public function setBillStatusTypeID($billStatusTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusTypeID) && !is_numeric($billStatusTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusTypeID)), __LINE__);
        }
        $this->BillStatusTypeID = $billStatusTypeID;
        return $this;
    }
    /**
     * Get PayableTypeIDOverride value
     * @return int
     */
    public function getPayableTypeIDOverride()
    {
        return $this->PayableTypeIDOverride;
    }
    /**
     * Set PayableTypeIDOverride value
     * @param int $payableTypeIDOverride
     * @return \StructType\CreateBillRequest
     */
    public function setPayableTypeIDOverride($payableTypeIDOverride = null)
    {
        // validation for constraint: int
        if (!is_null($payableTypeIDOverride) && !is_numeric($payableTypeIDOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payableTypeIDOverride)), __LINE__);
        }
        $this->PayableTypeIDOverride = $payableTypeIDOverride;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreateBillRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\CreateBillRequest
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\CreateBillRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateBillRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateBillRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
