<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNewsResponse StructType
 * @subpackage Structs
 */
class CompanyNewsResponse extends AbstractStructBase
{
    /**
     * The NewsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NewsID;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedDate;
    /**
     * The WebSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WebSettings;
    /**
     * The CompanySettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CompanySettings;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for CompanyNewsResponse
     * @uses CompanyNewsResponse::setNewsID()
     * @uses CompanyNewsResponse::setCreatedDate()
     * @uses CompanyNewsResponse::setWebSettings()
     * @uses CompanyNewsResponse::setCompanySettings()
     * @uses CompanyNewsResponse::setDescription()
     * @param int $newsID
     * @param string $createdDate
     * @param string $webSettings
     * @param string $companySettings
     * @param string $description
     */
    public function __construct($newsID = null, $createdDate = null, $webSettings = null, $companySettings = null, $description = null)
    {
        $this
            ->setNewsID($newsID)
            ->setCreatedDate($createdDate)
            ->setWebSettings($webSettings)
            ->setCompanySettings($companySettings)
            ->setDescription($description);
    }
    /**
     * Get NewsID value
     * @return int
     */
    public function getNewsID()
    {
        return $this->NewsID;
    }
    /**
     * Set NewsID value
     * @param int $newsID
     * @return \StructType\CompanyNewsResponse
     */
    public function setNewsID($newsID = null)
    {
        // validation for constraint: int
        if (!is_null($newsID) && !is_numeric($newsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newsID)), __LINE__);
        }
        $this->NewsID = $newsID;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\CompanyNewsResponse
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get WebSettings value
     * @return string
     */
    public function getWebSettings()
    {
        return $this->WebSettings;
    }
    /**
     * Set WebSettings value
     * @uses \EnumType\NewsWebSettings::valueIsValid()
     * @uses \EnumType\NewsWebSettings::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $webSettings
     * @return \StructType\CompanyNewsResponse
     */
    public function setWebSettings($webSettings = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NewsWebSettings::valueIsValid($webSettings)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $webSettings, implode(', ', \EnumType\NewsWebSettings::getValidValues())), __LINE__);
        }
        $this->WebSettings = $webSettings;
        return $this;
    }
    /**
     * Get CompanySettings value
     * @return string
     */
    public function getCompanySettings()
    {
        return $this->CompanySettings;
    }
    /**
     * Set CompanySettings value
     * @uses \EnumType\NewsCompanySettings::valueIsValid()
     * @uses \EnumType\NewsCompanySettings::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $companySettings
     * @return \StructType\CompanyNewsResponse
     */
    public function setCompanySettings($companySettings = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NewsCompanySettings::valueIsValid($companySettings)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $companySettings, implode(', ', \EnumType\NewsCompanySettings::getValidValues())), __LINE__);
        }
        $this->CompanySettings = $companySettings;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CompanyNewsResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyNewsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
