<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeWalletAccountOnFileRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeWalletAccountOnFileRequest
 * @subpackage Structs
 */
class ChargeWalletAccountOnFileRequest extends BaseCreatePaymentRequest
{
    /**
     * The WalletAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WalletAccountType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeWalletAccountOnFileRequest
     * @uses ChargeWalletAccountOnFileRequest::setWalletAccountType()
     * @uses ChargeWalletAccountOnFileRequest::setOrderID()
     * @uses ChargeWalletAccountOnFileRequest::setMaxAmount()
     * @uses ChargeWalletAccountOnFileRequest::setMemo()
     * @uses ChargeWalletAccountOnFileRequest::setOrderKey()
     * @param string $walletAccountType
     * @param int $orderID
     * @param float $maxAmount
     * @param string $memo
     * @param string $orderKey
     */
    public function __construct($walletAccountType = null, $orderID = null, $maxAmount = null, $memo = null, $orderKey = null)
    {
        $this
            ->setWalletAccountType($walletAccountType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setMemo($memo)
            ->setOrderKey($orderKey);
    }
    /**
     * Get WalletAccountType value
     * @return string
     */
    public function getWalletAccountType()
    {
        return $this->WalletAccountType;
    }
    /**
     * Set WalletAccountType value
     * @uses \EnumType\AccountWalletType::valueIsValid()
     * @uses \EnumType\AccountWalletType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $walletAccountType
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public function setWalletAccountType($walletAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountWalletType::valueIsValid($walletAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $walletAccountType, implode(', ', \EnumType\AccountWalletType::getValidValues())), __LINE__);
        }
        $this->WalletAccountType = $walletAccountType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeWalletAccountOnFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
