<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargePriorAuthorizationRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargePriorAuthorizationRequest
 * @subpackage Structs
 */
class ChargePriorAuthorizationRequest extends BaseCreatePaymentRequest
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The MerchantTransactionKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantTransactionKey;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargePriorAuthorizationRequest
     * @uses ChargePriorAuthorizationRequest::setOrderID()
     * @uses ChargePriorAuthorizationRequest::setMaxAmount()
     * @uses ChargePriorAuthorizationRequest::setMerchantTransactionKey()
     * @uses ChargePriorAuthorizationRequest::setOrderKey()
     * @param int $orderID
     * @param float $maxAmount
     * @param string $merchantTransactionKey
     * @param string $orderKey
     */
    public function __construct($orderID = null, $maxAmount = null, $merchantTransactionKey = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setMerchantTransactionKey($merchantTransactionKey)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargePriorAuthorizationRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargePriorAuthorizationRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get MerchantTransactionKey value
     * @return string|null
     */
    public function getMerchantTransactionKey()
    {
        return $this->MerchantTransactionKey;
    }
    /**
     * Set MerchantTransactionKey value
     * @param string $merchantTransactionKey
     * @return \StructType\ChargePriorAuthorizationRequest
     */
    public function setMerchantTransactionKey($merchantTransactionKey = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTransactionKey) && !is_string($merchantTransactionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantTransactionKey)), __LINE__);
        }
        $this->MerchantTransactionKey = $merchantTransactionKey;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargePriorAuthorizationRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargePriorAuthorizationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
