<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeGroupOrderCreditCardTokenResponse StructType
 * @subpackage Structs
 */
class ChargeGroupOrderCreditCardTokenResponse extends ApiResponse
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The _paymentIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPaymentsResponse
     */
    public $_paymentIDs;
    /**
     * The AuthorizationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Payments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPaymentsResponse
     */
    public $Payments;
    /**
     * Constructor method for ChargeGroupOrderCreditCardTokenResponse
     * @uses ChargeGroupOrderCreditCardTokenResponse::setAmount()
     * @uses ChargeGroupOrderCreditCardTokenResponse::set_paymentIDs()
     * @uses ChargeGroupOrderCreditCardTokenResponse::setAuthorizationCode()
     * @uses ChargeGroupOrderCreditCardTokenResponse::setPayments()
     * @param float $amount
     * @param \ArrayType\ArrayOfPaymentsResponse $_paymentIDs
     * @param string $authorizationCode
     * @param \ArrayType\ArrayOfPaymentsResponse $payments
     */
    public function __construct($amount = null, \ArrayType\ArrayOfPaymentsResponse $_paymentIDs = null, $authorizationCode = null, \ArrayType\ArrayOfPaymentsResponse $payments = null)
    {
        $this
            ->setAmount($amount)
            ->set_paymentIDs($_paymentIDs)
            ->setAuthorizationCode($authorizationCode)
            ->setPayments($payments);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get _paymentIDs value
     * @return \ArrayType\ArrayOfPaymentsResponse|null
     */
    public function get_paymentIDs()
    {
        return $this->_paymentIDs;
    }
    /**
     * Set _paymentIDs value
     * @param \ArrayType\ArrayOfPaymentsResponse $_paymentIDs
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse
     */
    public function set_paymentIDs(\ArrayType\ArrayOfPaymentsResponse $_paymentIDs = null)
    {
        $this->_paymentIDs = $_paymentIDs;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get Payments value
     * @return \ArrayType\ArrayOfPaymentsResponse|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * Set Payments value
     * @param \ArrayType\ArrayOfPaymentsResponse $payments
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse
     */
    public function setPayments(\ArrayType\ArrayOfPaymentsResponse $payments = null)
    {
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeGroupOrderCreditCardTokenResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
