<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateOrderRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CalculateOrderRequest
 * @subpackage Structs
 */
class CalculateOrderRequest extends BaseCalculateOrderRequest
{
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The ShipMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShipMethodID;
    /**
     * The PriceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceType;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderType;
    /**
     * The TaxRateOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxRateOverride;
    /**
     * The ShippingAmountOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShippingAmountOverride;
    /**
     * The ReturnOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReturnOrderID;
    /**
     * The ReturnShipMethods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReturnShipMethods;
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyID;
    /**
     * The ReturnTrace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReturnTrace;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The County
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The Other11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other11;
    /**
     * The Other12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other12;
    /**
     * The Other13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other13;
    /**
     * The Other14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other14;
    /**
     * The Other15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other15;
    /**
     * The Other16
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other16;
    /**
     * The Other17
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other17;
    /**
     * The Other18
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other18;
    /**
     * The Other19
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other19;
    /**
     * The Other20
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other20;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderDetailRequest
     */
    public $Details;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ReturnOrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnOrderKey;
    /**
     * Constructor method for CalculateOrderRequest
     * @uses CalculateOrderRequest::setWarehouseID()
     * @uses CalculateOrderRequest::setShipMethodID()
     * @uses CalculateOrderRequest::setPriceType()
     * @uses CalculateOrderRequest::setCustomerID()
     * @uses CalculateOrderRequest::setOrderType()
     * @uses CalculateOrderRequest::setTaxRateOverride()
     * @uses CalculateOrderRequest::setShippingAmountOverride()
     * @uses CalculateOrderRequest::setReturnOrderID()
     * @uses CalculateOrderRequest::setReturnShipMethods()
     * @uses CalculateOrderRequest::setPartyID()
     * @uses CalculateOrderRequest::setReturnTrace()
     * @uses CalculateOrderRequest::setCurrencyCode()
     * @uses CalculateOrderRequest::setAddress1()
     * @uses CalculateOrderRequest::setAddress2()
     * @uses CalculateOrderRequest::setAddress3()
     * @uses CalculateOrderRequest::setCity()
     * @uses CalculateOrderRequest::setState()
     * @uses CalculateOrderRequest::setZip()
     * @uses CalculateOrderRequest::setCountry()
     * @uses CalculateOrderRequest::setCounty()
     * @uses CalculateOrderRequest::setOther11()
     * @uses CalculateOrderRequest::setOther12()
     * @uses CalculateOrderRequest::setOther13()
     * @uses CalculateOrderRequest::setOther14()
     * @uses CalculateOrderRequest::setOther15()
     * @uses CalculateOrderRequest::setOther16()
     * @uses CalculateOrderRequest::setOther17()
     * @uses CalculateOrderRequest::setOther18()
     * @uses CalculateOrderRequest::setOther19()
     * @uses CalculateOrderRequest::setOther20()
     * @uses CalculateOrderRequest::setDetails()
     * @uses CalculateOrderRequest::setCustomerKey()
     * @uses CalculateOrderRequest::setReturnOrderKey()
     * @param int $warehouseID
     * @param int $shipMethodID
     * @param int $priceType
     * @param int $customerID
     * @param string $orderType
     * @param float $taxRateOverride
     * @param float $shippingAmountOverride
     * @param int $returnOrderID
     * @param bool $returnShipMethods
     * @param int $partyID
     * @param bool $returnTrace
     * @param string $currencyCode
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $county
     * @param string $other11
     * @param string $other12
     * @param string $other13
     * @param string $other14
     * @param string $other15
     * @param string $other16
     * @param string $other17
     * @param string $other18
     * @param string $other19
     * @param string $other20
     * @param \ArrayType\ArrayOfOrderDetailRequest $details
     * @param string $customerKey
     * @param string $returnOrderKey
     */
    public function __construct($warehouseID = null, $shipMethodID = null, $priceType = null, $customerID = null, $orderType = null, $taxRateOverride = null, $shippingAmountOverride = null, $returnOrderID = null, $returnShipMethods = null, $partyID = null, $returnTrace = null, $currencyCode = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $state = null, $zip = null, $country = null, $county = null, $other11 = null, $other12 = null, $other13 = null, $other14 = null, $other15 = null, $other16 = null, $other17 = null, $other18 = null, $other19 = null, $other20 = null, \ArrayType\ArrayOfOrderDetailRequest $details = null, $customerKey = null, $returnOrderKey = null)
    {
        $this
            ->setWarehouseID($warehouseID)
            ->setShipMethodID($shipMethodID)
            ->setPriceType($priceType)
            ->setCustomerID($customerID)
            ->setOrderType($orderType)
            ->setTaxRateOverride($taxRateOverride)
            ->setShippingAmountOverride($shippingAmountOverride)
            ->setReturnOrderID($returnOrderID)
            ->setReturnShipMethods($returnShipMethods)
            ->setPartyID($partyID)
            ->setReturnTrace($returnTrace)
            ->setCurrencyCode($currencyCode)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setCounty($county)
            ->setOther11($other11)
            ->setOther12($other12)
            ->setOther13($other13)
            ->setOther14($other14)
            ->setOther15($other15)
            ->setOther16($other16)
            ->setOther17($other17)
            ->setOther18($other18)
            ->setOther19($other19)
            ->setOther20($other20)
            ->setDetails($details)
            ->setCustomerKey($customerKey)
            ->setReturnOrderKey($returnOrderKey);
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\CalculateOrderRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ShipMethodID value
     * @return int
     */
    public function getShipMethodID()
    {
        return $this->ShipMethodID;
    }
    /**
     * Set ShipMethodID value
     * @param int $shipMethodID
     * @return \StructType\CalculateOrderRequest
     */
    public function setShipMethodID($shipMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($shipMethodID) && !is_numeric($shipMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipMethodID)), __LINE__);
        }
        $this->ShipMethodID = $shipMethodID;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\CalculateOrderRequest
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !is_numeric($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CalculateOrderRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @uses \EnumType\OrderType::valueIsValid()
     * @uses \EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \StructType\CalculateOrderRequest
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderType, implode(', ', \EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get TaxRateOverride value
     * @return float
     */
    public function getTaxRateOverride()
    {
        return $this->TaxRateOverride;
    }
    /**
     * Set TaxRateOverride value
     * @param float $taxRateOverride
     * @return \StructType\CalculateOrderRequest
     */
    public function setTaxRateOverride($taxRateOverride = null)
    {
        $this->TaxRateOverride = $taxRateOverride;
        return $this;
    }
    /**
     * Get ShippingAmountOverride value
     * @return float
     */
    public function getShippingAmountOverride()
    {
        return $this->ShippingAmountOverride;
    }
    /**
     * Set ShippingAmountOverride value
     * @param float $shippingAmountOverride
     * @return \StructType\CalculateOrderRequest
     */
    public function setShippingAmountOverride($shippingAmountOverride = null)
    {
        $this->ShippingAmountOverride = $shippingAmountOverride;
        return $this;
    }
    /**
     * Get ReturnOrderID value
     * @return int
     */
    public function getReturnOrderID()
    {
        return $this->ReturnOrderID;
    }
    /**
     * Set ReturnOrderID value
     * @param int $returnOrderID
     * @return \StructType\CalculateOrderRequest
     */
    public function setReturnOrderID($returnOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($returnOrderID) && !is_numeric($returnOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($returnOrderID)), __LINE__);
        }
        $this->ReturnOrderID = $returnOrderID;
        return $this;
    }
    /**
     * Get ReturnShipMethods value
     * @return bool
     */
    public function getReturnShipMethods()
    {
        return $this->ReturnShipMethods;
    }
    /**
     * Set ReturnShipMethods value
     * @param bool $returnShipMethods
     * @return \StructType\CalculateOrderRequest
     */
    public function setReturnShipMethods($returnShipMethods = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnShipMethods) && !is_bool($returnShipMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnShipMethods)), __LINE__);
        }
        $this->ReturnShipMethods = $returnShipMethods;
        return $this;
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\CalculateOrderRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get ReturnTrace value
     * @return bool
     */
    public function getReturnTrace()
    {
        return $this->ReturnTrace;
    }
    /**
     * Set ReturnTrace value
     * @param bool $returnTrace
     * @return \StructType\CalculateOrderRequest
     */
    public function setReturnTrace($returnTrace = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnTrace) && !is_bool($returnTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnTrace)), __LINE__);
        }
        $this->ReturnTrace = $returnTrace;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CalculateOrderRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\CalculateOrderRequest
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\CalculateOrderRequest
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\CalculateOrderRequest
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\CalculateOrderRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\CalculateOrderRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\CalculateOrderRequest
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\CalculateOrderRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\CalculateOrderRequest
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get Other11 value
     * @return string|null
     */
    public function getOther11()
    {
        return $this->Other11;
    }
    /**
     * Set Other11 value
     * @param string $other11
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther11($other11 = null)
    {
        // validation for constraint: string
        if (!is_null($other11) && !is_string($other11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other11)), __LINE__);
        }
        $this->Other11 = $other11;
        return $this;
    }
    /**
     * Get Other12 value
     * @return string|null
     */
    public function getOther12()
    {
        return $this->Other12;
    }
    /**
     * Set Other12 value
     * @param string $other12
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther12($other12 = null)
    {
        // validation for constraint: string
        if (!is_null($other12) && !is_string($other12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other12)), __LINE__);
        }
        $this->Other12 = $other12;
        return $this;
    }
    /**
     * Get Other13 value
     * @return string|null
     */
    public function getOther13()
    {
        return $this->Other13;
    }
    /**
     * Set Other13 value
     * @param string $other13
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther13($other13 = null)
    {
        // validation for constraint: string
        if (!is_null($other13) && !is_string($other13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other13)), __LINE__);
        }
        $this->Other13 = $other13;
        return $this;
    }
    /**
     * Get Other14 value
     * @return string|null
     */
    public function getOther14()
    {
        return $this->Other14;
    }
    /**
     * Set Other14 value
     * @param string $other14
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther14($other14 = null)
    {
        // validation for constraint: string
        if (!is_null($other14) && !is_string($other14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other14)), __LINE__);
        }
        $this->Other14 = $other14;
        return $this;
    }
    /**
     * Get Other15 value
     * @return string|null
     */
    public function getOther15()
    {
        return $this->Other15;
    }
    /**
     * Set Other15 value
     * @param string $other15
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther15($other15 = null)
    {
        // validation for constraint: string
        if (!is_null($other15) && !is_string($other15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other15)), __LINE__);
        }
        $this->Other15 = $other15;
        return $this;
    }
    /**
     * Get Other16 value
     * @return string|null
     */
    public function getOther16()
    {
        return $this->Other16;
    }
    /**
     * Set Other16 value
     * @param string $other16
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther16($other16 = null)
    {
        // validation for constraint: string
        if (!is_null($other16) && !is_string($other16)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other16)), __LINE__);
        }
        $this->Other16 = $other16;
        return $this;
    }
    /**
     * Get Other17 value
     * @return string|null
     */
    public function getOther17()
    {
        return $this->Other17;
    }
    /**
     * Set Other17 value
     * @param string $other17
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther17($other17 = null)
    {
        // validation for constraint: string
        if (!is_null($other17) && !is_string($other17)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other17)), __LINE__);
        }
        $this->Other17 = $other17;
        return $this;
    }
    /**
     * Get Other18 value
     * @return string|null
     */
    public function getOther18()
    {
        return $this->Other18;
    }
    /**
     * Set Other18 value
     * @param string $other18
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther18($other18 = null)
    {
        // validation for constraint: string
        if (!is_null($other18) && !is_string($other18)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other18)), __LINE__);
        }
        $this->Other18 = $other18;
        return $this;
    }
    /**
     * Get Other19 value
     * @return string|null
     */
    public function getOther19()
    {
        return $this->Other19;
    }
    /**
     * Set Other19 value
     * @param string $other19
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther19($other19 = null)
    {
        // validation for constraint: string
        if (!is_null($other19) && !is_string($other19)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other19)), __LINE__);
        }
        $this->Other19 = $other19;
        return $this;
    }
    /**
     * Get Other20 value
     * @return string|null
     */
    public function getOther20()
    {
        return $this->Other20;
    }
    /**
     * Set Other20 value
     * @param string $other20
     * @return \StructType\CalculateOrderRequest
     */
    public function setOther20($other20 = null)
    {
        // validation for constraint: string
        if (!is_null($other20) && !is_string($other20)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other20)), __LINE__);
        }
        $this->Other20 = $other20;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfOrderDetailRequest|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfOrderDetailRequest $details
     * @return \StructType\CalculateOrderRequest
     */
    public function setDetails(\ArrayType\ArrayOfOrderDetailRequest $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CalculateOrderRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ReturnOrderKey value
     * @return string|null
     */
    public function getReturnOrderKey()
    {
        return $this->ReturnOrderKey;
    }
    /**
     * Set ReturnOrderKey value
     * @param string $returnOrderKey
     * @return \StructType\CalculateOrderRequest
     */
    public function setReturnOrderKey($returnOrderKey = null)
    {
        // validation for constraint: string
        if (!is_null($returnOrderKey) && !is_string($returnOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnOrderKey)), __LINE__);
        }
        $this->ReturnOrderKey = $returnOrderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalculateOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
