<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateCustomerRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthenticateCustomerRequest
 * @subpackage Structs
 */
class AuthenticateCustomerRequest extends ApiRequest
{
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AuthenticateCustomerRequest
     * @uses AuthenticateCustomerRequest::setLoginName()
     * @uses AuthenticateCustomerRequest::setPassword()
     * @param string $loginName
     * @param string $password
     */
    public function __construct($loginName = null, $password = null)
    {
        $this
            ->setLoginName($loginName)
            ->setPassword($password);
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\AuthenticateCustomerRequest
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AuthenticateCustomerRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticateCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
