<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiAuthentication StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ApiAuthentication
 * @subpackage Structs
 */
class ApiAuthentication extends AbstractStructBase
{
    /**
     * The RequestTimeUtc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestTimeUtc;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The Identity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identity;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * Constructor method for ApiAuthentication
     * @uses ApiAuthentication::setRequestTimeUtc()
     * @uses ApiAuthentication::setLoginName()
     * @uses ApiAuthentication::setPassword()
     * @uses ApiAuthentication::setCompany()
     * @uses ApiAuthentication::setIdentity()
     * @uses ApiAuthentication::setSignature()
     * @param string $requestTimeUtc
     * @param string $loginName
     * @param string $password
     * @param string $company
     * @param string $identity
     * @param string $signature
     */
    public function __construct($requestTimeUtc = null, $loginName = null, $password = null, $company = null, $identity = null, $signature = null)
    {
        $this
            ->setRequestTimeUtc($requestTimeUtc)
            ->setLoginName($loginName)
            ->setPassword($password)
            ->setCompany($company)
            ->setIdentity($identity)
            ->setSignature($signature);
    }
    /**
     * Get RequestTimeUtc value
     * @return string
     */
    public function getRequestTimeUtc()
    {
        return $this->RequestTimeUtc;
    }
    /**
     * Set RequestTimeUtc value
     * @param string $requestTimeUtc
     * @return \StructType\ApiAuthentication
     */
    public function setRequestTimeUtc($requestTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($requestTimeUtc) && !is_string($requestTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTimeUtc)), __LINE__);
        }
        $this->RequestTimeUtc = $requestTimeUtc;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\ApiAuthentication
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ApiAuthentication
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\ApiAuthentication
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Identity value
     * @return string|null
     */
    public function getIdentity()
    {
        return $this->Identity;
    }
    /**
     * Set Identity value
     * @param string $identity
     * @return \StructType\ApiAuthentication
     */
    public function setIdentity($identity = null)
    {
        // validation for constraint: string
        if (!is_null($identity) && !is_string($identity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identity)), __LINE__);
        }
        $this->Identity = $identity;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \StructType\ApiAuthentication
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApiAuthentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
