<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddProductsToCategoryRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AddProductsToCategoryRequest
 * @subpackage Structs
 */
class AddProductsToCategoryRequest extends ApiRequest
{
    /**
     * The WebID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WebID;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryID;
    /**
     * The ItemCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ItemCodes;
    /**
     * Constructor method for AddProductsToCategoryRequest
     * @uses AddProductsToCategoryRequest::setWebID()
     * @uses AddProductsToCategoryRequest::setCategoryID()
     * @uses AddProductsToCategoryRequest::setItemCodes()
     * @param int $webID
     * @param int $categoryID
     * @param \ArrayType\ArrayOfString $itemCodes
     */
    public function __construct($webID = null, $categoryID = null, \ArrayType\ArrayOfString $itemCodes = null)
    {
        $this
            ->setWebID($webID)
            ->setCategoryID($categoryID)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get WebID value
     * @return int
     */
    public function getWebID()
    {
        return $this->WebID;
    }
    /**
     * Set WebID value
     * @param int $webID
     * @return \StructType\AddProductsToCategoryRequest
     */
    public function setWebID($webID = null)
    {
        // validation for constraint: int
        if (!is_null($webID) && !is_numeric($webID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webID)), __LINE__);
        }
        $this->WebID = $webID;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\AddProductsToCategoryRequest
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \ArrayType\ArrayOfString $itemCodes
     * @return \StructType\AddProductsToCategoryRequest
     */
    public function setItemCodes(\ArrayType\ArrayOfString $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddProductsToCategoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
