<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPartyGuestsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AddPartyGuestsRequest
 * @subpackage Structs
 */
class AddPartyGuestsRequest extends ApiRequest
{
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartyID;
    /**
     * The GuestIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $GuestIDs;
    /**
     * Constructor method for AddPartyGuestsRequest
     * @uses AddPartyGuestsRequest::setPartyID()
     * @uses AddPartyGuestsRequest::setGuestIDs()
     * @param int $partyID
     * @param \ArrayType\ArrayOfInt $guestIDs
     */
    public function __construct($partyID = null, \ArrayType\ArrayOfInt $guestIDs = null)
    {
        $this
            ->setPartyID($partyID)
            ->setGuestIDs($guestIDs);
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\AddPartyGuestsRequest
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get GuestIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getGuestIDs()
    {
        return $this->GuestIDs;
    }
    /**
     * Set GuestIDs value
     * @param \ArrayType\ArrayOfInt $guestIDs
     * @return \StructType\AddPartyGuestsRequest
     */
    public function setGuestIDs(\ArrayType\ArrayOfInt $guestIDs = null)
    {
        $this->GuestIDs = $guestIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddPartyGuestsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
