<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetAccountChecking
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup bank account on file an existing customer, or new customer in a transaction. You can also empty the account settings by simply leaving everything but CustomerID empty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccountCheckingRequest $setAccountCheckingRequest
     * @return \StructType\SetAccountResponse|bool
     */
    public function SetAccountChecking(\StructType\SetAccountCheckingRequest $setAccountCheckingRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccountChecking($setAccountCheckingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAccountCreditCard
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup primary or secondary credit card on file for an existing customer, or new customer in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccountCreditCardRequest $setAccountCreditCardRequest
     * @return \StructType\SetAccountResponse|bool
     */
    public function SetAccountCreditCard(\StructType\SetAccountCreditCardRequest $setAccountCreditCardRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccountCreditCard($setAccountCreditCardRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAccountCreditCardToken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup primary or secondary credit card token on file for an existing customer, or new customer in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccountCreditCardTokenRequest $setAccountCreditCardTokenRequest
     * @return \StructType\SetAccountResponse|bool
     */
    public function SetAccountCreditCardToken(\StructType\SetAccountCreditCardTokenRequest $setAccountCreditCardTokenRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccountCreditCardToken($setAccountCreditCardTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAccountDirectDeposit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup direct deposit info for an existing customer, or new customer in a transaction. You can also empty the account settings by simply leaving everything but CustomerID empty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccountDirectDepositRequest $setAccountDirectDepositRequest
     * @return \StructType\SetAccountResponse|bool
     */
    public function SetAccountDirectDeposit(\StructType\SetAccountDirectDepositRequest $setAccountDirectDepositRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccountDirectDeposit($setAccountDirectDepositRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAccountWallet
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup primary or secondary wallet account on file for an existing customer, or new customer in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccountWalletRequest $setAccountWalletRequest
     * @return \StructType\SetAccountResponse|bool
     */
    public function SetAccountWallet(\StructType\SetAccountWalletRequest $setAccountWalletRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccountWallet($setAccountWalletRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetBinaryPreference
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets the placement preference for new placements under a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetBinaryPreferenceRequest $setBinaryPreferenceRequest
     * @return \StructType\SetBinaryPreferenceResponse|bool
     */
    public function SetBinaryPreference(\StructType\SetBinaryPreferenceRequest $setBinaryPreferenceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetBinaryPreference($setBinaryPreferenceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerLeadSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes all existing social network(s) for the customer lead, then inserts the provided list of social network(s) for the customer lead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerLeadSocialNetworksRequest $setCustomerLeadSocialNetworksRequest
     * @return \StructType\SetCustomerLeadSocialNetworksResponse|bool
     */
    public function SetCustomerLeadSocialNetworks(\StructType\SetCustomerLeadSocialNetworksRequest $setCustomerLeadSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCustomerLeadSocialNetworks($setCustomerLeadSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerSite
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup public web site info for an existing customer, or new customer in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerSiteRequest $setCusotmerSiteRequest
     * @return \StructType\SetCustomerSiteResponse|bool
     */
    public function SetCustomerSite(\StructType\SetCustomerSiteRequest $setCusotmerSiteRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCustomerSite($setCusotmerSiteRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerSiteImage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup public web site image for an existing customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerSiteImageRequest $setCusotmerSiteImageRequest
     * @return \StructType\SetCustomerSiteImageResponse|bool
     */
    public function SetCustomerSiteImage(\StructType\SetCustomerSiteImageRequest $setCusotmerSiteImageRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCustomerSiteImage($setCusotmerSiteImageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes all existing social network(s) for the customer, then inserts the provided list of social network(s) for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerSocialNetworksRequest $setCustomerSocialNetworksRequest
     * @return \StructType\SetCustomerSocialNetworksResponse|bool
     */
    public function SetCustomerSocialNetworks(\StructType\SetCustomerSocialNetworksRequest $setCustomerSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCustomerSocialNetworks($setCustomerSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetGuestSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deletes all existing social network(s) for the guest, then inserts the provided list of social network(s) for the guest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetGuestSocialNetworksRequest $setGuestSocialNetworksRequest
     * @return \StructType\SetGuestSocialNetworksResponse|bool
     */
    public function SetGuestSocialNetworks(\StructType\SetGuestSocialNetworksRequest $setGuestSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetGuestSocialNetworks($setGuestSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetImageFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Set Images
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetImageFileRequest $setImageFileRequest
     * @return \StructType\SetImageFileResponse|bool
     */
    public function SetImageFile(\StructType\SetImageFileRequest $setImageFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetImageFile($setImageFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetItemCountryRegion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets country/region info for an item)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetItemCountryRegionRequest $setItemCountryRegionRequest
     * @return \StructType\SetItemCountryRegionResponse|bool
     */
    public function SetItemCountryRegion(\StructType\SetItemCountryRegionRequest $setItemCountryRegionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetItemCountryRegion($setItemCountryRegionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetItemImage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Set Images for an Item
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetItemImageRequest $setItemImageRequest
     * @return \StructType\SetItemImageResponse|bool
     */
    public function SetItemImage(\StructType\SetItemImageRequest $setItemImageRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetItemImage($setItemImageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetItemKitMembers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets the children for a static kit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetItemKitMembersRequest $setItemKitMembersRequest
     * @return \StructType\SetItemKitMembersResponse|bool
     */
    public function SetItemKitMembers(\StructType\SetItemKitMembersRequest $setItemKitMembersRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetItemKitMembers($setItemKitMembersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetItemPrice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets pricing info for an item)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetItemPriceRequest $setItemPriceRequest
     * @return \StructType\SetItemPriceResponse|bool
     */
    public function SetItemPrice(\StructType\SetItemPriceRequest $setItemPriceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetItemPrice($setItemPriceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetItemWarehouse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets warehouse info for an item)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetItemWarehouseRequest $setItemWarehouseRequest
     * @return \StructType\SetItemWarehouseResponse|bool
     */
    public function SetItemWarehouse(\StructType\SetItemWarehouseRequest $setItemWarehouseRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetItemWarehouse($setItemWarehouseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetQualificationOverride
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create or Edit a Customer Override
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetQualificationOverrideRequest $setQualificationOverrideRequest
     * @return \StructType\SetQualificationOverrideResponse|bool
     */
    public function SetQualificationOverride(\StructType\SetQualificationOverrideRequest $setQualificationOverrideRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetQualificationOverride($setQualificationOverrideRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSession
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Sets a generic session string for a unique sessionID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSessionRequest $setSessionRequest
     * @return \StructType\SetSessionResponse|bool
     */
    public function SetSession(\StructType\SetSessionRequest $setSessionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SetSession($setSessionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetAccountResponse|\StructType\SetBinaryPreferenceResponse|\StructType\SetCustomerLeadSocialNetworksResponse|\StructType\SetCustomerSiteImageResponse|\StructType\SetCustomerSiteResponse|\StructType\SetCustomerSocialNetworksResponse|\StructType\SetGuestSocialNetworksResponse|\StructType\SetImageFileResponse|\StructType\SetItemCountryRegionResponse|\StructType\SetItemImageResponse|\StructType\SetItemKitMembersResponse|\StructType\SetItemPriceResponse|\StructType\SetItemWarehouseResponse|\StructType\SetQualificationOverrideResponse|\StructType\SetSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
