<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Opt ServiceType
 * @subpackage Services
 */
class Opt extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OptInEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup opt in settings for Email by Email address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptInEmailRequest $optInEmailRequest
     * @return \StructType\OptInEmailResponse|bool
     */
    public function OptInEmail(\StructType\OptInEmailRequest $optInEmailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptInEmail($optInEmailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OptInPushNotification
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup opt in settings for Push Notifications to mobile devices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptInPushNotificationRequest $optInPushNotificationRequest
     * @return \StructType\OptInPushNotificationResponse|bool
     */
    public function OptInPushNotification(\StructType\OptInPushNotificationRequest $optInPushNotificationRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptInPushNotification($optInPushNotificationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OptInSms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup opt in settings for Sms messaging by phone number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptInSmsRequest $optInSmsRequest
     * @return \StructType\OptInSmsResponse|bool
     */
    public function OptInSms(\StructType\OptInSmsRequest $optInSmsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptInSms($optInSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OptOutEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Opts out all customers and customer contacts with specified email from receiving broadcast emails.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptOutEmailRequest $optOutEmailRequest
     * @return \StructType\OptOutEmailResponse|bool
     */
    public function OptOutEmail(\StructType\OptOutEmailRequest $optOutEmailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptOutEmail($optOutEmailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OptOutPushNotification
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Setup opt out settings for Push Notifications to mobile devices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptOutPushNotificationRequest $optOutPushNotificationRequest
     * @return \StructType\OptOutPushNotificationResponse|bool
     */
    public function OptOutPushNotification(\StructType\OptOutPushNotificationRequest $optOutPushNotificationRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptOutPushNotification($optOutPushNotificationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OptOutSms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Opts out all customers and customer contacts with specified phone number from receiving broadcast SMS messages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptOutSmsRequest $optOutSmsRequest
     * @return \StructType\OptOutSmsResponse|bool
     */
    public function OptOutSms(\StructType\OptOutSmsRequest $optOutSmsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->OptOutSms($optOutSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OptInEmailResponse|\StructType\OptInPushNotificationResponse|\StructType\OptInSmsResponse|\StructType\OptOutEmailResponse|\StructType\OptOutPushNotificationResponse|\StructType\OptOutSmsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
