<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateApiWhitelist
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create a new Whitelisted IP range
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateApiWhitelistRequest $createApiWhitelistRequest
     * @return \StructType\CreateApiWhitelistResponse|bool
     */
    public function CreateApiWhitelist(\StructType\CreateApiWhitelistRequest $createApiWhitelistRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateApiWhitelist($createApiWhitelistRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAutoOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create a new Recurring Order template for an existing customer or a new customer as part of a transaction. Client provides schedule, item codes, quantity, and shipping info. Server calculates and commits data, then pricing, tax,
     * shipping and volume info. You can also update/overwrite an existing autoorder by using the OverwriteExistingAutoOrder and ExistingAutoOrderID properties.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAutoOrderRequest $createAutoOrderRequest
     * @return \StructType\CreateAutoOrderResponse|bool
     */
    public function CreateAutoOrder(\StructType\CreateAutoOrderRequest $createAutoOrderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAutoOrder($createAutoOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new bill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateBillRequest $createBillRequest
     * @return \StructType\CreateBillResponse|bool
     */
    public function CreateBill(\StructType\CreateBillRequest $createBillRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateBill($createBillRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCalendarItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new calendar item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCalendarItemRequest $createCalendarItemRequest
     * @return \StructType\CreateCalendarItemResponse|bool
     */
    public function CreateCalendarItem(\StructType\CreateCalendarItemRequest $createCalendarItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCalendarItem($createCalendarItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new Customer. Can optionally be put in one or more trees.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerRequest $createCustomerRequest
     * @return \StructType\CreateCustomerResponse|bool
     */
    public function CreateCustomer(\StructType\CreateCustomerRequest $createCustomerRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomer($createCustomerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerBalanceAdjustment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create an adjustment for a customer's account in a currency.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerBalanceAdjustmentRequest $createCustomerBalanceAdjustmentRequest
     * @return \StructType\CreateCustomerBalanceAdjustmentResponse|bool
     */
    public function CreateCustomerBalanceAdjustment(\StructType\CreateCustomerBalanceAdjustmentRequest $createCustomerBalanceAdjustmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerBalanceAdjustment($createCustomerBalanceAdjustmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new customer contact.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerContactRequest $createCustomerContactRequest
     * @return \StructType\CreateCustomerContactResponse|bool
     */
    public function CreateCustomerContact(\StructType\CreateCustomerContactRequest $createCustomerContactRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerContact($createCustomerContactRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerExtended
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new customer extended record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerExtendedRequest $createCustomerExtendedRequest
     * @return \StructType\CreateCustomerExtendedResponse|bool
     */
    public function CreateCustomerExtended(\StructType\CreateCustomerExtendedRequest $createCustomerExtendedRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerExtended($createCustomerExtendedRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a file for the customer in their default directory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerFileRequest $createCustomerFileRequest
     * @return \StructType\CreateCustomerFileResponse|bool
     */
    public function CreateCustomerFile(\StructType\CreateCustomerFileRequest $createCustomerFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerFile($createCustomerFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerInquiry
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a customer history record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerInquiryRequest $createCustomerInquiryRequest
     * @return \StructType\CreateCustomerInquiryResponse|bool
     */
    public function CreateCustomerInquiry(\StructType\CreateCustomerInquiryRequest $createCustomerInquiryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerInquiry($createCustomerInquiryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerLead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new customer lead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerLeadRequest $createCustomerLeadRequest
     * @return \StructType\CreateCustomerLeadResponse|bool
     */
    public function CreateCustomerLead(\StructType\CreateCustomerLeadRequest $createCustomerLeadRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerLead($createCustomerLeadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomerWallItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create new wall item in CustomerWall table.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerWallItemRequest $createCustomerWallItemRequest
     * @return \StructType\CreateCustomerWallItemResponse|bool
     */
    public function CreateCustomerWallItem(\StructType\CreateCustomerWallItemRequest $createCustomerWallItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomerWallItem($createCustomerWallItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates an email.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEmailRequest $createEmailRequest
     * @return \StructType\CreateEmailResponse|bool
     */
    public function CreateEmail(\StructType\CreateEmailRequest $createEmailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEmail($createEmailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEmailTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates an email template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEmailTemplateRequest $createEmailTemplateRequest
     * @return \StructType\CreateEmailTemplateResponse|bool
     */
    public function CreateEmailTemplate(\StructType\CreateEmailTemplateRequest $createEmailTemplateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEmailTemplate($createEmailTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExpectedBankWire
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new expected payment of type Bank Bire.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateExpectedBankWireRequest $createExpectedBankWireRequest
     * @return \StructType\CreateExpectedBankWireResponse|bool
     */
    public function CreateExpectedBankWire(\StructType\CreateExpectedBankWireRequest $createExpectedBankWireRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateExpectedBankWire($createExpectedBankWireRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExpectedPayment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new expected payment type using cash, money order etc.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateExpectedPaymentRequest $createExpectedPaymentRequest
     * @return \StructType\CreateExpectedPaymentResponse|bool
     */
    public function CreateExpectedPayment(\StructType\CreateExpectedPaymentRequest $createExpectedPaymentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateExpectedPayment($createExpectedPaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExtendedDbEntity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create Extended DB Entity.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEntityRequest $createEntityRequest
     * @return \StructType\CreateEntityResponse|bool
     */
    public function CreateExtendedDbEntity(\StructType\CreateEntityRequest $createEntityRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateExtendedDbEntity($createEntityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExtendedDbSchema
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create new Extended DB schema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateExtendedDbSchemeRequest $createExtendedDbSchemeRequest
     * @return \StructType\CreateExtendedDbSchemaResponse|bool
     */
    public function CreateExtendedDbSchema(\StructType\CreateExtendedDbSchemeRequest $createExtendedDbSchemeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateExtendedDbSchema($createExtendedDbSchemeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateGuest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new guest. Can optionally be put in a party.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateGuestRequest $createGuestRequest
     * @return \StructType\CreateGuestResponse|bool
     */
    public function CreateGuest(\StructType\CreateGuestRequest $createGuestRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateGuest($createGuestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Adds an Item (and optional warehouse/price info)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateItemRequest $createItemRequest
     * @return \StructType\CreateItemResponse|bool
     */
    public function CreateItem(\StructType\CreateItemRequest $createItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateItem($createItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMailFolder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a mail folder.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateMailFolderRequest $createMailFolderRequest
     * @return \StructType\CreateMailFolderResponse|bool
     */
    public function CreateMailFolder(\StructType\CreateMailFolderRequest $createMailFolderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateMailFolder($createMailFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new Order for an existing customer. Can create an order for a new customer if part of a transaction. Server will calculate all pricing, tax, shipping and volume info unless overridden in the request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrderRequest $createOrderRequest
     * @return \StructType\CreateOrderResponse|bool
     */
    public function CreateOrder(\StructType\CreateOrderRequest $createOrderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOrder($createOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrderDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create a new Order Detail for an existing order without recalculating. Can participate in a transaction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrderDetailRequest $createOrderDetailRequest
     * @return \StructType\CreateOrderDetailResponse|bool
     */
    public function CreateOrderDetail(\StructType\CreateOrderDetailRequest $createOrderDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOrderDetail($createOrderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrderImport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Imports a new Order for an existing customer. Use this for import routines or other instances where you wish to supply all calculation data. It is advised to use CreateOrder unless you know the exact breakdown of all pricing, tax,
     * shipping and volume info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrderImportRequest $createOrderImportRequest
     * @return \StructType\CreateOrderImportResponse|bool
     */
    public function CreateOrderImport(\StructType\CreateOrderImportRequest $createOrderImportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOrderImport($createOrderImportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateParty
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new Party
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePartyRequest $createPartyRequest
     * @return \StructType\CreatePartyResponse|bool
     */
    public function CreateParty(\StructType\CreatePartyRequest $createPartyRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateParty($createPartyRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePayment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new payment type using cash, money order etc.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentRequest $createPaymentRequest
     * @return \StructType\CreatePaymentResponse|bool
     */
    public function CreatePayment(\StructType\CreatePaymentRequest $createPaymentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePayment($createPaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentCheck
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new payment using check information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentCheckRequest $createPaymentCheckRequest
     * @return \StructType\CreatePaymentCheckResponse|bool
     */
    public function CreatePaymentCheck(\StructType\CreatePaymentCheckRequest $createPaymentCheckRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentCheck($createPaymentCheckRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentCreditCard
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a specific credit card payment for an existing order, or a new order in a transaction. Note: This does not charge a card, and you must have an authorization code to submit this.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentCreditCardRequest $createPaymentCreditCardRequest
     * @return \StructType\CreatePaymentCreditCardResponse|bool
     */
    public function CreatePaymentCreditCard(\StructType\CreatePaymentCreditCardRequest $createPaymentCreditCardRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentCreditCard($createPaymentCreditCardRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentPointAccount
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new payment for point account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentPointAccountRequest $createPaymentPointAccountRequest
     * @return \StructType\CreatePaymentPointAccountResponse|bool
     */
    public function CreatePaymentPointAccount(\StructType\CreatePaymentPointAccountRequest $createPaymentPointAccountRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentPointAccount($createPaymentPointAccountRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentWallet
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new payment for wallet account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentWalletRequest $createPaymentWalletRequest
     * @return \StructType\CreatePaymentResponse|bool
     */
    public function CreatePaymentWallet(\StructType\CreatePaymentWalletRequest $createPaymentWalletRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentWallet($createPaymentWalletRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePayout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new payout for one or more bills and updates status
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePayoutRequest $createPayoutRequest
     * @return \StructType\CreatePayoutResponse|bool
     */
    public function CreatePayout(\StructType\CreatePayoutRequest $createPayoutRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePayout($createPayoutRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePointTransaction
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Create a transaction that adjusts or redeems points from a customer's point account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePointTransactionRequest $createPointTransactionRequest
     * @return \StructType\CreatePointTransactionResponse|bool
     */
    public function CreatePointTransaction(\StructType\CreatePointTransactionRequest $createPointTransactionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePointTransaction($createPointTransactionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVendorBill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new VendorBill for a customer on file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateVendorBillRequest $createVendorBillRequest
     * @return \StructType\CreateVendorBillResponse|bool
     */
    public function CreateVendorBill(\StructType\CreateVendorBillRequest $createVendorBillRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateVendorBill($createVendorBillRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWarehouse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new Warehouse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateWarehouseRequest $createWarehouseRequest
     * @return \StructType\CreateWarehouseResponse|bool
     */
    public function CreateWarehouse(\StructType\CreateWarehouseRequest $createWarehouseRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWarehouse($createWarehouseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWebCategory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Creates a new product web category.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateWebCategoryRequest $createWebCategoryRequest
     * @return \StructType\CreateWebCategoryResponse|bool
     */
    public function CreateWebCategory(\StructType\CreateWebCategoryRequest $createWebCategoryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWebCategory($createWebCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateApiWhitelistResponse|\StructType\CreateAutoOrderResponse|\StructType\CreateBillResponse|\StructType\CreateCalendarItemResponse|\StructType\CreateCustomerBalanceAdjustmentResponse|\StructType\CreateCustomerContactResponse|\StructType\CreateCustomerExtendedResponse|\StructType\CreateCustomerFileResponse|\StructType\CreateCustomerInquiryResponse|\StructType\CreateCustomerLeadResponse|\StructType\CreateCustomerResponse|\StructType\CreateCustomerWallItemResponse|\StructType\CreateEmailResponse|\StructType\CreateEmailTemplateResponse|\StructType\CreateEntityResponse|\StructType\CreateExpectedBankWireResponse|\StructType\CreateExpectedPaymentResponse|\StructType\CreateExtendedDbSchemaResponse|\StructType\CreateGuestResponse|\StructType\CreateItemResponse|\StructType\CreateMailFolderResponse|\StructType\CreateOrderDetailResponse|\StructType\CreateOrderImportResponse|\StructType\CreateOrderResponse|\StructType\CreatePartyResponse|\StructType\CreatePaymentCheckResponse|\StructType\CreatePaymentCreditCardResponse|\StructType\CreatePaymentPointAccountResponse|\StructType\CreatePaymentResponse|\StructType\CreatePayoutResponse|\StructType\CreatePointTransactionResponse|\StructType\CreateVendorBillResponse|\StructType\CreateWarehouseResponse|\StructType\CreateWebCategoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
