<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authorize ServiceType
 * @subpackage Services
 */
class Authorize extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AuthorizeOnlyCreditCardToken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to authorize only a credit card token. A follow up ChargePriorAuthorization will need to be issued to actually capture and settle the authorization.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizeOnlyCreditCardTokenRequest $authorizeOnlyCreditCardTokenRequest
     * @return \StructType\AuthorizeOnlyCreditCardResponse|bool
     */
    public function AuthorizeOnlyCreditCardToken(\StructType\AuthorizeOnlyCreditCardTokenRequest $authorizeOnlyCreditCardTokenRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AuthorizeOnlyCreditCardToken($authorizeOnlyCreditCardTokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AuthorizeOnlyCreditCardTokenOnFile
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Attempts to authorize only a credit card token on file. A follow up ChargePriorAuthorization will need to be issued to actually capture and settle the authorization.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest $authorizeOnlyCreditCardTokenOnFileRequest
     * @return \StructType\AuthorizeOnlyCreditCardResponse|bool
     */
    public function AuthorizeOnlyCreditCardTokenOnFile(\StructType\AuthorizeOnlyCreditCardTokenOnFileRequest $authorizeOnlyCreditCardTokenOnFileRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AuthorizeOnlyCreditCardTokenOnFile($authorizeOnlyCreditCardTokenOnFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthorizeOnlyCreditCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
