<?php

namespace EnumType;

/**
 * This class stands for SandboxType EnumType
 * @subpackage Enumerations
 */
class SandboxType
{
    /**
     * Constant for value 'Sandbox'
     * @return string 'Sandbox'
     */
    const VALUE_SANDBOX = 'Sandbox';
    /**
     * Constant for value 'Commission'
     * @return string 'Commission'
     */
    const VALUE_COMMISSION = 'Commission';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SANDBOX
     * @uses self::VALUE_COMMISSION
     * @uses self::VALUE_PREMIUM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SANDBOX,
            self::VALUE_COMMISSION,
            self::VALUE_PREMIUM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
