<?php

namespace EnumType;

/**
 * This class stands for PaymentType EnumType
 * @subpackage Enumerations
 */
class PaymentType
{
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'CreditVoucher'
     * @return string 'CreditVoucher'
     */
    const VALUE_CREDIT_VOUCHER = 'CreditVoucher';
    /**
     * Constant for value 'Net30'
     * @return string 'Net30'
     */
    const VALUE_NET_30 = 'Net30';
    /**
     * Constant for value 'Net60'
     * @return string 'Net60'
     */
    const VALUE_NET_60 = 'Net60';
    /**
     * Constant for value 'ACHDebit'
     * @return string 'ACHDebit'
     */
    const VALUE_ACHDEBIT = 'ACHDebit';
    /**
     * Constant for value 'UseCredit'
     * @return string 'UseCredit'
     */
    const VALUE_USE_CREDIT = 'UseCredit';
    /**
     * Constant for value 'BankDraft'
     * @return string 'BankDraft'
     */
    const VALUE_BANK_DRAFT = 'BankDraft';
    /**
     * Constant for value 'BankWire'
     * @return string 'BankWire'
     */
    const VALUE_BANK_WIRE = 'BankWire';
    /**
     * Constant for value 'PointRedemtion'
     * @return string 'PointRedemtion'
     */
    const VALUE_POINT_REDEMTION = 'PointRedemtion';
    /**
     * Constant for value 'COD'
     * @return string 'COD'
     */
    const VALUE_COD = 'COD';
    /**
     * Constant for value 'MoneyOrder'
     * @return string 'MoneyOrder'
     */
    const VALUE_MONEY_ORDER = 'MoneyOrder';
    /**
     * Constant for value 'BankDeposit'
     * @return string 'BankDeposit'
     */
    const VALUE_BANK_DEPOSIT = 'BankDeposit';
    /**
     * Constant for value 'Other1'
     * @return string 'Other1'
     */
    const VALUE_OTHER_1 = 'Other1';
    /**
     * Constant for value 'Other2'
     * @return string 'Other2'
     */
    const VALUE_OTHER_2 = 'Other2';
    /**
     * Constant for value 'Other3'
     * @return string 'Other3'
     */
    const VALUE_OTHER_3 = 'Other3';
    /**
     * Constant for value 'Wallet'
     * @return string 'Wallet'
     */
    const VALUE_WALLET = 'Wallet';
    /**
     * Constant for value 'Other4'
     * @return string 'Other4'
     */
    const VALUE_OTHER_4 = 'Other4';
    /**
     * Constant for value 'Other5'
     * @return string 'Other5'
     */
    const VALUE_OTHER_5 = 'Other5';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_CREDIT_VOUCHER
     * @uses self::VALUE_NET_30
     * @uses self::VALUE_NET_60
     * @uses self::VALUE_ACHDEBIT
     * @uses self::VALUE_USE_CREDIT
     * @uses self::VALUE_BANK_DRAFT
     * @uses self::VALUE_BANK_WIRE
     * @uses self::VALUE_POINT_REDEMTION
     * @uses self::VALUE_COD
     * @uses self::VALUE_MONEY_ORDER
     * @uses self::VALUE_BANK_DEPOSIT
     * @uses self::VALUE_OTHER_1
     * @uses self::VALUE_OTHER_2
     * @uses self::VALUE_OTHER_3
     * @uses self::VALUE_WALLET
     * @uses self::VALUE_OTHER_4
     * @uses self::VALUE_OTHER_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASH,
            self::VALUE_CREDIT_CARD,
            self::VALUE_CHECK,
            self::VALUE_CREDIT_VOUCHER,
            self::VALUE_NET_30,
            self::VALUE_NET_60,
            self::VALUE_ACHDEBIT,
            self::VALUE_USE_CREDIT,
            self::VALUE_BANK_DRAFT,
            self::VALUE_BANK_WIRE,
            self::VALUE_POINT_REDEMTION,
            self::VALUE_COD,
            self::VALUE_MONEY_ORDER,
            self::VALUE_BANK_DEPOSIT,
            self::VALUE_OTHER_1,
            self::VALUE_OTHER_2,
            self::VALUE_OTHER_3,
            self::VALUE_WALLET,
            self::VALUE_OTHER_4,
            self::VALUE_OTHER_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
