<?php

namespace EnumType;

/**
 * This class stands for NumericCompareType EnumType
 * @subpackage Enumerations
 */
class NumericCompareType
{
    /**
     * Constant for value 'Equals'
     * @return string 'Equals'
     */
    const VALUE_EQUALS = 'Equals';
    /**
     * Constant for value 'GreaterThan'
     * @return string 'GreaterThan'
     */
    const VALUE_GREATER_THAN = 'GreaterThan';
    /**
     * Constant for value 'LessThan'
     * @return string 'LessThan'
     */
    const VALUE_LESS_THAN = 'LessThan';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUALS
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_LESS_THAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUALS,
            self::VALUE_GREATER_THAN,
            self::VALUE_LESS_THAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
