<?php

namespace EnumType;

/**
 * This class stands for NewsWebSettings EnumType
 * @subpackage Enumerations
 */
class NewsWebSettings
{
    /**
     * Constant for value 'AccessAvailable'
     * @return string 'AccessAvailable'
     */
    const VALUE_ACCESS_AVAILABLE = 'AccessAvailable';
    /**
     * Constant for value 'AccessNotAvailable'
     * @return string 'AccessNotAvailable'
     */
    const VALUE_ACCESS_NOT_AVAILABLE = 'AccessNotAvailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESS_AVAILABLE
     * @uses self::VALUE_ACCESS_NOT_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESS_AVAILABLE,
            self::VALUE_ACCESS_NOT_AVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
