<?php

namespace EnumType;

/**
 * This class stands for NewsCompanySettings EnumType
 * @subpackage Enumerations
 */
class NewsCompanySettings
{
    /**
     * Constant for value 'AccessAllUsers'
     * @return string 'AccessAllUsers'
     */
    const VALUE_ACCESS_ALL_USERS = 'AccessAllUsers';
    /**
     * Constant for value 'AccessByDepartment'
     * @return string 'AccessByDepartment'
     */
    const VALUE_ACCESS_BY_DEPARTMENT = 'AccessByDepartment';
    /**
     * Constant for value 'AccessNotAvailable'
     * @return string 'AccessNotAvailable'
     */
    const VALUE_ACCESS_NOT_AVAILABLE = 'AccessNotAvailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESS_ALL_USERS
     * @uses self::VALUE_ACCESS_BY_DEPARTMENT
     * @uses self::VALUE_ACCESS_NOT_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESS_ALL_USERS,
            self::VALUE_ACCESS_BY_DEPARTMENT,
            self::VALUE_ACCESS_NOT_AVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
