<?php

namespace EnumType;

/**
 * This class stands for CustomerSiteImageType EnumType
 * @subpackage Enumerations
 */
class CustomerSiteImageType
{
    /**
     * Constant for value 'Primary'
     * @return string 'Primary'
     */
    const VALUE_PRIMARY = 'Primary';
    /**
     * Constant for value 'Secondary'
     * @return string 'Secondary'
     */
    const VALUE_SECONDARY = 'Secondary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIMARY
     * @uses self::VALUE_SECONDARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIMARY,
            self::VALUE_SECONDARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
