<?php

namespace EnumType;

/**
 * This class stands for BinaryPlacementType EnumType
 * @subpackage Enumerations
 */
class BinaryPlacementType
{
    /**
     * Constant for value 'StrategicPlacement'
     * @return string 'StrategicPlacement'
     */
    const VALUE_STRATEGIC_PLACEMENT = 'StrategicPlacement';
    /**
     * Constant for value 'BuildLeft'
     * @return string 'BuildLeft'
     */
    const VALUE_BUILD_LEFT = 'BuildLeft';
    /**
     * Constant for value 'BuildRight'
     * @return string 'BuildRight'
     */
    const VALUE_BUILD_RIGHT = 'BuildRight';
    /**
     * Constant for value 'BalancedBuild'
     * @return string 'BalancedBuild'
     */
    const VALUE_BALANCED_BUILD = 'BalancedBuild';
    /**
     * Constant for value 'EvenFill'
     * @return string 'EvenFill'
     */
    const VALUE_EVEN_FILL = 'EvenFill';
    /**
     * Constant for value 'WeakLeg'
     * @return string 'WeakLeg'
     */
    const VALUE_WEAK_LEG = 'WeakLeg';
    /**
     * Constant for value 'EnrollerPreference'
     * @return string 'EnrollerPreference'
     */
    const VALUE_ENROLLER_PREFERENCE = 'EnrollerPreference';
    /**
     * Constant for value 'LeftEvenFill'
     * @return string 'LeftEvenFill'
     */
    const VALUE_LEFT_EVEN_FILL = 'LeftEvenFill';
    /**
     * Constant for value 'RightEvenFill'
     * @return string 'RightEvenFill'
     */
    const VALUE_RIGHT_EVEN_FILL = 'RightEvenFill';
    /**
     * Constant for value 'LesserVolumeLeg'
     * @return string 'LesserVolumeLeg'
     */
    const VALUE_LESSER_VOLUME_LEG = 'LesserVolumeLeg';
    /**
     * Constant for value 'LesserVolumeLegOutside'
     * @return string 'LesserVolumeLegOutside'
     */
    const VALUE_LESSER_VOLUME_LEG_OUTSIDE = 'LesserVolumeLegOutside';
    /**
     * Constant for value 'StrongLegOutside'
     * @return string 'StrongLegOutside'
     */
    const VALUE_STRONG_LEG_OUTSIDE = 'StrongLegOutside';
    /**
     * Constant for value 'LesserVolumeLegEvenFill'
     * @return string 'LesserVolumeLegEvenFill'
     */
    const VALUE_LESSER_VOLUME_LEG_EVEN_FILL = 'LesserVolumeLegEvenFill';
    /**
     * Constant for value 'GreaterVolumeLegEvenFill'
     * @return string 'GreaterVolumeLegEvenFill'
     */
    const VALUE_GREATER_VOLUME_LEG_EVEN_FILL = 'GreaterVolumeLegEvenFill';
    /**
     * Constant for value 'InsertRightMoveDownline'
     * @return string 'InsertRightMoveDownline'
     */
    const VALUE_INSERT_RIGHT_MOVE_DOWNLINE = 'InsertRightMoveDownline';
    /**
     * Constant for value 'InsertLeftMoveDownline'
     * @return string 'InsertLeftMoveDownline'
     */
    const VALUE_INSERT_LEFT_MOVE_DOWNLINE = 'InsertLeftMoveDownline';
    /**
     * Constant for value 'BuildTeamLeg'
     * @return string 'BuildTeamLeg'
     */
    const VALUE_BUILD_TEAM_LEG = 'BuildTeamLeg';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRATEGIC_PLACEMENT
     * @uses self::VALUE_BUILD_LEFT
     * @uses self::VALUE_BUILD_RIGHT
     * @uses self::VALUE_BALANCED_BUILD
     * @uses self::VALUE_EVEN_FILL
     * @uses self::VALUE_WEAK_LEG
     * @uses self::VALUE_ENROLLER_PREFERENCE
     * @uses self::VALUE_LEFT_EVEN_FILL
     * @uses self::VALUE_RIGHT_EVEN_FILL
     * @uses self::VALUE_LESSER_VOLUME_LEG
     * @uses self::VALUE_LESSER_VOLUME_LEG_OUTSIDE
     * @uses self::VALUE_STRONG_LEG_OUTSIDE
     * @uses self::VALUE_LESSER_VOLUME_LEG_EVEN_FILL
     * @uses self::VALUE_GREATER_VOLUME_LEG_EVEN_FILL
     * @uses self::VALUE_INSERT_RIGHT_MOVE_DOWNLINE
     * @uses self::VALUE_INSERT_LEFT_MOVE_DOWNLINE
     * @uses self::VALUE_BUILD_TEAM_LEG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRATEGIC_PLACEMENT,
            self::VALUE_BUILD_LEFT,
            self::VALUE_BUILD_RIGHT,
            self::VALUE_BALANCED_BUILD,
            self::VALUE_EVEN_FILL,
            self::VALUE_WEAK_LEG,
            self::VALUE_ENROLLER_PREFERENCE,
            self::VALUE_LEFT_EVEN_FILL,
            self::VALUE_RIGHT_EVEN_FILL,
            self::VALUE_LESSER_VOLUME_LEG,
            self::VALUE_LESSER_VOLUME_LEG_OUTSIDE,
            self::VALUE_STRONG_LEG_OUTSIDE,
            self::VALUE_LESSER_VOLUME_LEG_EVEN_FILL,
            self::VALUE_GREATER_VOLUME_LEG_EVEN_FILL,
            self::VALUE_INSERT_RIGHT_MOVE_DOWNLINE,
            self::VALUE_INSERT_LEFT_MOVE_DOWNLINE,
            self::VALUE_BUILD_TEAM_LEG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
