<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVolumeResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfVolumeResponse extends AbstractStructArrayBase
{
    /**
     * The VolumeResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VolumeResponse[]
     */
    public $VolumeResponse;
    /**
     * Constructor method for ArrayOfVolumeResponse
     * @uses ArrayOfVolumeResponse::setVolumeResponse()
     * @param \StructType\VolumeResponse[] $volumeResponse
     */
    public function __construct(array $volumeResponse = array())
    {
        $this
            ->setVolumeResponse($volumeResponse);
    }
    /**
     * Get VolumeResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VolumeResponse[]|null
     */
    public function getVolumeResponse()
    {
        return isset($this->VolumeResponse) ? $this->VolumeResponse : null;
    }
    /**
     * Set VolumeResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VolumeResponse[] $volumeResponse
     * @return \ArrayType\ArrayOfVolumeResponse
     */
    public function setVolumeResponse(array $volumeResponse = array())
    {
        foreach ($volumeResponse as $arrayOfVolumeResponseVolumeResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfVolumeResponseVolumeResponseItem instanceof \StructType\VolumeResponse) {
                throw new \InvalidArgumentException(sprintf('The VolumeResponse property can only contain items of \StructType\VolumeResponse, "%s" given', is_object($arrayOfVolumeResponseVolumeResponseItem) ? get_class($arrayOfVolumeResponseVolumeResponseItem) : gettype($arrayOfVolumeResponseVolumeResponseItem)), __LINE__);
            }
        }
        if (is_null($volumeResponse) || (is_array($volumeResponse) && empty($volumeResponse))) {
            unset($this->VolumeResponse);
        } else {
            $this->VolumeResponse = $volumeResponse;
        }
        return $this;
    }
    /**
     * Add item to VolumeResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\VolumeResponse $item
     * @return \ArrayType\ArrayOfVolumeResponse
     */
    public function addToVolumeResponse(\StructType\VolumeResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VolumeResponse) {
            throw new \InvalidArgumentException(sprintf('The VolumeResponse property can only contain items of \StructType\VolumeResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VolumeResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VolumeResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VolumeResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VolumeResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VolumeResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VolumeResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VolumeResponse
     */
    public function getAttributeName()
    {
        return 'VolumeResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVolumeResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
