<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQualificationResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfQualificationResponse extends AbstractStructArrayBase
{
    /**
     * The QualificationResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QualificationResponse[]
     */
    public $QualificationResponse;
    /**
     * Constructor method for ArrayOfQualificationResponse
     * @uses ArrayOfQualificationResponse::setQualificationResponse()
     * @param \StructType\QualificationResponse[] $qualificationResponse
     */
    public function __construct(array $qualificationResponse = array())
    {
        $this
            ->setQualificationResponse($qualificationResponse);
    }
    /**
     * Get QualificationResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QualificationResponse[]|null
     */
    public function getQualificationResponse()
    {
        return isset($this->QualificationResponse) ? $this->QualificationResponse : null;
    }
    /**
     * Set QualificationResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QualificationResponse[] $qualificationResponse
     * @return \ArrayType\ArrayOfQualificationResponse
     */
    public function setQualificationResponse(array $qualificationResponse = array())
    {
        foreach ($qualificationResponse as $arrayOfQualificationResponseQualificationResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfQualificationResponseQualificationResponseItem instanceof \StructType\QualificationResponse) {
                throw new \InvalidArgumentException(sprintf('The QualificationResponse property can only contain items of \StructType\QualificationResponse, "%s" given', is_object($arrayOfQualificationResponseQualificationResponseItem) ? get_class($arrayOfQualificationResponseQualificationResponseItem) : gettype($arrayOfQualificationResponseQualificationResponseItem)), __LINE__);
            }
        }
        if (is_null($qualificationResponse) || (is_array($qualificationResponse) && empty($qualificationResponse))) {
            unset($this->QualificationResponse);
        } else {
            $this->QualificationResponse = $qualificationResponse;
        }
        return $this;
    }
    /**
     * Add item to QualificationResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\QualificationResponse $item
     * @return \ArrayType\ArrayOfQualificationResponse
     */
    public function addToQualificationResponse(\StructType\QualificationResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QualificationResponse) {
            throw new \InvalidArgumentException(sprintf('The QualificationResponse property can only contain items of \StructType\QualificationResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QualificationResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QualificationResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QualificationResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QualificationResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QualificationResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QualificationResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QualificationResponse
     */
    public function getAttributeName()
    {
        return 'QualificationResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfQualificationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
