<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetailRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDetailRequest extends AbstractStructArrayBase
{
    /**
     * The OrderDetailRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderDetailRequest[]
     */
    public $OrderDetailRequest;
    /**
     * Constructor method for ArrayOfOrderDetailRequest
     * @uses ArrayOfOrderDetailRequest::setOrderDetailRequest()
     * @param \StructType\OrderDetailRequest[] $orderDetailRequest
     */
    public function __construct(array $orderDetailRequest = array())
    {
        $this
            ->setOrderDetailRequest($orderDetailRequest);
    }
    /**
     * Get OrderDetailRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderDetailRequest[]|null
     */
    public function getOrderDetailRequest()
    {
        return isset($this->OrderDetailRequest) ? $this->OrderDetailRequest : null;
    }
    /**
     * Set OrderDetailRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetailRequest[] $orderDetailRequest
     * @return \ArrayType\ArrayOfOrderDetailRequest
     */
    public function setOrderDetailRequest(array $orderDetailRequest = array())
    {
        foreach ($orderDetailRequest as $arrayOfOrderDetailRequestOrderDetailRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailRequestOrderDetailRequestItem instanceof \StructType\OrderDetailRequest) {
                throw new \InvalidArgumentException(sprintf('The OrderDetailRequest property can only contain items of \StructType\OrderDetailRequest, "%s" given', is_object($arrayOfOrderDetailRequestOrderDetailRequestItem) ? get_class($arrayOfOrderDetailRequestOrderDetailRequestItem) : gettype($arrayOfOrderDetailRequestOrderDetailRequestItem)), __LINE__);
            }
        }
        if (is_null($orderDetailRequest) || (is_array($orderDetailRequest) && empty($orderDetailRequest))) {
            unset($this->OrderDetailRequest);
        } else {
            $this->OrderDetailRequest = $orderDetailRequest;
        }
        return $this;
    }
    /**
     * Add item to OrderDetailRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetailRequest $item
     * @return \ArrayType\ArrayOfOrderDetailRequest
     */
    public function addToOrderDetailRequest(\StructType\OrderDetailRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderDetailRequest) {
            throw new \InvalidArgumentException(sprintf('The OrderDetailRequest property can only contain items of \StructType\OrderDetailRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderDetailRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderDetailRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderDetailRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderDetailRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderDetailRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderDetailRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderDetailRequest
     */
    public function getAttributeName()
    {
        return 'OrderDetailRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
