<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderBatchDetailRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderBatchDetailRequest extends AbstractStructArrayBase
{
    /**
     * The OrderBatchDetailRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderBatchDetailRequest[]
     */
    public $OrderBatchDetailRequest;
    /**
     * Constructor method for ArrayOfOrderBatchDetailRequest
     * @uses ArrayOfOrderBatchDetailRequest::setOrderBatchDetailRequest()
     * @param \StructType\OrderBatchDetailRequest[] $orderBatchDetailRequest
     */
    public function __construct(array $orderBatchDetailRequest = array())
    {
        $this
            ->setOrderBatchDetailRequest($orderBatchDetailRequest);
    }
    /**
     * Get OrderBatchDetailRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderBatchDetailRequest[]|null
     */
    public function getOrderBatchDetailRequest()
    {
        return isset($this->OrderBatchDetailRequest) ? $this->OrderBatchDetailRequest : null;
    }
    /**
     * Set OrderBatchDetailRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderBatchDetailRequest[] $orderBatchDetailRequest
     * @return \ArrayType\ArrayOfOrderBatchDetailRequest
     */
    public function setOrderBatchDetailRequest(array $orderBatchDetailRequest = array())
    {
        foreach ($orderBatchDetailRequest as $arrayOfOrderBatchDetailRequestOrderBatchDetailRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderBatchDetailRequestOrderBatchDetailRequestItem instanceof \StructType\OrderBatchDetailRequest) {
                throw new \InvalidArgumentException(sprintf('The OrderBatchDetailRequest property can only contain items of \StructType\OrderBatchDetailRequest, "%s" given', is_object($arrayOfOrderBatchDetailRequestOrderBatchDetailRequestItem) ? get_class($arrayOfOrderBatchDetailRequestOrderBatchDetailRequestItem) : gettype($arrayOfOrderBatchDetailRequestOrderBatchDetailRequestItem)), __LINE__);
            }
        }
        if (is_null($orderBatchDetailRequest) || (is_array($orderBatchDetailRequest) && empty($orderBatchDetailRequest))) {
            unset($this->OrderBatchDetailRequest);
        } else {
            $this->OrderBatchDetailRequest = $orderBatchDetailRequest;
        }
        return $this;
    }
    /**
     * Add item to OrderBatchDetailRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderBatchDetailRequest $item
     * @return \ArrayType\ArrayOfOrderBatchDetailRequest
     */
    public function addToOrderBatchDetailRequest(\StructType\OrderBatchDetailRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderBatchDetailRequest) {
            throw new \InvalidArgumentException(sprintf('The OrderBatchDetailRequest property can only contain items of \StructType\OrderBatchDetailRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderBatchDetailRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderBatchDetailRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderBatchDetailRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderBatchDetailRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderBatchDetailRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderBatchDetailRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderBatchDetailRequest
     */
    public function getAttributeName()
    {
        return 'OrderBatchDetailRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderBatchDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
