<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNavigation ArrayType
 * @subpackage Arrays
 */
class ArrayOfNavigation extends AbstractStructArrayBase
{
    /**
     * The Navigation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Navigation[]
     */
    public $Navigation;
    /**
     * Constructor method for ArrayOfNavigation
     * @uses ArrayOfNavigation::setNavigation()
     * @param \StructType\Navigation[] $navigation
     */
    public function __construct(array $navigation = array())
    {
        $this
            ->setNavigation($navigation);
    }
    /**
     * Get Navigation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Navigation[]|null
     */
    public function getNavigation()
    {
        return isset($this->Navigation) ? $this->Navigation : null;
    }
    /**
     * Set Navigation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Navigation[] $navigation
     * @return \ArrayType\ArrayOfNavigation
     */
    public function setNavigation(array $navigation = array())
    {
        foreach ($navigation as $arrayOfNavigationNavigationItem) {
            // validation for constraint: itemType
            if (!$arrayOfNavigationNavigationItem instanceof \StructType\Navigation) {
                throw new \InvalidArgumentException(sprintf('The Navigation property can only contain items of \StructType\Navigation, "%s" given', is_object($arrayOfNavigationNavigationItem) ? get_class($arrayOfNavigationNavigationItem) : gettype($arrayOfNavigationNavigationItem)), __LINE__);
            }
        }
        if (is_null($navigation) || (is_array($navigation) && empty($navigation))) {
            unset($this->Navigation);
        } else {
            $this->Navigation = $navigation;
        }
        return $this;
    }
    /**
     * Add item to Navigation value
     * @throws \InvalidArgumentException
     * @param \StructType\Navigation $item
     * @return \ArrayType\ArrayOfNavigation
     */
    public function addToNavigation(\StructType\Navigation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Navigation) {
            throw new \InvalidArgumentException(sprintf('The Navigation property can only contain items of \StructType\Navigation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Navigation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Navigation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Navigation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Navigation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Navigation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Navigation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Navigation
     */
    public function getAttributeName()
    {
        return 'Navigation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNavigation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
