<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLanguageResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfLanguageResponse extends AbstractStructArrayBase
{
    /**
     * The LanguageResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LanguageResponse[]
     */
    public $LanguageResponse;
    /**
     * Constructor method for ArrayOfLanguageResponse
     * @uses ArrayOfLanguageResponse::setLanguageResponse()
     * @param \StructType\LanguageResponse[] $languageResponse
     */
    public function __construct(array $languageResponse = array())
    {
        $this
            ->setLanguageResponse($languageResponse);
    }
    /**
     * Get LanguageResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LanguageResponse[]|null
     */
    public function getLanguageResponse()
    {
        return isset($this->LanguageResponse) ? $this->LanguageResponse : null;
    }
    /**
     * Set LanguageResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageResponse[] $languageResponse
     * @return \ArrayType\ArrayOfLanguageResponse
     */
    public function setLanguageResponse(array $languageResponse = array())
    {
        foreach ($languageResponse as $arrayOfLanguageResponseLanguageResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfLanguageResponseLanguageResponseItem instanceof \StructType\LanguageResponse) {
                throw new \InvalidArgumentException(sprintf('The LanguageResponse property can only contain items of \StructType\LanguageResponse, "%s" given', is_object($arrayOfLanguageResponseLanguageResponseItem) ? get_class($arrayOfLanguageResponseLanguageResponseItem) : gettype($arrayOfLanguageResponseLanguageResponseItem)), __LINE__);
            }
        }
        if (is_null($languageResponse) || (is_array($languageResponse) && empty($languageResponse))) {
            unset($this->LanguageResponse);
        } else {
            $this->LanguageResponse = $languageResponse;
        }
        return $this;
    }
    /**
     * Add item to LanguageResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageResponse $item
     * @return \ArrayType\ArrayOfLanguageResponse
     */
    public function addToLanguageResponse(\StructType\LanguageResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LanguageResponse) {
            throw new \InvalidArgumentException(sprintf('The LanguageResponse property can only contain items of \StructType\LanguageResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LanguageResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LanguageResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LanguageResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LanguageResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LanguageResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LanguageResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LanguageResponse
     */
    public function getAttributeName()
    {
        return 'LanguageResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLanguageResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
