<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKitMember ArrayType
 * @subpackage Arrays
 */
class ArrayOfKitMember extends AbstractStructArrayBase
{
    /**
     * The KitMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitMember[]
     */
    public $KitMember;
    /**
     * Constructor method for ArrayOfKitMember
     * @uses ArrayOfKitMember::setKitMember()
     * @param \StructType\KitMember[] $kitMember
     */
    public function __construct(array $kitMember = array())
    {
        $this
            ->setKitMember($kitMember);
    }
    /**
     * Get KitMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitMember[]|null
     */
    public function getKitMember()
    {
        return isset($this->KitMember) ? $this->KitMember : null;
    }
    /**
     * Set KitMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitMember[] $kitMember
     * @return \ArrayType\ArrayOfKitMember
     */
    public function setKitMember(array $kitMember = array())
    {
        foreach ($kitMember as $arrayOfKitMemberKitMemberItem) {
            // validation for constraint: itemType
            if (!$arrayOfKitMemberKitMemberItem instanceof \StructType\KitMember) {
                throw new \InvalidArgumentException(sprintf('The KitMember property can only contain items of \StructType\KitMember, "%s" given', is_object($arrayOfKitMemberKitMemberItem) ? get_class($arrayOfKitMemberKitMemberItem) : gettype($arrayOfKitMemberKitMemberItem)), __LINE__);
            }
        }
        if (is_null($kitMember) || (is_array($kitMember) && empty($kitMember))) {
            unset($this->KitMember);
        } else {
            $this->KitMember = $kitMember;
        }
        return $this;
    }
    /**
     * Add item to KitMember value
     * @throws \InvalidArgumentException
     * @param \StructType\KitMember $item
     * @return \ArrayType\ArrayOfKitMember
     */
    public function addToKitMember(\StructType\KitMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitMember) {
            throw new \InvalidArgumentException(sprintf('The KitMember property can only contain items of \StructType\KitMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitMember[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\KitMember|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\KitMember|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\KitMember|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\KitMember|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\KitMember|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KitMember
     */
    public function getAttributeName()
    {
        return 'KitMember';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfKitMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
