<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDepartmentInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfDepartmentInfo extends AbstractStructArrayBase
{
    /**
     * The DepartmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DepartmentInfo[]
     */
    public $DepartmentInfo;
    /**
     * Constructor method for ArrayOfDepartmentInfo
     * @uses ArrayOfDepartmentInfo::setDepartmentInfo()
     * @param \StructType\DepartmentInfo[] $departmentInfo
     */
    public function __construct(array $departmentInfo = array())
    {
        $this
            ->setDepartmentInfo($departmentInfo);
    }
    /**
     * Get DepartmentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DepartmentInfo[]|null
     */
    public function getDepartmentInfo()
    {
        return isset($this->DepartmentInfo) ? $this->DepartmentInfo : null;
    }
    /**
     * Set DepartmentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DepartmentInfo[] $departmentInfo
     * @return \ArrayType\ArrayOfDepartmentInfo
     */
    public function setDepartmentInfo(array $departmentInfo = array())
    {
        foreach ($departmentInfo as $arrayOfDepartmentInfoDepartmentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDepartmentInfoDepartmentInfoItem instanceof \StructType\DepartmentInfo) {
                throw new \InvalidArgumentException(sprintf('The DepartmentInfo property can only contain items of \StructType\DepartmentInfo, "%s" given', is_object($arrayOfDepartmentInfoDepartmentInfoItem) ? get_class($arrayOfDepartmentInfoDepartmentInfoItem) : gettype($arrayOfDepartmentInfoDepartmentInfoItem)), __LINE__);
            }
        }
        if (is_null($departmentInfo) || (is_array($departmentInfo) && empty($departmentInfo))) {
            unset($this->DepartmentInfo);
        } else {
            $this->DepartmentInfo = $departmentInfo;
        }
        return $this;
    }
    /**
     * Add item to DepartmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DepartmentInfo $item
     * @return \ArrayType\ArrayOfDepartmentInfo
     */
    public function addToDepartmentInfo(\StructType\DepartmentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepartmentInfo) {
            throw new \InvalidArgumentException(sprintf('The DepartmentInfo property can only contain items of \StructType\DepartmentInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DepartmentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DepartmentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DepartmentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DepartmentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DepartmentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DepartmentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DepartmentInfo
     */
    public function getAttributeName()
    {
        return 'DepartmentInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDepartmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
