<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerLeadSocialNetworkRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerLeadSocialNetworkRequest extends AbstractStructArrayBase
{
    /**
     * The CustomerLeadSocialNetworkRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerLeadSocialNetworkRequest[]
     */
    public $CustomerLeadSocialNetworkRequest;
    /**
     * Constructor method for ArrayOfCustomerLeadSocialNetworkRequest
     * @uses ArrayOfCustomerLeadSocialNetworkRequest::setCustomerLeadSocialNetworkRequest()
     * @param \StructType\CustomerLeadSocialNetworkRequest[] $customerLeadSocialNetworkRequest
     */
    public function __construct(array $customerLeadSocialNetworkRequest = array())
    {
        $this
            ->setCustomerLeadSocialNetworkRequest($customerLeadSocialNetworkRequest);
    }
    /**
     * Get CustomerLeadSocialNetworkRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerLeadSocialNetworkRequest[]|null
     */
    public function getCustomerLeadSocialNetworkRequest()
    {
        return isset($this->CustomerLeadSocialNetworkRequest) ? $this->CustomerLeadSocialNetworkRequest : null;
    }
    /**
     * Set CustomerLeadSocialNetworkRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLeadSocialNetworkRequest[] $customerLeadSocialNetworkRequest
     * @return \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest
     */
    public function setCustomerLeadSocialNetworkRequest(array $customerLeadSocialNetworkRequest = array())
    {
        foreach ($customerLeadSocialNetworkRequest as $arrayOfCustomerLeadSocialNetworkRequestCustomerLeadSocialNetworkRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerLeadSocialNetworkRequestCustomerLeadSocialNetworkRequestItem instanceof \StructType\CustomerLeadSocialNetworkRequest) {
                throw new \InvalidArgumentException(sprintf('The CustomerLeadSocialNetworkRequest property can only contain items of \StructType\CustomerLeadSocialNetworkRequest, "%s" given', is_object($arrayOfCustomerLeadSocialNetworkRequestCustomerLeadSocialNetworkRequestItem) ? get_class($arrayOfCustomerLeadSocialNetworkRequestCustomerLeadSocialNetworkRequestItem) : gettype($arrayOfCustomerLeadSocialNetworkRequestCustomerLeadSocialNetworkRequestItem)), __LINE__);
            }
        }
        if (is_null($customerLeadSocialNetworkRequest) || (is_array($customerLeadSocialNetworkRequest) && empty($customerLeadSocialNetworkRequest))) {
            unset($this->CustomerLeadSocialNetworkRequest);
        } else {
            $this->CustomerLeadSocialNetworkRequest = $customerLeadSocialNetworkRequest;
        }
        return $this;
    }
    /**
     * Add item to CustomerLeadSocialNetworkRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLeadSocialNetworkRequest $item
     * @return \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest
     */
    public function addToCustomerLeadSocialNetworkRequest(\StructType\CustomerLeadSocialNetworkRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerLeadSocialNetworkRequest) {
            throw new \InvalidArgumentException(sprintf('The CustomerLeadSocialNetworkRequest property can only contain items of \StructType\CustomerLeadSocialNetworkRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerLeadSocialNetworkRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerLeadSocialNetworkRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerLeadSocialNetworkRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerLeadSocialNetworkRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerLeadSocialNetworkRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerLeadSocialNetworkRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerLeadSocialNetworkRequest
     */
    public function getAttributeName()
    {
        return 'CustomerLeadSocialNetworkRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerLeadSocialNetworkRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
