<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerFilesResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerFilesResponse extends AbstractStructArrayBase
{
    /**
     * The CustomerFilesResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerFilesResponse[]
     */
    public $CustomerFilesResponse;
    /**
     * Constructor method for ArrayOfCustomerFilesResponse
     * @uses ArrayOfCustomerFilesResponse::setCustomerFilesResponse()
     * @param \StructType\CustomerFilesResponse[] $customerFilesResponse
     */
    public function __construct(array $customerFilesResponse = array())
    {
        $this
            ->setCustomerFilesResponse($customerFilesResponse);
    }
    /**
     * Get CustomerFilesResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerFilesResponse[]|null
     */
    public function getCustomerFilesResponse()
    {
        return isset($this->CustomerFilesResponse) ? $this->CustomerFilesResponse : null;
    }
    /**
     * Set CustomerFilesResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerFilesResponse[] $customerFilesResponse
     * @return \ArrayType\ArrayOfCustomerFilesResponse
     */
    public function setCustomerFilesResponse(array $customerFilesResponse = array())
    {
        foreach ($customerFilesResponse as $arrayOfCustomerFilesResponseCustomerFilesResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerFilesResponseCustomerFilesResponseItem instanceof \StructType\CustomerFilesResponse) {
                throw new \InvalidArgumentException(sprintf('The CustomerFilesResponse property can only contain items of \StructType\CustomerFilesResponse, "%s" given', is_object($arrayOfCustomerFilesResponseCustomerFilesResponseItem) ? get_class($arrayOfCustomerFilesResponseCustomerFilesResponseItem) : gettype($arrayOfCustomerFilesResponseCustomerFilesResponseItem)), __LINE__);
            }
        }
        if (is_null($customerFilesResponse) || (is_array($customerFilesResponse) && empty($customerFilesResponse))) {
            unset($this->CustomerFilesResponse);
        } else {
            $this->CustomerFilesResponse = $customerFilesResponse;
        }
        return $this;
    }
    /**
     * Add item to CustomerFilesResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerFilesResponse $item
     * @return \ArrayType\ArrayOfCustomerFilesResponse
     */
    public function addToCustomerFilesResponse(\StructType\CustomerFilesResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerFilesResponse) {
            throw new \InvalidArgumentException(sprintf('The CustomerFilesResponse property can only contain items of \StructType\CustomerFilesResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerFilesResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerFilesResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerFilesResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerFilesResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerFilesResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerFilesResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerFilesResponse
     */
    public function getAttributeName()
    {
        return 'CustomerFilesResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerFilesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
